// pages/mine/mine.js

let app = getApp()

Page({

  /**
   * 页面的初始数据
   */
  data: {
    outNum: 0,
    isLogin: false,
    photo: '',
    isMember: 0,
    account: '',
    address: '',
    businessCardPhotos: [],
    housePhotos: [],
    images: []
  },

  /**
   * 退出显示计数
   */
  outNumUp: function () {
    let num = this.data.outNum
    if (num >= 23) {
      num = 0
    } else {
      num = num + 1
    }
    this.setData({
      outNum: num
    })
  },

  /**
   * 退出登录
   */
  loginOut: function() {
    wx.removeStorage({
      key: 'admin',
      success: res => {
        this.setData({
          isLogin: false
        })
        app.state.admin.account = ''
        app.state.admin.address = ''
        app.state.admin.businessCardPhotos = null
        app.state.admin.contact = ''
        app.state.admin.customerAccountId = 0
        app.state.admin.housePhotos = null
        app.state.admin.images = null
        app.state.admin.isMember = 0
        app.state.admin.name = ''
        app.state.admin.photo = ''
        app.state.admin.secretKey = ''
        app.state.admin.token = ''
        app.state.admin.id = ''
      }
    })
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function(options) {
    if (wx.getStorageSync('admin')) {
      this.setData({
        isLogin: true,
        photo: app.state.admin.photo === null ? '' : app.state.admin.photo,
        isMember: app.state.admin.isMember,
        account: app.state.admin.account,
        address: app.state.admin.address,
        businessCardPhotos: app.state.admin.businessCardPhotos === null ? [] : app.state.admin.businessCardPhotos,
        housePhotos: app.state.admin.housePhotos === null ? [] : app.state.admin.housePhotos,
        images: app.state.admin.images === null ? [] : app.state.admin.images
      })
    }
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function() {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function() {
    if (wx.getStorageSync('admin')) {
      this.setData({
        isLogin: true,
        photo: app.state.admin.photo === null ? '' : app.state.admin.photo,
        isMember: app.state.admin.isMember,
        account: app.state.admin.account,
        address: app.state.admin.address,
        businessCardPhotos: app.state.admin.businessCardPhotos === null ? [] : app.state.admin.businessCardPhotos,
        housePhotos: app.state.admin.housePhotos === null ? [] : app.state.admin.housePhotos,
        images: app.state.admin.images === null ? [] : app.state.admin.images
      })
    }
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function() {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function() {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function() {
    wx.stopPullDownRefresh();
  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function() {

  }
})