// pages/product/productDetail/productDetail.js
let app = getApp();
var WxParse = require('../../wxParse/wxParse.js');
var util = require('../../../utils/util.js')
Page({

  /**
   * 页面的初始数据
   */
  data: {
    proId:'',
    tcid:null,
    code:'',
    createBy:'',
    Price:0,           //成交价格
    TC_Price:0,        // 根据是否是会员的价格
    infolist:{},
    peopleNum:0,
    content:'',
    selection:false,
    admin:'',
    phoneshow:true,
    isMember:null, //是否是会员
    telephone:false,//是否后台有这个电话号码
    data: {},
    Phonedata:{},  //根据电话号码返回的值
    Detaildata:{},  //获取详情数据
    openid:'',
  },
  Applicat:function(){
    wx.navigateTo({
      url: './Applicationnotes/Applicationnotes',
    })
  }, 
  /**
   * 人数减
   */
  numLeft: function (e) {
    let name = e.currentTarget.dataset.name
    let num = this.data.peopleNum
    if (num * 1 !== 0) {
      this.setData({
        peopleNum: num * 1 - 1
      })
    }
  },
  /**
   * 人数加
   */
  numRight: function (e) {
    let name = e.currentTarget.dataset.name
    let num = this.data.peopleNum
    this.setData({
      peopleNum: num * 1 + 1
    })
  },
  //预计提成
  bindKeyInput:function(e){
    this.setData({
      peopleNum: e.detail.value
    })
  },

  selectionimg:function(){
    let selection = this.data.selection
    if (selection==false){
      this.setData({
        selection:true
      })
    }
    if (selection == true) {
      this.setData({
        selection: false
      })
    }
  },
  phone:function(e){
    if (e.detail.value.length == 11){
      app.$api('miniProgram_customer_GetCustomerByPhone', { code: this.data.code, Contact: e.detail.value, openid: this.data.openid}).then(res => {
        this.setData({ telephone: true, isMember: res.isMember, Phonedata: res})
      }).catch(err => {
        this.setData({ telephone: false })
        wx.showToast({
          title: err.message,
          icon: 'none',
          duration: 2000
        })
      })
    } else if (e.detail.value.length != 11){
      this.setData({ telephone: false,})
    }
      this.setData({
        content: e.detail.value,
      })
  },
  qr:function(){
    if (this.data.isMember != null && this.data.isMember == 1) {
      this.setData({
        TC_Price: this.data.Detaildata.B2BMemberPrice
      })
    } else {
      this.setData({
        TC_Price: this.data.Detaildata.B2BPrice
      })
    }


    if (this.data.peopleNum >0){
      app.$api('sellorder_get_GetOrderMinPrice', { ltID: this.data.Detaildata.ltID, Num: this.data.peopleNum }).then(res => {
        let SPrice = res;
        let yjtc = this.data.peopleNum * this.data.Price + (this.data.Detaildata.OtherPrice + this.data.Detaildata.VisaPrice) * this.data.peopleNum;
        // let PriceSpread = this.data.Price - (this.data.TC_Price - SPrice);
        // let ExtraCommission = PriceSpread > 0 ? PriceSpread.toFixed(2) * 0.5 : PriceSpread;
        // let Commission = (Number(yjtc * 0.01) + Number(ExtraCommission)).toFixed(2);
      
        let msg = {
          OrderId: 0,
          TCID: this.data.tcid,
          CustomerType: this.data.isMember,
          GroupType: 1,
          ContactName: this.data.Phonedata.Contact,
          ContactMobile: this.data.Phonedata.ContactNumber,
          CustomerId: this.data.Phonedata.id,
          DepartureCityId: this.data.Detaildata.StartCityID,  //出发城市
          IsIntermodal: 0, //是否联运  1是   2否
          Unit_Price: this.data.Price,  //成交单价 分享出来的
          TC_Price: this.data.TC_Price,   //根据会员给的价格
          ManNum: this.data.peopleNum,
          ChirdNum: 0,
          ChirdNeedBedNum: 0,
          BabyNum: 0,
          OldPeopleNum: 0,
          SingleRoomNum: 0,
          PreferPrice: yjtc,
          DiscountMoney: 0,
          CouponAllotIds: '',
          YSeatNum: this.data.peopleNum,//人数
          ESeatNum: 0,
          FSeatNum: 0,
          Commission: 0, //预计提成
          ClientSource: 2,
          BrandId: 0,
          TradeWay: 0, //交易方式
          PlatformOrder: '', //平台单号
          GuestNum: this.data.peopleNum, //客人总数  人数
          IsChildrenTour: this.data.Detaildata.IsSupportChildren,  //是否支持儿童游玩  1是   2否
          IsBirdDiscount: 2, //是否享用早鸟优惠  1是   2否  ????
          PredictRoomNum: this.data.peopleNum / 2,
          BigRoomNum: 0, //大床房
          TripleRoomNum: 0, //三人房
          TradeDate: util.formatTime(new Date()), //交易日期 当前日期日期
          CostType: 0, //费用类型  
          MinOrderPrice: 0,
          Remarks: '',
          VisaNum: this.data.peopleNum, //人数
          SafeNum: this.data.peopleNum,
          AirticketNum: 0,
          ReturnArriveCityId: this.data.Detaildata.ReturnArriveCityId, //返回抵达城市
          IsReturnIntermodal: 0,
          GoCityTime: "",
          BackCityTime: '',
          ScenicRefundArr: [],
          CommissionSharePeople: 0,
          CommissionShareMoney: 0,
          OrderSource: 2,
          OrderForm: 4,
          CustomerCreateBy: this.data.createBy,

        }
    
        //提交数据
        let that = this;
        let data = that.data.Phonedata.contactNumber;
        app.$api('sellorder_post_SetOrderInfoForB2B', msg).then(res => {
          wx.reLaunch({    //保留当前页面，跳转到应用内的某个页面（最多打开5个页面，之后按钮就没有响应的）
            url: "./Successview/Successview?contactNumber="+data
          })
        }).catch(err => {
        
        })

      }).catch(err => {
        
      })
    }else{
      wx.showToast({
        title: '报名人数大于0',
        icon: 'none',
        duration: 1000
      })
      return
    }
  },
  getDetail: function (id){

    app.$api('miniProgram_price_GetTravelEntity', { TCID: id }).then(res => {
      
      this.setData({
        Detaildata: res,
       })
     
    }).catch(err => {
      
    })
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options){
    wx.login({
      success: res => {
        this.setData({ code : res.code})
        if (res.code) {
          app.$api('miniProgram_customer_LoginByMinOpenId', { code: res.code }).then(res => {
            this.setData({ data: res, phoneshow: false, isMember: res.isMember, openid: res.openid, telephone: true, Phonedata:res})
           
          }).catch(err => {
            this.setData({ data: err.data, phoneshow: true, isMember: err.data.isMember, openid: err.data.openid})
          
          })
         
        } else {
          wx.showToast({
            title: '获取用户信息失败',
            icon: 'none',
            duration: 1000
          })
        }
      }
    })

    //解析分享带过来的参数options
    let scene = JSON.stringify(options);
    let obj = JSON.parse(scene)
    if (obj !== 'undefined') {

      let createBy = obj.createBy
      let tcId = obj.tcId
      let configId = obj.configId
      let price = obj.price
      //测试数据
      // let createBy = '1790'
      // let tcId = '3649'
      // let configId = '2470'
      // let price = '10000'

      this.setData({
        createBy: createBy,
        tcid: tcId,
        proId: configId,
        Price: price
      })
      this.getDetail(tcId)
    } else {
      this.setData({
        isMember: app.state.admin.isMember,
        proId: options.id,
        tcid: options.tcid ? parseInt(options.tcid) : null
      })
      let tcid = options.tcid ? parseInt(options.tcid) : null;
      this.getDetail(tcid)
    }
    wx.setNavigationBarTitle({
      title: '同业预留占位确认'
    })
  }
  
})
