// pages/product/productCheck/productCheck.js

let app = getApp();

Page({

  /**
   * 页面的初始数据
   */
  data: {
    isMember: 0,
    showMore: true,
    pageState: 1,
    inputValue: '',
    pageIndex: 0,
    pageCount: 0,
    itemList: [],
    storageList: [],
    hotList: [],
    account: ""
  },

  /**
   * 按钮触发搜索事件
   */
  btnCheck: function (e) {
    this.setData({
      inputValue: e.currentTarget.dataset.name,
      pageIndex: 0,
      pageCount: 0,
      showMore: true
    })
    this.checkData(e.currentTarget.dataset.name)
  },

  /**
   * 搜索事件
   */
  checkData: function (name) {
    if (this.data.showMore === true) {
      let msg = {
        pageIndex: this.data.pageIndex + 1,
        pageSize: 10,
        searchKey: name,
        cityId: 0,
        lineId: 0,
        lineTeamId: 0,
        minTripDay: -1,
        startDate: '',
        endDate: '',
        minPrice: -1,
        maxPrice: -1,
        orderByDate: 0,
        orderByPrice: 0,
        priceOrderByField: 0,
        companyId: app.state.companyId,
        maxTripDay: -1,
        orderBySales: 0,
        startCityId: 0,
        dayNum: 0
      }
      app.$api('b2b_get_GetB2BTravelPageList', msg).then(res => {
        let arr = this.data.itemList
        if (this.data.pageIndex === 0) {
          arr = []
        }
        for (let i = 0; i < res.pageData.length; i++) {
          if (res.pageData[i].imgCover !== '' && res.pageData[i].imgCover !== null) {
            res.pageData[i].imgCover = (JSON.parse(res.pageData[i].imgCover))[0].Url + '?x-oss-process=image/resize,m_fill,w_560,h_420'
          } else {
            res.pageData[i].imgCover = ''
          }
          arr.push(res.pageData[i])
        };
        let storageList = this.data.storageList;
        if (storageList.indexOf(name) === -1) {
          storageList.push(name)
          wx.setStorage({
            key: "productCheck",
            data: storageList
          })
        }
        let showMore = true
        if (res.pageIndex >= res.pageCount) {
          showMore = false
        }
        this.setData({
          pageState: 2,
          pageIndex: res.pageIndex,
          pageCount: res.pageCount,
          showMore: showMore,
          itemList: arr,
          storageList: storageList
        })
      }).catch(err => {})
    }
  },

  /**
   * 搜索输入框输入事件
   */
  bindKeyInput: function (e) {
    let pageState = 1
    if (e.detail.value !== '') {
      pageState = 2
    }
    this.setData({
      pageState: pageState,
      inputValue: e.detail.value
    })
  },

  /**
   * 搜索输入框搜索事件
   */
  bingCheckInput: function (e) {
    this.setData({
      pageIndex: 0,
      pageCount: 0,
      showMore: true
    })
    this.checkData(e.detail.value)
  },

  /**
   * 清空历史搜索
   */
  historyDel: function () {
    wx.removeStorageSync('productCheck')
    this.setData({
      storageList: []
    })
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    this.setData({
      isMember: app.state.admin.isMember,
      account: app.state.admin.account,
    })
    // 获取历史搜索
    var storageList = wx.getStorageSync('productCheck')
    if (storageList) {
      this.setData({
        storageList: storageList
      })
    }
    // 获取热门搜索
    app.$api('app_get_AppGetHotTheme', {companyId: app.state.companyId}).then(res => {
      this.setData({
        hotList: res.hotTheme
      })
    }).catch(err => {})
    // 获取页面进入时查询条件
    if (options.hasOwnProperty('check')) {
      this.setData({
        pageState: 2,
        inputValue: options.check
      })
      this.checkData(options.check)
    }
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {
    wx.stopPullDownRefresh();
  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {
    this.checkData(this.data.inputValue)
  }
})