let app = getApp();
var util = require('../../../utils/util.js')
Page({

  /**
   * 页面的初始数据
   */
  data: {
    monthList: [],
    isLogin: app.isLogin,
    activeTab: 0,
    currentDay: util.YYMMDD(new Date()),
    visaB2CPrice: '',
    selectIndex: -1,
    selectDate: '',
    id: '',
    edit: false,
  },
  StartYd: function () {
    if (this.data.selectDate == '') {
      wx.showToast({
        title: '请选择日期',
        icon: 'none',
        duration: 1000
      })
      return
    }
    let id = this.data.id
    let pages = getCurrentPages()
    let prevPage = pages[pages.length - 2];
    prevPage.setData({
      selectDate: this.data.selectDate
    })
    if (this.data.edit) {
      wx.navigateBack({
        delta: 1
      })
    } else {
      wx.navigateTo({
        url: '/pages/visa/visaOrder/visaOrder?id=' + id + '&visaB2CPrice=' + this.data.visaB2CPrice + '&visaPrice=' + this.data.visaPrice + '&selectDate=' + this.data.selectDate,
      })
    }
  },
  childrenEvent(e) {
    let that = this;
    let val = e.detail;
    console.log(val)
    let msg = {
      configId: val.configId,
      cityId: that.data.cityId,
      tcid: val.tcid,
      teamType: that.data.teamType,
    };
    that.setData({
      selectIndex: val.selectIndex,
      selectDate: val.ymd
    })
  },
  CreatCalendar() {
    this.calendar = this.selectComponent('#calendar');
    this.calendar.getYearMonthDay();
  },
  selectMonth(e) {
    let item = e.currentTarget.dataset.item;
    let index = e.currentTarget.dataset.index;
    this.setData({
      activeTab: index,
      currentDay: item.date + '-01',
    })
    this.CreatCalendar();
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    console.log(options)
    var dataArr = [];
    var data = new Date();
    var year = data.getFullYear();
    var visaB2CPrice = options.visaB2CPrice
    var visaPrice = options.visaPrice
    data.setMonth(data.getMonth() - 1, 1); //获取到当前月份,设置月份
    for (var i = 0; i < 6; i++) {
      data.setMonth(data.getMonth() + 1); //每次循环一次 月份值减1
      var m = data.getMonth() + 1;
      m = m < 10 ? "0" + m : m;
      dataArr.push({
        date: data.getFullYear() + "-" + m,
        b2BPrice: visaB2CPrice
      });
    }
    console.log(dataArr);
    this.setData({
      monthList: dataArr,
      visaB2CPrice: visaB2CPrice,
      visaPrice: visaPrice,
      id: options.id,
      edit: options.edit ? true : false
    })
    this.CreatCalendar();
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  }
})