let app = getApp();
var WxParse = require('../../wxParse/wxParse.js');
Page({

  /**
   * 页面的初始数据
   */
  data: {
    isLogin: app.isLogin,
    imgList: [],
    dataList: {},
    visaId: null
  },
  StartYd: function () {
    let id = this.data.visaId
    wx.navigateTo({
      url: '/pages/visa/visaChDate/visaChDate?id=' + encodeURIComponent(id) + '&visaB2CPrice=' + this.data.dataList.visaB2CPrice + '&visaPrice=' + this.data.dataList.visaPrice,
    })
  },
  getDetails: function (id) {
    app.$api('b2b_get_GetVisaProductInfo', { productId: id}).then(res => {
      console.log(res)
      // 费用包含
      if (res.feeInclude){
        WxParse.wxParse('feeInclude', 'html', res.feeInclude, this, 0);
      }
      // 费用不包含
      if (res.feeNonInclude) {
        WxParse.wxParse('feeNonInclude', 'html', res.feeNonInclude, this, 0);
      }
      // 签证材料
      if (res.visaMaterials) {
        WxParse.wxParse('visaMaterials', 'html', res.visaMaterials, this, 0);
      }
      // 温馨提示
      if (res.warmTip) {
        WxParse.wxParse('warmTip', 'html', res.warmTip, this, 0);
      }
      let imgList = []
      if (res.coverImageList.length) {
        imgList = res.coverImageList
      } else {
        imgList.push("/images/visa/bg_c2@3x.png")
      }
      this.setData({
        imgList: imgList,
        dataList: res
      })
    }).catch(err => { });
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    console.log(options)
    let id = decodeURIComponent(options.id)
    this.setData({
      visaId: id
    })
    this.getDetails(id)
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  }
})