let app = getApp();
Page({

  /**
   * 页面的初始数据
   */
  data: {
    showBox: false,
    isLogin: app.isLogin,
    GetVisaCountryMsg: {
      companyId: 0,
      pageIndex: 1,
      pageSize: 12,
    },
    listmsg: {
      visaCountryId: 0,
      companyId: -1,//常住地
      tags: [],
      orderByPrice: 0,
      orderByBookAdvance: 0,
      pageIndex: 1,
      pageSize: 10,
      searchKey: "",
    },
    hotcountry: [],
    CountryId: 0,
    OrderBy: false,
    OrderByBook: false,
    cityList: [],
    tagItem: [],
    cityId: -1,
    pageIndex: 1,
    totalPage: 1,
  },
  //跳转详情
  geDetails: function (e) {
    let id = encodeURIComponent(e.currentTarget.dataset.id)
    wx.navigateTo({
      url: '/pages/visa/visaDetails/visaDetails?id=' + id,
    })
  },
  // 加载更多
  scrollGetMore: function () {
    this.setData({
      'listmsg.pageIndex': this.data.pageIndex + 1,
    })
    this.getDataList(1)
  },
  // 重置方法
  resetMsg: function () {
    let msg = {
      visaCountryId: 0,
      companyId: -1,//常住地
      tags: [],
      orderByPrice: 0,
      orderByBookAdvance: 0,
      pageIndex: 1,
      pageSize: 10,
      searchKey: "",
    }
    let tagItem = this.data.tagItem
    for (let i = 0; i < tagItem.length; i++) {
      tagItem[i].active = false
    }
    this.setData({
      tagItem: tagItem,
      listmsg: msg,
      OrderBy: false,
      OrderByBook: false,
      cityId: -1,
      CountryId: 0,
      showBox: false
    })
    this.getDataList()
  },
  // 筛选切换类型 服务 标签
  typeChange: function (e) {
    let index = e.currentTarget.dataset.index;
    this.data.tagItem[index].active = !this.data.tagItem[index].active
    this.setData({
      tagItem: this.data.tagItem
    })
  },
  // 切换筛选项城市 全部
  cityAll: function () {
    this.setData({
      cityId: -1
    })
  },
  // 切换筛选项城市
  cityChange: function (e) {
    let index = e.currentTarget.dataset.index;
    this.setData({
      cityId: this.data.cityList[index].cityId 
    })
  },
  //   获取签证产品国家筛选子项
  GetVisaProListChoose() {
    let msg = {};
    msg.companyId = this.data.GetVisaCountryMsg.companyId;
    msg.visaCountryId = this.data.CountryId;
    app.$apiJavaNew('api/b2b/visa/getProductCountryChildSearchItem', msg).then(res => {
      let tagItem = res.tagItem
      for(let i = 0; i < tagItem.length; i++) {
        tagItem[i].active = false
      }
      this.setData({
        cityList: res.cityList,
        tagItem: tagItem
      })

      this.getDataList()
    }).catch(err => { });
    
  },
  // 时间排序
  OrderByPrice: function () {
    this.setData({
      OrderBy: !this.data.OrderBy,
      'listmsg.pageIndex': 1,
      pageIndex: 1,
    })
    this.getDataList()
  },
  // 受理时间排序
  OrderByBookAdvance: function () {
    this.setData({
      OrderByBook: !this.data.OrderByBook,
      'listmsg.pageIndex': 1,
      pageIndex: 1,
    })
    this.getDataList()
  },
  // 数据查询方法
  getDataList: function (type) {
    this.data.listmsg.visaCountryId = this.data.CountryId;
    this.data.listmsg.orderByPrice = this.data.OrderBy ? 1 : 2;
    this.data.listmsg.orderByBookAdvance = this.data.OrderByBook ? 1 : 2;
    this.data.listmsg.companyId = this.data.cityId;
    this.data.listmsg.tags = [];
    let tagItem = this.data.tagItem
    for (let i = 0; i < tagItem.length; i++){
      if (tagItem[i].active) {
        this.data.listmsg.tags.push(tagItem[i].id)
      }
    }
    this.setData({
      listmsg: this.data.listmsg,
      showBox: false,
    })
    app.$apiJavaNew('api/b2b/visa/getVisaProductList', this.data.listmsg).then(res => {
      let data = res.pageData
      for(let i = 0; i < data.length; i++) {
        if (data[i].tagTames) {
          data[i].tagList = data[i].tagTames.split(",");
        }
      }
      this.setData({
        dataList: res.pageData,
        totalPage: res.pageCount ? res.pageCount : 1,
        pageIndex: res.pageIndex ? res.pageIndex : 1,
      })
    }).catch(err => { });
  },
  // 切换国家
  setCountry: function (e) {
    let id = e.currentTarget.dataset.id
    this.setData({
      CountryId: id,
      'listmsg.pageIndex': 1,
      pageIndex: 1,
    })
    this.getDataList()
  },
  // 查询弹框
  shaxuanShow: function () {
    this.setData({
      showBox: !this.data.showBox
    })
  },
  //   获取签证国家
  GetVisaCountry: function () {
    app.$apiJavaNew('api/b2b/visa/getVisaProductSearchItem', this.data.GetVisaCountryMsg).then(res => {
      this.setData({
        hotcountry: res.pageData,
        CountryId: res.pageData[0].id
      })
      this.GetVisaProListChoose();
    }).catch(err => { });
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    this.GetVisaCountry()
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  }
})