let app = getApp();
Page({

  /**
   * 页面的初始数据
   */
  data: {
    dataList: {},
    selectDate: '',
    id: '',
    ppType: ['成人', '儿童'],
    DutyList: ['在职', '自由职业', '在校学生', '退休', '学龄前儿童'],
    ppList: [],
    onePp: {
      SurName: '',
      Name: '',
      ESurName: '',
      EName: '',
      Duty: '在职',
      IdentityType: '',
      MobilePhone: '',
      IdCard: '',
      DutyIndex: 0,
      ppTypeIndex: 0,
    },
    saveMsg: {
      VisaId: '',
      AdultPeopleNum: '',
      ChildPeopleNum: '',
      TotalPrice: '',
      Id: 0,
      CustomerId: '',
      EnterCountryTime: '',
      GuestList: [],       
      VisaOrderRelation: {
        RelationName: '',
        RelationPhone: '',
        RelationEmail: '',
        IsNeedInvoice: 0, // 0不需要 1 需要
        InvoiceName: '',
        InvoiceType: 1, // 1 个人  2 企业  3 非企业的营业机构
        DutyParagraph: '',
        Receiver: '',
        ReceiverPhone: '',
        ReceiverProvince: '',
        ReceiverCity: '',
        ReceiverAddress: ''
      }
    },
    needFapiao: false,
    fapiaoShow: false,
    fapiaoType: 1,
    orderAdd: {},
    addrShow: false,
    addActive: false,
  },
  MyshowToast: function(text){
    wx.showToast({
      title: text,
      icon: 'none',
      duration: 2000
    })
  },
  //开始预订 
  StartYd: function (){
    let list = this.data.ppList,
      phone = false,
      isOk = true,
      cr = 0,
      xh = 0;;
    if (list.length < 1) {
      this.MyshowToast('请添加申请人')
      return
    } else {
      for (let i = 0; i < list.length; i++) {
        if (list[i].ppTypeIndex == 0){
          cr = cr + 1
        } else {
          xh = xh + 1
        }
        if (list[i].SurName == '' || list[i].Name == '') {
          this.MyshowToast('请填写第' + (i + 1) +'位申请人的中文姓或名！')
          isOk = false
          return
        } else if (list[i].ESurName == '' || list[i].EName == '') {
          this.MyshowToast('请填写第' + (i + 1) + '位申请人的英文姓或名！')
          isOk = false
          return
        } else if (list[i].IdCard == '') {
          this.MyshowToast('请填写第' + (i + 1) + '位申请人的证件号码！')
          isOk = false
          return
        }
        if (list[i].MobilePhone) {
          phone = true
        }
      }
      if (!phone) {
        this.MyshowToast('请至少填写一个申请人的手机号码！')
        return
      }
      if (!isOk) { 
        return
      }
    }
    if (!this.data.addActive) {
      this.MyshowToast('请选择收货地址！')
      return
    }
    
    if (!this.data.saveMsg.VisaOrderRelation.RelationName || !this.data.saveMsg.VisaOrderRelation.RelationPhone) {
      this.MyshowToast('请填写联系人信息！')
      return
    }
    this.data.saveMsg.AdultPeopleNum = cr;
    this.data.saveMsg.ChildPeopleNum = xh;
    this.data.saveMsg.TotalPrice = this.data.isLogin != 1 ? list.length * this.data.dataList.visaB2CPrice : list.length * this.data.dataList.visaB2CPrice;
    this.data.saveMsg.CustomerId = app.state.admin.id;
    this.data.saveMsg.GuestList = list;
    console.log(this.data.saveMsg)
    app.$api('b2b_get_SetB2BVisaOrder', this.data.saveMsg).then(res => {
      console.log(res)
      
    }).catch(err => { });
  },
  //确认收货地址
  queRenAdd: function (){
    if (!this.data.addActive) {
      wx.showToast({
        title: '请选择地址！',
        icon: 'none',
        duration: 2000
      })
      return
    } else {
      this.setData({
        'saveMsg.VisaOrderRelation.ReceiverProvince': this.data.orderAdd.province,
        'saveMsg.VisaOrderRelation.ReceiverCity': this.data.orderAdd.city,
        'saveMsg.VisaOrderRelation.ReceiverAddress': this.data.orderAdd.address,
        'saveMsg.VisaOrderRelation.Receiver': this.data.orderAdd.uname,
        'saveMsg.VisaOrderRelation.ReceiverPhone': this.data.orderAdd.uphone,
      })
      this.closeAddrw()
    }
  },
  // 收货地址选择
  addChange: function () {
    console.log(1111)
    this.setData({
      addActive: !this.data.addActive
    })
  },
  // 收货地址关闭 显示
  closeAddrw: function () {
    this.setData({
      addrShow: !this.data.addrShow
    })
  },
  // 确认发票信息
  queRenFp: function () {
    if (this.data.saveMsg.VisaOrderRelation.InvoiceName == '' && this.data.needFapiao) {
      wx.showToast({
        title: '请填写发票抬头！',
        icon: 'none',
        duration: 2000
      })
      return
    }
    if (this.data.saveMsg.VisaOrderRelation.InvoiceType !== 1 && this.data.saveMsg.VisaOrderRelation.DutyParagraph == '' && this.data.needFapiao) {
      wx.showToast({
        title: '请填写税号！',
        icon: 'none',
        duration: 2000
      })
      return
    }
    if (this.data.saveMsg.VisaOrderRelation.RelationEmail == '' && this.data.needFapiao) {
      wx.showToast({
        title: '请填写邮箱！',
        icon: 'none',
        duration: 2000
      })
      return
    }
    this.closeFapiaow()
  },
  // 修改发票相关信息 
  changeFpInfo: function (e) {
    let name = e.currentTarget.dataset.type
    this.data.saveMsg.VisaOrderRelation[name] = e.detail.value
    this.setData({
      saveMsg: this.data.saveMsg
    })
  },
  // 切换发票类型
  changeFapiaoType: function (e) {
    let i = e.currentTarget.dataset.index
    if (i == 1) {
      this.setData({
        'saveMsg.VisaOrderRelation.InvoiceType': Number(i),
        'saveMsg.VisaOrderRelation.DutyParagraph': '',
      })
    } else {
      this.setData({
        'saveMsg.VisaOrderRelation.InvoiceType': Number(i)
      })
    }
  },
  // 是否需要发票切换
  changeNeedFp: function (e) {
    let i = e.currentTarget.dataset.index
    this.setData({
      needFapiao: i == 1 ? true : false,
      'saveMsg.VisaOrderRelation.IsNeedInvoice': i,
      'saveMsg.VisaOrderRelation.RelationEmail': '',
      'saveMsg.VisaOrderRelation.InvoiceName': '',
      'saveMsg.VisaOrderRelation.DutyParagraph': '',
    })
  },
  // 关闭发票窗口
  closeFapiaow: function () {
    this.setData({
      fapiaoShow: !this.data.fapiaoShow
    })
  },
  //信息数据绑定
  lianxirenChange: function (e) {
    let name = e.currentTarget.dataset.type
    this.data.saveMsg.VisaOrderRelation[name] = e.detail.value
    this.setData({
      saveMsg: this.data.saveMsg
    })
  },
  // 删除
  deletePP: function (e) {
    let index = e.currentTarget.dataset.index
    let list = JSON.parse(JSON.stringify(this.data.ppList))
    list.splice(index, 1)
    this.setData({
      ppList: list
    })
  },
  // 绑定数据
  bindPickerChange: function (e) {
    let index = e.currentTarget.dataset.index
    let name = e.currentTarget.dataset.type
    let picker = e.currentTarget.dataset.picker
    this.data.ppList[index][name] = e.detail.value
    if (picker) {  // 客户类型
      this.data.ppList[index][picker] = this.data.DutyList[e.detail.value]
      this.setData({
        ppList: this.data.ppList
      })
    } else {
      this.setData({
        ppList: this.data.ppList
      })
    }
  },
  addPP: function () {
    let list = this.data.ppList
    list.push(this.data.onePp)
    this.setData({
      ppList: list
    })
  },
  editDate: function () {
    let id = this.data.id
    wx.navigateTo({
      url: '/pages/visa/visaChDate/visaChDate?id=' + encodeURIComponent(id) + '&visaB2CPrice=' + this.data.dataList.visaB2CPrice + '&visaPrice=' + this.data.dataList.visaPrice + '&edit=' + true,
    })
  },
  // 获取地址
  getOrderAdd: function () {
    app.$apiJavaData("api/orderForm/getOrderAdd", {}).then(res => {
      console.log(res)
      this.setData({
        orderAdd: res.data
      })
    }).catch(err => { })
  },
  getDetails: function (id) {
    app.$api('b2b_get_GetVisaProductInfo', { productId: id }).then(res => {
      console.log(res)
      this.setData({ 
        dataList: res,
        'saveMsg.VisaId': res.id
      })
    }).catch(err => { });
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    console.log(options)
    let id = decodeURIComponent(options.id)
    this.getDetails(id)
    this.setData({
      id: id,
      selectDate: options.selectDate,
      'saveMsg.EnterCountryTime': options.selectDate,
    })
    this.getOrderAdd()
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function (options) {
    console.log('onShow', options)
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  }
})