const formatTime = date => {
  const year = date.getFullYear()
  const month = date.getMonth() + 1
  const day = date.getDate()
  const hour = date.getHours()
  const minute = date.getMinutes()
  const second = date.getSeconds()

  return [year, month, day].map(formatNumber).join('/') + ' ' + [hour, minute, second].map(formatNumber).join(':')
}
const YYMMDD = date => {
  const year = date.getFullYear()
  const month = date.getMonth() + 1
  const day = date.getDate()
  const hour = date.getHours()
  const minute = date.getMinutes()
  const second = date.getSeconds()

  return [year, month, day].map(formatNumber).join('-')
}
const YYMM= date => {
  const year = date.getFullYear()
  const month = date.getMonth() + 1
  const day = date.getDate()
  const hour = date.getHours()
  const minute = date.getMinutes()
  const second = date.getSeconds()

  return [year, month].map(formatNumber).join('-')
}
const CompareDate=(date1, date2)=> {
  var oDate1 = new Date(date1);
  var oDate2 = new Date(date2);
  if (oDate1.getTime() > oDate2.getTime()) {
   return true;
  } else {
    return false;
  }
}
const formatNumber = n => {
  n = n.toString()
  return n[1] ? n : '0' + n
}
const changeMonth=(date,i)=>{
  let data = new Date(date);
  data.setMonth(data.getMonth() + i);
  let dateString = data.getFullYear() + "-" + ((data.getMonth() + 1) < 10 ? '0' + (data.getMonth() + 1) : (data.getMonth() + 1));
  return dateString;
}
// 得到某年某月有多少天
const getDays = (year, month)=>{
  month = parseInt(month, 10);
  var d = new Date(year, month, 0);
  return d.getDate();
}

module.exports = {
  formatTime: formatTime,
  CompareDate: CompareDate,
  YYMMDD: YYMMDD,
  changeMonth: changeMonth,
  YYMM: YYMM,
  getDays: getDays
}
