var commonUtils = {
  //json数组求和
  CaluJsonArraySum: function (arr, filed, num) {
    var sum = 0;
    arr.forEach(item => {
      if (item.hasOwnProperty(filed)) {
        sum += Number(item[filed]);
      }
    });
    return sum.toFixed(num);
  },
  //截取阿里返回文件路径
  GetALiFileUrl: function (str) {
    var newStr = str;
    if (newStr.indexOf("?") != -1) {
      newStr = newStr.split("?")[0];
    }
    return newStr;
  },
  /*正则表达式*/
  Regex: {
    isInteger: /[^\d]/g, //输入验证只能为整
    el_isInteger: /^[\d]+$/, //element自带验证为整
    el_Isdecimal: /^\d+(\.\d{0,2})?$/, //验证只能输入2位小数
    el_IsdecimalTrr: /^\d+(\.\d{0,8})?$/, //验证只能输入8位小数
    el_IsdecimalAll: /^[0-9]+([.]{1}[0-9]+){0,1}$/, //验证不限小数的
    el_ISphone: /^((0\d{2,3}-\d{7,8})|(1([358][0-9]|4[579]|66|7[0135678]|9[89])[0-9]{8}))$/, //最新验证输入手机号 包括电话号码
    el_IsFax: /^[+]{0,1}(\d){1,3}[ ]?([-]?((\d)|[ ]){1,12})+$/, //验证传真号
    el_IsInventer: /^(\-|\+?)\d+(\.\d+)?$/, //可以输入带正负号整数
    el_IsIDnumber: /(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/, //验证身份证号
    el_IsEnglish: /^[a-zA-Z]/, //只能输入英文
    el_IsChinese: /^[\u4E00-\u9FA5]{1,5}$/, //只能输入中文
    el_IsNumEn: /^[a-zA-Z0-9]+$/ //输入数字或者字母
  },
  //文件上传对象
  FileObject: function () {
    return {
      Url: "",
      Name: "",
      VideoPath:"",
      FileType:"",//文件类型
    }
  },
  //实现每三位一个逗号分隔并且保留两位小数
  addCommas: function (nStr) {
    nStr += '';
    let x = nStr.split('.');
    let x1 = x[0];
    let x2 = x.length > 1 ? '.' + x[1] : '';
    var rgx = /(\d+)(\d{3})/;
    while (rgx.test(x1)) {
      x1 = x1.replace(rgx, '$1' + ',' + '$2');
    }
    return x1 + x2;
  },
  formatMsgTime: function (qdateTime) {
    var dateTimeStamp = Date.parse(qdateTime.replace(/-/gi, "/"));
    var minute = 1000 * 60;
    var hour = minute * 60;
    var day = hour * 24;
    var month = day * 30;
    var now = new Date().getTime();
    var diffValue = now - dateTimeStamp;
    if (diffValue < 0) {
      return;
    }
    var monthC = diffValue / month;
    var weekC = diffValue / (7 * day);
    var dayC = diffValue / day;
    var hourC = diffValue / hour;
    var minC = diffValue / minute;
    var result = "";
    if (monthC >= 1) {
      result = "" + parseInt(monthC) + "月前";
    } else if (weekC >= 1) {
      result = "" + parseInt(weekC) + "周前";
    } else if (dayC >= 1) {
      result = "" + parseInt(dayC) + "天前";
    } else if (hourC >= 1) {
      result = "" + parseInt(hourC) + "小时前";
    } else if (minC >= 1) {
      result = "" + parseInt(minC) + "分钟前";
    } else
      result = "刚刚";
    return result;
  },
  formatMsgTime2: function (qdateTime, qdateTime2) {
    var dateTimeStamp = Date.parse(qdateTime.replace(/-/gi, "/"));
    var minute = 1000 * 60;
    var hour = minute * 60;
    var day = hour * 24;
    var month = day * 30;
    var now = new Date(qdateTime2.replace(/-/gi, "/")).getTime();
    var diffValue = now - dateTimeStamp;
    if (diffValue < 0) {
      return;
    }
    var monthC = diffValue / month;
    var weekC = diffValue / (7 * day);
    var dayC = diffValue / day;
    var hourC = diffValue / hour;
    var minC = diffValue / minute;
    var result = "";
    if (monthC >= 1) {
      result = "" + parseInt(monthC) + "月前";
    } else if (weekC >= 1) {
      result = "" + parseInt(weekC) + "周前";
    } else if (dayC >= 1) {
      result = "" + parseInt(dayC) + "天前";
    } else if (hourC >= 1) {
      result = "" + parseInt(hourC) + "小时前";
    } else if (minC >= 1) {
      result = "" + parseInt(minC) + "分钟前";
    } else
      result = "刚刚";
    return result;
  },
  changeMoneyToChinese(Num) { // 数字转中文大写
    if (!Num) {
      return '零'
    }
    var isNegative = false; // 是否负数
    if (Num < 0) {
      Num = -Num;
      isNegative = true;
    }
    if (typeof Num == 'number') {
      Num = Num.toString();
    }
    for (var i = Num.length - 1; i >= 0; i--) {
      Num = Num.replace(",", ""); // 替换money中的“,”
      Num = Num.replace(" ", ""); // 替换money中的空格
    }
    Num = Num.replace("￥", ""); // 替换掉可能出现的￥字符
    if (isNaN(Num)) { // 验证输入的字符是否为数字
      return;
    }
    // ---字符处理完毕，开始转换，转换采用前后两部分分别转换---//
    let part = String(Num).split(".");
    let newchar = "";
    // 小数点前进行转化
    for (var i = part[0].length - 1; i >= 0; i--) {
      if (part[0].length > 10) {
        // alertWarning("位数过大，无法计算");
        return "";
      } // 若数量超过拾亿单位，提示
      let tmpnewchar = "";
      let perchar = part[0].charAt(i);
      switch (perchar) {
        case "0":
          tmpnewchar = "零" + tmpnewchar;
          break;
        case "1":
          tmpnewchar = "壹" + tmpnewchar;
          break;
        case "2":
          tmpnewchar = "贰" + tmpnewchar;
          break;
        case "3":
          tmpnewchar = "叁" + tmpnewchar;
          break;
        case "4":
          tmpnewchar = "肆" + tmpnewchar;
          break;
        case "5":
          tmpnewchar = "伍" + tmpnewchar;
          break;
        case "6":
          tmpnewchar = "陆" + tmpnewchar;
          break;
        case "7":
          tmpnewchar = "柒" + tmpnewchar;
          break;
        case "8":
          tmpnewchar = "捌" + tmpnewchar;
          break;
        case "9":
          tmpnewchar = "玖" + tmpnewchar;
          break;
      }
      switch (part[0].length - i - 1) {
        case 0:
          tmpnewchar = tmpnewchar + "元";
          break;
        case 1:
          if (perchar != 0)
            tmpnewchar = tmpnewchar + "拾";
          break;
        case 2:
          if (perchar != 0)
            tmpnewchar = tmpnewchar + "佰";
          break;
        case 3:
          if (perchar != 0)
            tmpnewchar = tmpnewchar + "仟";
          break;
        case 4:
          tmpnewchar = tmpnewchar + "万";
          break;
        case 5:
          if (perchar != 0)
            tmpnewchar = tmpnewchar + "拾";
          break;
        case 6:
          if (perchar != 0)
            tmpnewchar = tmpnewchar + "佰";
          break;
        case 7:
          if (perchar != 0)
            tmpnewchar = tmpnewchar + "仟";
          break;
        case 8:
          tmpnewchar = tmpnewchar + "亿";
          break;
        case 9:
          tmpnewchar = tmpnewchar + "拾";
          break;
      }
      newchar = tmpnewchar + newchar;
    }
    // 小数点之后进行转化
    if (Num.indexOf(".") != -1) {
      if (part[1].length > 2) {
        // alertWarning("小数点之后只能保留两位,系统将自动截段");
        part[1] = part[1].substr(0, 2);
      }
      for (var i = 0; i < part[1].length; i++) {
        let tmpnewchar = "";
        let perchar = part[1].charAt(i);
        switch (perchar) {
          case "0":
            tmpnewchar = "零" + tmpnewchar;
            break;
          case "1":
            tmpnewchar = "壹" + tmpnewchar;
            break;
          case "2":
            tmpnewchar = "贰" + tmpnewchar;
            break;
          case "3":
            tmpnewchar = "叁" + tmpnewchar;
            break;
          case "4":
            tmpnewchar = "肆" + tmpnewchar;
            break;
          case "5":
            tmpnewchar = "伍" + tmpnewchar;
            break;
          case "6":
            tmpnewchar = "陆" + tmpnewchar;
            break;
          case "7":
            tmpnewchar = "柒" + tmpnewchar;
            break;
          case "8":
            tmpnewchar = "捌" + tmpnewchar;
            break;
          case "9":
            tmpnewchar = "玖" + tmpnewchar;
            break;
        }
        if (i == 0)
          tmpnewchar = tmpnewchar + "角";
        if (i == 1)
          tmpnewchar = tmpnewchar + "分";
        newchar = newchar + tmpnewchar;
      }
    }
    // 替换所有无用汉字
    while (newchar.search("零零") != -1)
      newchar = newchar.replace("零零", "零");
    newchar = newchar.replace("零亿", "亿");
    newchar = newchar.replace("亿万", "亿");
    newchar = newchar.replace("零万", "万");
    newchar = newchar.replace("零元", "元");
    newchar = newchar.replace("零角", "");
    newchar = newchar.replace("零分", "");

    if (newchar.charAt(newchar.length - 1) == "元" || newchar.charAt(newchar.length - 1) == "角") {
      newchar = newchar + "整";
    }

    if (isNegative) {
      newchar = '负' + newchar;
    }

    return newchar;
  },
  createComprisonFunction(propertyName) {
    return function (object1, object2) {
      var value1 = object1[propertyName];
      var value2 = object2[propertyName];
      if (value1 < value2) {
        return -1;
      } else if (value1 > value2) {
        return 1;
      } else {
        return 0;
      }
    };
  },
  //价格转换器
  getConvertMoney(value) {
    if (value === "" || value === undefined || value === null) {
      value = 0.0
    }
    return parseFloat(value)
  },
  //两个日期比较大小 返回值大于0：date1>date2,返回值等于0：date1=date2,返回值小于0：date1<date2
  CompareDate(date1, date2) {
    var oDate1 = new Date(date1);
    var oDate2 = new Date(date2);
    if (oDate1.getTime() > oDate2.getTime()) {
      return 1
    } else if (oDate1.getTime() == oDate2.getTime()) {
      return 0;
    } else {
      return -1;
    }
  },
  //判断值是否为空
  isNullOrEmpty: function (value) {
    if (value === null || value === "" || value === undefined) {
      return true;
    } else {
      return false;
    }
  },
  //NULL转字符串
  getStrValue: function (value) {
    if (value == null) {
      value = "";
    }
    return value;
  },
  //获取后面的字符串
  getCaption: function (obj, splitStr) {
    var index = obj.lastIndexOf(splitStr);
    obj = obj.substring(index + 1, obj.length);
    return obj;
  },
  //公用去掉域名
  removeDomain: function (val) {
    var reg = /^http(s)?:\/\/(.*?)\//;
    return val.replace(reg, '');
  },
  //获取当前日期
  getCurrentDate() {
    var myDate = new Date();
    //返回年月日
    return myDate.getFullYear() + '-' + parseInt(myDate.getMonth() + 1) + "-" + myDate.getDate()
  },
  //判断字符串是否为数字
  isNumber: function (val) {
    var regPos = /^\d+(\.\d+)?$/; //非负浮点数
    var regNeg = /^(-(([0-9]+\.[0-9]*[1-9][0-9]*)|([0-9]*[1-9][0-9]*\.[0-9]+)|([0-9]*[1-9][0-9]*)))$/; //负浮点数
    if (regPos.test(val) || regNeg.test(val)) {
      return true;
    } else {
      return false;
    }
  },
  //去掉图片的https
  replaceHttps: function (val) {
    return val.replace("https", "http");
  },
  //计算两日期时间间隔
  getDateTimeInterval: function (startDate, endDate) {
    var diff = endDate.getTime() - startDate.getTime(); //时间差的毫秒数
    //计算出相差天数
    var days = Math.floor(diff / (24 * 3600 * 1000));

    //计算出小时数
    var leave1 = diff % (24 * 3600 * 1000); //计算天数后剩余的毫秒数
    var hours = Math.floor(leave1 / (3600 * 1000));
    //计算相差分钟数
    var leave2 = leave1 % (3600 * 1000); //计算小时数后剩余的毫秒数
    var minutes = Math.floor(leave2 / (60 * 1000));

    //计算相差秒数
    var leave3 = leave2 % (60 * 1000); //计算分钟数后剩余的毫秒数
    var seconds = Math.round(leave3 / 1000);
    var returnStr = seconds + "秒";
    if (minutes > 0) {
      returnStr = minutes + "分" + returnStr;
    }
    if (hours > 0) {
      returnStr = hours + "小时" + returnStr;
    }
    if (days > 0) {
      returnStr = days + "天" + returnStr;
    }
    return returnStr;
  },
  //将yyyy年mm月dd日 hh:mm:ss 转换为 yyyy-mm-dd hh:mm:ss
  getDateStr(date) {
    let dateStr = "";
    if (date != "") {
      let dateArr = date.split(' ');
      let str = dateArr[0].replace(/[^\d]/g, '-');
      dateStr = str.substr(0, str.length - 1) + ' ' + dateArr[1];
    }
    return dateStr;
  },
  /**
   * 增加减少天数
   * date:可以不传
   * day：正数
   */
  AddDay(date, day) {
    var myDate = "";
    if (date) {
      myDate = new Date(date);
    } else {
      myDate = new Date();
    }
    myDate = myDate.setDate(myDate.getDate() + day);
    myDate = new Date(myDate);
    var seperator1 = "-";
    var year = myDate.getFullYear();
    var month = myDate.getMonth() + 1;
    var strDate = myDate.getDate();
    if (month >= 1 && month <= 9) {
        month = "0" + month;
    }
    if (strDate >= 0 && strDate <= 9) {
        strDate = "0" + strDate;
    }
    var currentdate = year + seperator1 + month + seperator1 + strDate;
    return currentdate;
  }

}
export default commonUtils
