import Vue from 'vue'
import Router from 'vue-router'

Vue.use(Router)

export default new Router({
  routes: [{
      path: '/',
      name: 'login',
      component: resolve => require(['@/components/Login'], resolve),
    },
    {
      path: '/login',
      name: 'login',
      component: resolve => require(['@/components/Login'], resolve),
    },
    {
      path: '/Forgetpassword',
      name: 'Forgetpassword',
      component: resolve => require(['@/components/Forgetpassword'], resolve),
    },
    {
      path: '/Register',
      name: 'Register',
      component: resolve => require(['@/components/Register'], resolve),
    },
    {
      path: '/index',
      name: 'index',
      component: resolve => require(['@/components/index'], resolve),
    },
    {
      path: '/menu',
      name: 'menu',
      component: resolve => require(['@/components/system/menu'], resolve),
    },
    {
      path: '/minimenu', //小程序菜单管理
      name: 'minimenu',
      component: resolve => require(['@/components/system/minimenu'], resolve),
    },
    {
      path: '/setminipage', //设置小程序菜单
      name: 'setminipage',
      component: resolve => require(['@/components/system/setminipage'], resolve),
    },
    {
      path: '/Fsetting', //微信小程序设置
      name: 'Fsetting',
      component: resolve => require(['@/components/Fsetting'], resolve),
      children: [
         //店铺管理 微信基础设置
        {
          path: '/wexinappconfig',
          name: 'wexinappconfig',
          component: resolve => require(['@/components/StoreDesign/wexinappconfig'], resolve),
        }, //店铺管理 微信基础设置
        {
          path: '/wexinappmsg',
          name: 'wexinappmsg',
          component: resolve => require(['@/components/StoreDesign/wexinappmsg'], resolve),
        },
        //店铺管理 小程序发布
        {
          path: '/AppletPublishing',
          name: 'AppletPublishing',
          component: resolve => require(['@/components/StoreDesign/AppletPublishing'], resolve),
        }
      ]
    },
    {
      path:'/Ftemplate', //DIY装修
      name: 'Ftemplate',
      component: resolve => require(['@/components/Ftemplate'], resolve),
      children:[{ //模板管理
        path:'/templateManage',
        name:'templateManage',
        component: resolve => require(['@/components/sallCenter/templateManage'], resolve),
      },{ //添加 修改模板
        path:'/templateEdit',
        name: 'templateEdit',
        component: resolve => require(['@/components/sallCenter/templateEdit'], resolve),
      },{ //自定义页面
        path:'/CustomPage',
        name: 'CustomPage',
        component: resolve => require(['@/components/sallCenter/CustomPage'], resolve),
      }]
    },
    {
      path: '/mall',
      name: 'mall',
      component: resolve => require(['@/components/mall'], resolve),
      children: [{
          path: '/zanIndex',
          name: 'zanIndex',
          component: resolve => require(['@/components/zanIndex'], resolve),
        },
        // 用户管理 用户列表
        {
          path: '/usersList',
          name: 'usersList',
          component: resolve => require(['@/components/UserMan/usersList'], resolve),
        },
        // 用户管理 用户列表编辑
        {
          path: '/usersListEdit',
          name: 'usersListEdit',
          component: resolve => require(['@/components/UserMan/usersListEdit'], resolve),
        },

        // 用户管理 核销员
        {
          path: '/verificationMember',
          name: 'verificationMember',
          component: resolve => require(['@/components/UserMan/verificationMember'], resolve),
        },
        // 用户管理 会员等级
        {
          path: '/MembershipGrade',
          name: 'MembershipGrade',
          component: resolve => require(['@/components/UserMan/MembershipGrade'], resolve),
        },
        // 用户管理 会员等级/会员设置
        {
          path: '/setMember',
          name: 'setMember',
          component: resolve => require(['@/components/UserMan/setMember'], resolve),
        },
        // 用户管理 会员等级/会员购买
        {
          path: '/MembersBuy',
          name: 'MembersBuy',
          component: resolve => require(['@/components/UserMan/MembersBuy'], resolve),
        },
        // 用户管理 分销商管理 基础设置
        {
          path: '/baseSet',
          name: 'baseSet',
          component: resolve => require(['@/components/UserMan/baseSet'], resolve),
        },
        // 用户管理 分销商管理 自定义设置
        {
          path: '/customSet',
          name: 'customSet',
          component: resolve => require(['@/components/UserMan/customSet'], resolve),
        },
        // 用户管理 分销商管理 分销商等级
        {
          path: '/distributorLevel',
          name: 'distributorLevel',
          component: resolve => require(['@/components/UserMan/distributorLevel'], resolve),
        },
        // 用户管理 分销商管理 新增或编辑分销商等级
        {
          path: '/setDistributorLevel',
          name: 'setDistributorLevel',
          component: resolve => require(['@/components/UserMan/setDistributorLevel'], resolve),
        },
        // 用户管理 分销商管理 分销商
        {
          path: '/distributors',
          name: 'distributors',
          component: resolve => require(['@/components/UserMan/distributors'], resolve),
        },
        // 用户管理 分销商管理 分销提现
        {
          path: '/disWithdrawal',
          name: 'disWithdrawal',
          component: resolve => require(['@/components/UserMan/disWithdrawal'], resolve),
        },
        // 商品管理 素材管理
        {
          path: '/materialMan',
          name: 'materialMan',
          component: resolve => require(['@/components/CommodityMan/materialMan'], resolve),
        },
        // 商品管理 商品分类
        {
          path: '/goodsClassification',
          name: 'goodsClassification',
          component: resolve => require(['@/components/CommodityMan/goodsClassification'], resolve),
        },
        // 商品管理 添加商品分类
        {
          path: '/addGoodsClass',
          name: 'addGoodsClass',
          component: resolve => require(['@/components/CommodityMan/addGoodsClass'], resolve),
        },
        // 商品管理 规格模板
        {
          path: '/SpecificationTemplate',
          name: 'SpecificationTemplate',
          component: resolve => require(['@/components/CommodityMan/SpecificationTemplate'], resolve),
        },
        // 商品管理 快速购买
        {
          path: '/quickBuy',
          name: 'quickBuy',
          component: resolve => require(['@/components/CommodityMan/quickBuy'], resolve),
        },
        // 商品管理 推荐设置
        {
          path: '/RecSettings',
          name: 'RecSettings',
          component: resolve => require(['@/components/CommodityMan/RecSettings'], resolve),
        },
        // 商品管理 商品服务
        {
          path: '/goodsServices',
          name: 'goodsServices',
          component: resolve => require(['@/components/CommodityMan/goodsServices'], resolve),
        },
        // 商品管理 商品服务新增或修改
        {
          path: '/goodsServicesEdit',
          name: 'goodsServicesEdit',
          component: resolve => require(['@/components/CommodityMan/goodsServicesEdit'], resolve),
        },
        // 商品管理 商品列表
        {
          path: '/goodsList',
          name: 'goodsList',
          component: resolve => require(['@/components/CommodityMan/goodsList'], resolve),
        },
        // 商品管理 商品列表新增
        {
          path: '/goodsListEdit',
          name: 'goodsListEdit',
          component: resolve => require(['@/components/CommodityMan/goodsListEdit'], resolve),
        },
        // 商品管理 商品列表新增
        {
          path: '/orderList',
          name: 'orderList',
          component: resolve => require(['@/components/orderMan/orderList'], resolve),
        },
        // 商品管理 商品详情
        {
          path: '/orderDetails',
          name: 'orderDetails',
          component: resolve => require(['@/components/orderMan/orderDetails'], resolve),
        },
        //设置 基础设置
        {
          path: '/basicSetUp',
          name: 'basicSetUp',
          component: resolve => require(['@/components/setup/basicSetUp'], resolve),
        },
        // 物流设置 规则设置
        {
          path: '/ruleSetup',
          name: 'ruleSetup',
          component: resolve => require(['@/components/setup/ruleSetup'], resolve),
        },

        //店铺管理 导航图标
        {
          path: '/navigationIcon',
          name: 'navigationIcon',
          component: resolve => require(['@/components/StoreDesign/navigationIcon'], resolve),
        },
        // 物流设置 新增运费规则
        {
          path: '/addFreightRule',
          name: 'addFreightRule',
          component: resolve => require(['@/components/setup/addFreightRule'], resolve),
        },
        //物流设置 新增包邮规则
        {
          path: '/addFreeshipping',
          name: 'addFreeshipping',
          component: resolve => require(['@/components/setup/addFreeshipping'], resolve),
        },
        //店铺管理 导航图标
        {
          path: '/navigationIcon',
          name: 'navigationIcon',
          component: resolve => require(['@/components/StoreDesign/navigationIcon'], resolve),
        },
        //店铺管理 商城风格
        {
          path: '/storeStyle',
          name: 'storeStyle',
          component: resolve => require(['@/components/StoreDesign/storeStyle'], resolve),
        },
        //店铺管理 标签栏
        {
          path: '/labelBar',
          name: 'labelBar',
          component: resolve => require(['@/components/StoreDesign/labelBar'], resolve),
        },
        //店铺管理 小程序页面
        {
          path: '/minipage',
          name: 'minipage',
          component: resolve => require(['@/components/StoreDesign/minipage'], resolve),
        }, 
        //店铺管理 内容管理 文章
        {
          path: '/Article',
          name: 'Article',
          component: resolve => require(['@/components/StoreDesign/Article'], resolve),
        },
        //店铺管理 内容管理 专题分类
        {
          path: '/ProjectClassific',
          name: 'ProjectClassific',
          component: resolve => require(['@/components/StoreDesign/ProjectClassific'], resolve),
        },
        //店铺管理 小程序页面标题
        {
          path: '/minititle',
          name: 'minititle',
          component: resolve => require(['@/components/StoreDesign/minititle'], resolve),
        }
        , //店铺管理 版权设置
        {
          path: '/copyrightset',
          name: 'copyrightset',
          component: resolve => require(['@/components/StoreDesign/copyrightset'], resolve),
        },
        //店铺管理 用户中心
        {
          path: '/userCenter',
          name: 'userCenter',
          component: resolve => require(['@/components/StoreDesign/userCenter'], resolve),
        },
        //店铺管理 自定义海报
        {
          path: '/customPoster',
          name: 'customPoster',
          component: resolve => require(['@/components/StoreDesign/customPoster'], resolve),
        },
        //营销中心 插件中心
        {
          path: '/pluginCenter',
          name: 'pluginCenter',
          component: resolve => require(['@/components/sallCenter/pluginCenter'], resolve),
        },
        //物流设置 退货地址列表
        {
          path: '/returnAddressList',
          name: 'returnAddressList',
          component: resolve => require(['@/components/setup/returnAddressList'], resolve),
        },
        //物流设置 新增退货地址
        {
          path: '/addAddress',
          name: 'addAddress',
          component: resolve => require(['@/components/setup/addAddress'], resolve),
        },
        //物流设置 区域购买
        {
          path: '/regionBuy',
          name: 'regionBuy',
          component: resolve => require(['@/components/setup/regionBuy'], resolve),
        },
        //物流设置 电子面单
        {
          path: '/electronFaceSheet',
          name: 'electronFaceSheet',
          component: resolve => require(['@/components/setup/electronFaceSheet'], resolve),
        },
        //物流设置 新增电子面单
        {
          path: '/addElectronFaceSheet',
          name: 'addElectronFaceSheet',
          component: resolve => require(['@/components/setup/addElectronFaceSheet'], resolve),
        },
        //数据统计 分销排行
        {
          path: '/retailRanking',
          name: 'retailRanking',
          component: resolve => require(['@/components/statistics/retailRanking'], resolve),
        },
        //数据统计 积分收支
        {
          path: '/integralBudget',
          name: 'integralBudget',
          component: resolve => require(['@/components/statistics/integralBudget'], resolve),
        },
        //营销中心 余额收支
        {
          path: '/balanceBudget',
          name: 'balanceBudget',
          component: resolve => require(['@/components/sallCenter/balanceBudget'], resolve),
        },
        //营销中心 充值管理
        {
          path: '/rechargeManage',
          name: 'rechargeManage',
          component: resolve => require(['@/components/sallCenter/rechargeManage'], resolve),
        },
        //营销中心 新增充值方案
        {
          path: '/addRechargeScheme',
          name: 'addRechargeScheme',
          component: resolve => require(['@/components/sallCenter/addRechargeScheme'], resolve),
        },
        //营销中心 充值设置
        {
          path: '/rechargeSet',
          name: 'rechargeSet',
          component: resolve => require(['@/components/sallCenter/rechargeSet'], resolve),
        },
        //营销中心 积分设置
        {
          path: '/integralSetting',
          name: 'integralSetting',
          component: resolve => require(['@/components/sallCenter/integralSetting'], resolve),
        },
        //营销中心 积分记录
        {
          path: '/IntegralRecord',
          name: 'IntegralRecord',
          component: resolve => require(['@/components/sallCenter/IntegralRecord'], resolve),
        },
        //营销中心 卡券列表
        {
          path: '/cardTicketList',
          name: 'cardTicketList',
          component: resolve => require(['@/components/sallCenter/cardTicketList'], resolve),
        },
        //营销中心 优惠券管理
        {
          path: '/couponManage',
          name: 'couponManage',
          component: resolve => require(['@/components/sallCenter/couponManage'], resolve),
        },
        //营销中心 自动发放
        {
          path: '/autorelease',
          name: 'autorelease',
          component: resolve => require(['@/components/sallCenter/autorelease'], resolve),
        },
        //营销中心 新增优惠券
        {
          path: '/addCoupon',
          name: 'addCoupon',
          component: resolve => require(['@/components/sallCenter/addCoupon'], resolve),
        },
        //营销中心 新增卡券
        {
          path: '/addCardTicket',
          name: 'addCardTicket',
          component: resolve => require(['@/components/sallCenter/addCardTicket'], resolve),
        },
        //营销中心 优惠券=》发放优惠券
        {
          path: '/grantCouPon',
          name: 'grantCouPon',
          component: resolve => require(['@/components/sallCenter/grantCouPon'], resolve),
        },
        //营销中心 自动发放优惠券
        {
          path: '/addAutoreleaseCoupon',
          name: 'addAutoreleaseCoupon',
          component: resolve => require(['@/components/sallCenter/addAutoreleaseCoupon'], resolve),
        },

      ]
    },

  ]
})
