import md5 from 'js-md5'
export default {
  install(Vue, options) {
    Vue.prototype.md5 = md5;
    //消息成功提示
    Vue.prototype.Success = function (msg) {
        this.$message({
          message: msg,
          duration: 2000,
          type: "success"
        });
      },
      //错误提示
      Vue.prototype.Error = function (msg) {
        this.$message({
          message: msg,
          duration: 2000,
          type: "error"
        });
      },

      //一般提示
      Vue.prototype.Info = function (msg) {
        this.$message({
          message: msg,
          duration: 2000,
          type: "info"
        });
      },
      //警告提示
      Vue.prototype.Warning = function (msg) {
        this.$message({
          message: msg,
          duration: 2000,
          type: "warning"
        });
      },
      //Confirm
      Vue.prototype.Confirm = function (msg, callback) {
        this.$confirm(msg, "提示", {
            confirmButtonText: "确定",
            cancelButtonText: "取消",
            type: "warning"
          })
          .then(() => {
            if (typeof callback === 'function') {
              callback();
            }
          })
          .catch(() => {
            this.Info("已取消操作");
          });
      },
      //域名管理对象
      Vue.prototype.domainManager = function () {
        let domainUrl = '';
        //domainUrl = "http://192.168.2.214:8200";
        // domainUrl = "https://localhost:5001";
        domainUrl = "http://192.168.0.102:8200";

        // domainUrl = "http://192.168.2.17:8088";
        let locationName = window.location.hostname;
        if (locationName.indexOf('testerp.oytour') !== -1) {
          domainUrl = "http://testapi.oytour.com";
        } else if (locationName.indexOf('oytour') !== -1) {
          domainUrl = "http://reborn.oytour.com";
        }
        var obj = {
          //主地址npm
          DomainUrl: domainUrl,
          //常用提交数据URL
          PostUrl: domainUrl + "/api/common/post",
          ImageUrl:'https://viitto-1301420277.cos.ap-chengdu.myqcloud.com'
        };
        return obj;
      },
      //浏览器缓存
      Vue.prototype.getLocalStorage = function () {
        var localStorageData = window.localStorage["mall_userInfo"];
        if (localStorageData !== undefined && localStorageData != 'undefined') {
          return JSON.parse(localStorageData);
        } else {
          return null;
        }
      },
      //验证只能输入2位小数【负数：isMinus传true】
      Vue.prototype.checkPrice = function (item, filed, isMinus) {
        var value = "" + item[filed]; //转字符串
        var t = value.charAt(0);
        value = value.replace(/[^\d.]/g, ""); //清除“数字”和“.”以外的字符
        value = value.replace(/\.{2,}/g, "."); //只保留第一个. 清除多余的
        value = value
          .replace(".", "$#$")
          .replace(/\./g, "")
          .replace("$#$", ".");
        value = value.replace(/^(\-)*(\d+)\.(\d\d).*$/, '$1$2.$3'); //只能输入两个小数
        //如果第一位是负号，则允许添加   如果不允许添加负号 可以把这块注释掉
        //是否允许负数
        if (isMinus && t == '-') {
          value = '-' + value;
        }
        item[filed] = value;
      }
    //验证只能输入整数【负数：isMinus传true】
    Vue.prototype.checkInteger = function (item, filed, isMinus) {
        var value = "" + item[filed]; //转字符串
        var t = value.charAt(0);
        value = value.replace(this.$commonUtils.Regex.isInteger, "");
        //是否允许负数
        if (isMinus && t == '-') {
          value = '-' + value;
        }
        item[filed] = value;
      },

      //是否是线上环境【发布时修改为true】
      Vue.prototype.isOnline = function () {
        return process.env.NODE_ENV !== 'development';
      },
      //文件类型数组
      Vue.prototype.FileType = function () {
        var fileTypeJson = {
          //主地址npm
          UserImg: "User", //用户相图片
          //常用提交数据URL
          GoodsImg: "Goods", //素材相关文件
          SetImg: "Set", //用户相图片
        };
        return fileTypeJson;
      },
      //上传文件到云存储
      Vue.prototype.UploadFileToTencent = function (path, fileObj, callback) {
        //获取文件扩展名
        var filename = fileObj.name;
        var index = filename.lastIndexOf(".");
        var suffix = filename.substr(index);
        var timestamp1 = Date.parse(new Date());
        let str = '';
        if (this.isOnline()) {
          str = "/Test"
        }
        var newFileName = str + '/Upload/' + path + "/" + timestamp1 + "" + suffix;
        var uploadMsg = {
          Bucket: "viitto-1301420277",
          Region: "ap-chengdu",
          /* 存储桶所在地域，必须字段 */
          SecretId: "AKIDDPnbIzi8C1eqEOPP8dw6MNAg9H9ldDKd",
          SecretKey: "PdcLtOjslUzNFYdU4OSI1fKtdHpFT2Ob",
        };
        var COS = require('cos-js-sdk-v5');
        var cos = new COS({
          SecretId: uploadMsg.SecretId,
          SecretKey: uploadMsg.SecretKey,
        });
        cos.putObject({
          Bucket: uploadMsg.Bucket,
          Region: uploadMsg.Region, //存储桶所在地域，必须字段
          Key: newFileName, //文件名
          StorageClass: 'STANDARD',
          Body: fileObj, // 上传文件对象
          onProgress: function (progressData) {}
        }, function (err, data) {
          if (data && data.statusCode == 200) {
            var uploadResult = {
              resultCode: 1,
              FileName: fileObj.name,
              FileUrl: "http://" + data.Location
            }
            if (callback) {
              callback(uploadResult);
            }
          } else {
            /*上传文件异常*/
            console.log(err || data);
          }
        });
      },
      //公用跳转
      Vue.prototype.CommonJump = function (path, obj) {
        this.$router.push({
          name: path,
          query: obj
        });
      }
      //公用判断图片地址 判断是否包含http
      Vue.prototype.getIconLink = function (url) {
        let str = ''
        if(url!=''){
          if (url.indexOf('http') != -1) {
            str = url
          } else {
            str = 'http://viitto-1301420277.cos.ap-chengdu.myqcloud.com' + url
          }
          return str;
        }
      }
      
    //HTTP提交数据
    Vue.prototype.apipost = function (cmd, msg, successCall, faildCall, isOnline) {
      if (msg == null || msg == "") {
        msg = {}
      }
      var apiurl = this.domainManager().DomainUrl + cmd;
      var timestamp = (new Date()).valueOf();
      this.apiurl = apiurl;
      if (!localStorage.mall_userInfo && localStorage.mall_userInfo != ""
      && this.$route.path.toLowerCase() != "/login"
      && this.$route.path.toLowerCase() != "/register"
       && this.$route.path.toLowerCase() != "/forgetpassword"
      ) {
        this.$router.push({
          path: '/login'
        })
      }
      var token = "";
      var key = "";
      var MallBaseId = "0"; //小程序ID
      var TenantId = "0"; //商户Id
      if (this.getLocalStorage() != null) {
        token = this.getLocalStorage().Token;
        key = this.getLocalStorage().SecretKey;
        MallBaseId = this.getLocalStorage().MallBaseId;
        TenantId = this.getLocalStorage().TenantId;
      }
      var encodeMsg = encodeURIComponent(JSON.stringify(msg)).toLowerCase();
      var md5Str = md5(`cmd=${cmd}&msg=${encodeMsg}&timestamp=${timestamp}&token=${token}&key=${key}`);
      let tempLanguage = 0;
      if (localStorage.language && localStorage.language != '') {
        if (localStorage.language == "zh-TW") {
          tempLanguage = 1;
        } else if (localStorage.language == "Japanese") {
          tempLanguage = 2;
        }
      }
      var postData = {
        "msg": msg,
        "timestamp": timestamp,
        "token": token,
        "sign": md5Str,
        "languageId": tempLanguage,
        "cmd": cmd,
        "MallBaseId": MallBaseId,
        "TenantId": TenantId
      }
      this.$http.post(apiurl, postData, {
          headers: {
            'Content-Type': 'application/json',
            'Referer-Viitto': this.$route.path
          }
        })
        .then(res => {
          if (res.data.resultCode == 10000 || res.data.resultCode == 10001) {
            this.$router.push({
              path: '/login'
            });
          } else if (res.resultCode == 10005) {
            this.$router.go(-1);
          } else {
            successCall(res);
          }
        }, faildCall)
    }
    Vue.prototype.JavaGetLocalFile = function (cmd, msg, fileName, successCall) {
      var apiurl = this.domainManager().DomainUrl + cmd;
      var timestamp = (new Date()).valueOf();
      if (!localStorage.mall_userInfo && localStorage.mall_userInfo != "" && this.$route.path.toLowerCase() != "/login") {
        this.$router.push({
          path: '/login'
        })
      }
      var token = "";
      var key = "";
      var MallBaseId = "0"; //小程序ID
      if (this.getLocalStorage() != null) {
        token = this.getLocalStorage().Token;
        key = this.getLocalStorage().SecretKey;
        MallBaseId = this.getLocalStorage().MallBaseId;

      }
      let mall_userInfo = localStorage.mall_userInfo ? JSON.parse(localStorage.mall_userInfo) : '';
      var encodeMsg = encodeURIComponent(JSON.stringify(msg)).toLowerCase();
      var md5Str = md5(`cmd=${cmd}&msg=${encodeMsg}&timestamp=${timestamp}&token=${token}&key=${key}`);
      let tempLanguage = 0;
      if (localStorage.language && localStorage.language != '') {
        if (localStorage.language == "zh-TW") {
          tempLanguage = 1;
        } else if (localStorage.language == "Japanese") {
          tempLanguage = 2;
        }
      }
      var postData = {
        "msg": msg,
        "timestamp": timestamp,
        "token": token,
        "sign": md5Str,
        "languageId": tempLanguage,
        "cmd": cmd,
        "MallBaseId": MallBaseId,

      }
      this.$http.post(apiurl, postData, {
        responseType: 'arraybuffer'
      }).then((res) => {
        let blob = new Blob([res.data], {
          type: "application/vnd.ms-excel"
        })
        let url = URL.createObjectURL(blob);
        let link = document.createElement('a');
        link.href = url;
        link.setAttribute("download", fileName);
        document.body.appendChild(link);
        link.click();
        successCall(res);
      }).catch(function (res) {});
    }
  }
}
