// The Vue build version to load with the `import` command
// (runtime-only or standalone) has been set in webpack.base.conf with an alias.
import Vue from 'vue'
import axios from 'axios'
import App from './App'
import router from './router'
import ajaxPlug from './plug/index'
import ElementUI from 'element-ui';
import 'element-ui/lib/theme-chalk/index.css';
import echarts from 'echarts'
import lrz from 'lrz'

import '../static/UE/ueditor.config.js'
import '../static/UE/ueditor.all.js'
import '../static/UE/lang/zh-cn/zh-cn.js'
import '../static/UE/ueditor.parse.min.js'

Vue.use(ElementUI);

import commonUtils from './assets/utils/commonUtils'
Vue.commonUtils = Vue.prototype.$commonUtils = commonUtils

Vue.config.productionTip = false
Vue.http = Vue.prototype.$http = axios
Vue.prototype.$echarts = echarts

Vue.use(ajaxPlug)
    /* eslint-disable no-new */
new Vue({
    el: '#app',
    router,
    components: { App },
    template: '<App/>'
})