import Vue from 'vue'
import Router from 'vue-router'

Vue.use(Router)
/**
 * 重写路由的push方法
 */
const routerPush = Router.prototype.push
Router.prototype.push = function push(location) {
  return routerPush.call(this, location).catch(error => error)
}

export default new Router({
  routes: [{
      path: '/',
      name: 'login',
      component: resolve => require(['@/components/Login'], resolve),
    },
    {
      path: '/login',
      name: 'login',
      component: resolve => require(['@/components/Login'], resolve),
    },
    {
      path: '/Forgetpassword',
      name: 'Forgetpassword',
      component: resolve => require(['@/components/Forgetpassword'], resolve),
    },
    {
      path: '/Register',
      name: 'Register',
      component: resolve => require(['@/components/Register'], resolve),
    },
    {
      path: '/index',
      name: 'index',
      component: resolve => require(['@/components/index'], resolve),
    },
    {
      path: '/sysindex', //系统相关设置
      name: 'sysindex',
      component: resolve => require(['@/components/sysindex'], resolve),
      children: [{
          path: '/menu',
          name: 'menu',
          component: resolve => require(['@/components/system/menu'], resolve),
        },
        {
          path: '/minimenu', //小程序菜单管理
          name: 'minimenu',
          component: resolve => require(['@/components/system/minimenu'], resolve),
        },
        {
          path: '/setminipage', //设置小程序菜单
          name: 'setminipage',
          component: resolve => require(['@/components/system/setminipage'], resolve),
        },
        {
          path: '/sysmenu', //设置商城菜单
          name: 'sysmenu',
          component: resolve => require(['@/components/system/sysmenu'], resolve),
        },
        {
          path: '/pluglist', //营销中心插件列表
          name: 'pluglist',
          component: resolve => require(['@/components/system/pluglist'], resolve),
        },
        {
          path: '/setmarketingplug', //设置营销插件
          name: 'setmarketingplug',
          component: resolve => require(['@/components/system/setmarketingplug'], resolve),
        },
        {
          path: '/diyplug', //diy装修插件
          name: 'diyplug',
          component: resolve => require(['@/components/system/diyplug'], resolve),
        },
        {
          path: '/setdiyplug', //设置diy插件
          name: 'setdiyplug',
          component: resolve => require(['@/components/system/setdiyplug'], resolve),
        },
      ]
    },
    {
      path: '/Fsetting', //微信小程序设置
      name: 'Fsetting',
      component: resolve => require(['@/components/Fsetting'], resolve),
      children: [
        //店铺管理 微信基础设置
        {
          path: '/wexinappconfig',
          name: 'wexinappconfig',
          component: resolve => require(['@/components/StoreDesign/wexinappconfig'], resolve),
        }, //店铺管理 微信基础设置
        {
          path: '/wexinappmsg',
          name: 'wexinappmsg',
          component: resolve => require(['@/components/StoreDesign/wexinappmsg'], resolve),
        },
        //店铺管理 小程序发布
        {
          path: '/AppletPublishing',
          name: 'AppletPublishing',
          component: resolve => require(['@/components/StoreDesign/AppletPublishing'], resolve),
        }
      ]
    },
    {
      path: '/Ftemplate', //DIY装修
      name: 'Ftemplate',
      component: resolve => require(['@/components/Ftemplate'], resolve),
      children: [{ //模板管理
        path: '/templateManage',
        name: 'templateManage',
        component: resolve => require(['@/components/sallCenter/templateManage'], resolve),
      }, { //添加 修改模板
        path: '/templateEdit',
        name: 'templateEdit',
        component: resolve => require(['@/components/sallCenter/templateEdit'], resolve),
      }, { //自定义页面
        path: '/CustomPage',
        name: 'CustomPage',
        component: resolve => require(['@/components/sallCenter/CustomPage'], resolve),
      }, { //授权页面
        path: '/authorization',
        name: 'authorization',
        component: resolve => require(['@/components/sallCenter/authorization'], resolve),
      }, { //模板市场
        path: '/templateMarket',
        name: 'templateMarket',
        component: resolve => require(['@/components/sallCenter/templateMarket'], resolve),
      }, { //模板市场管理页面
        path: '/templateMarketManage',
        name: 'templateMarketManage',
        component: resolve => require(['@/components/sallCenter/templateMarketManage'], resolve),
      }, { //启动页
        path: '/startupPage',
        name: 'startupPage',
        component: resolve => require(['@/components/sallCenter/startupPage'], resolve),
      }]
    },
    {
      path: '/authorize', //授权中心
      name: 'authorize',
      component: resolve => require(['@/components/authorize'], resolve),
      children: [
        //授权中心 集团授权状态
        {
          path: '/groupEmpower',
          name: 'groupEmpower',
          component: resolve => require(['@/components/empower/groupEmpower'], resolve),
        },
        //授权中心 授权管理
        {
          path: '/empowerManage',
          name: 'empowerManage',
          component: resolve => require(['@/components/empower/empowerManage'], resolve),
        },
        //授权中心 授权详情
        {
          path: '/empowerEdit',
          name: 'empowerEdit',
          component: resolve => require(['@/components/empower/empowerEdit'], resolve),
        },
        //授权中心 物料管理
        {
          path: '/materialQuery',
          name: 'materialQuery',
          component: resolve => require(['@/components/empower/materialQuery'], resolve),
        },
        //授权中心 采购管理
        {
          path: '/procurementMange',
          name: 'procurementMange',
          component: resolve => require(['@/components/empower/procurementMange'], resolve),
        },
        //授权中心 物料仓库
        {
          path: '/Materialwarehouse',
          name: 'Materialwarehouse',
          component: resolve => require(['@/components/empower/Materialwarehouse'], resolve),
        },
        //授权中心 入库
        {
          path: '/putinStorage',
          name: 'putinStorage',
          component: resolve => require(['@/components/empower/putinStorage'], resolve),
        },
        //授权中心 打印
        {
          path: '/printManage',
          name: 'printManage',
          component: resolve => require(['@/components/empower/printManage'], resolve),
        },
        //出库查询
        {
          path: '/deliveryQuery',
          name: 'deliveryQuery',
          component: resolve => require(['@/components/empower/deliveryQuery'], resolve),
        },
      ]
    },
    {
      path: '/directorIndex', //司导专区
      name: 'directorIndex',
      component: resolve => require(['@/components/director/directorIndex'], resolve),
      children: [
        //司导专区 基础设置
        {
          path: '/directorSetting',
          name: 'directorSetting',
          component: resolve => require(['@/components/director/directorSetting'], resolve),
        },
        //司导专区 产品列表
        {
          path: '/directorGoodsList',
          name: 'directorGoodsList',
          component: resolve => require(['@/components/director/directorGoodsList'], resolve),
        },
        //司导专区 商品修改和新增
        {
          path: '/directorGoodsEdit',
          name: 'directorGoodsEdit',
          component: resolve => require(['@/components/director/directorGoodsEdit'], resolve),
        },
        //司导专区 站点列表
        {
          path: '/guideCarSiteList',
          name: 'guideCarSiteList',
          component: resolve => require(['@/components/director/guideCarSiteList'], resolve),
        },
        //司导专区 站点的新增和修改
        {
          path: '/addSite',
          name: 'addSite',
          component: resolve => require(['@/components/director/addSite'], resolve),
        },
        //司导专区 导游列表
        {
          path: '/directorGuideList',
          name: 'directorGuideList',
          component: resolve => require(['@/components/director/directorGuideList'], resolve),
        },
        //司导专区 导游新增与修改
        {
          path: '/addGuide',
          name: 'addGuide',
          component: resolve => require(['@/components/director/addGuide'], resolve),
        },
        //司导专区 车辆管理
        {
          path: '/directorCarList',
          name: 'directorCarList',
          component: resolve => require(['@/components/director/directorCarList'], resolve),
        },
        //司导专区 车辆编辑
        {
          path: '/addCar',
          name: 'addCar',
          component: resolve => require(['@/components/director/addCar'], resolve),
        },
        //司导专区 车辆品牌
        {
          path: '/directorCarBrandList',
          name: 'directorCarBrandList',
          component: resolve => require(['@/components/director/directorCarBrandList'], resolve),
        },
        //司导专区 品牌修改
        {
          path: '/addCarBrand',
          name: 'addCarBrand',
          component: resolve => require(['@/components/director/addCarBrand'], resolve),
        },
        //司导专区 订单管理
        {
          path: '/directorOrderList',
          name: 'directorOrderList',
          component: resolve => require(['@/components/director/directorOrderList'], resolve),
        },
        //司导专区 订单详情
        {
          path: '/directorOrderDetails',
          name: 'directorOrderDetails',
          component: resolve => require(['@/components/director/directorOrderDetails'], resolve),
        }
      ]
    },
    {
      path: '/blindDateIndex', //相亲专区
      name: 'blindDateIndex',
      component: resolve => require(['@/components/blindDate/blindDateIndex'], resolve),
      children: [{
        path: '/plateList',
        name: 'plateList',
        component: resolve => require(['@/components/blindDate/plateList'], resolve),
      }, {
        path: '/recruitStick',
        name: 'recruitStick',
        component: resolve => require(['@/components/blindDate/recruitStick'], resolve),
      }, {
        path: '/registrationList',
        name: 'registrationList',
        component: resolve => require(['@/components/blindDate/registrationList'], resolve),
      }, {
        path: '/activityInfo',
        name: 'activityInfo',
        component: resolve => require(['@/components/blindDate/activityInfo'], resolve),
      },{
        path: '/addplate',
        name: 'addplate',
        component: resolve => require(['@/components/blindDate/addplate'], resolve),
      },{
        path: '/starsList',//相亲里面的星星充值列表
        name: 'starsList',
        component: resolve => require(['@/components/blindDate/starsList'], resolve),
      },{
        path: '/addstars',//相亲里面的星星充值管理
        name: 'addstars',
        component: resolve => require(['@/components/blindDate/addstars'], resolve),
      },{
        path: '/bdactivity', //相亲活动列表
        name: 'bdactivity',
        component: resolve => require(['@/components/blindDate/bdactivity'], resolve),
      },{
        path: '/bdactiveType', //相亲活动类型管理
        name: 'bdactiveType',
        component: resolve => require(['@/components/blindDate/bdactiveType'], resolve),
      },{
        path: '/topicList', //相亲活动话题列表
        name: 'topicList',
        component: resolve => require(['@/components/blindDate/topicList'], resolve),
      },{
        path: '/editTopic', //相亲活动话题编辑
        name: 'editTopic',
        component: resolve => require(['@/components/blindDate/editTopic'], resolve),
      },{
        path: '/appointList', //相亲约会记录、
        name: 'appointList',
        component: resolve => require(['@/components/blindDate/appointList'], resolve),
      },{
        path: '/editAppoint', //编辑约会记录
        name: 'editAppoint',
        component: resolve => require(['@/components/blindDate/editAppoint'], resolve),
      },{
        path: '/vipBuyList', //vip购买记录、
        name: 'vipBuyList',
        component: resolve => require(['@/components/blindDate/vipBuyList'], resolve),
      },]
    },
    {
      path: '/educationIndex', //网课专区
      name: 'educationIndex',
      component: resolve => require(['@/components/education/educationIndex'], resolve),
      children: [
        //网课 讲师管理
        {
          path: '/lecturermanage',
          name: 'lecturermanage',
          component: resolve => require(['@/components/education/lecturermanage'], resolve),
        },
        //网课 新增、修改讲师
        {
          path: '/addLecturer',
          name: 'addLecturer',
          component: resolve => require(['@/components/education/addLecturer'], resolve),
        },
        //网课 课程卡管理
        {
          path: '/courseCardManage',
          name: 'courseCardManage',
          component: resolve => require(['@/components/education/courseCardManage'], resolve),
        },
        //网课 新增、修改课程卡
        {
          path: '/addCourseCard',
          name: 'addCourseCard',
          component: resolve => require(['@/components/education/addCourseCard'], resolve),
        },
        //网课 发放课程卡
        {
          path: '/edgrantCouPon',
          name: 'edgrantCouPon',
          component: resolve => require(['@/components/education/edgrantCouPon'], resolve),
        },
        //网课 自动发放
        {
          path: '/edautorelease',
          name: 'edautorelease',
          component: resolve => require(['@/components/education/edautorelease'], resolve),
        },
        //网课 新增、修改自动发放
        {
          path: '/addedautorelease',
          name: 'addedautorelease',
          component: resolve => require(['@/components/education/addedautorelease'], resolve),
        },
        //网课 教育-资讯管理
        {
          path: '/informationManage',
          name: 'informationManage',
          component: resolve => require(['@/components/education/informationManage'], resolve),
        },
        //网课 教育-资讯评价
        {
          path: '/informationEvalution',
          name: 'informationEvalution',
          component: resolve => require(['@/components/education/informationEvalution'], resolve),
        },
        //网课 教育-课程管理
        {
          path: '/CourseManagement',
          name: 'CourseManagement',
          component: resolve => require(['@/components/education/CourseManagement'], resolve),
        },
        //网课 教育-新增修改
        {
          path: '/educationEdit',
          name: 'educationEdit',
          component: resolve => require(['@/components/education/educationEdit'], resolve),
        },
        //网课 教育-订单列表
        {
          path: '/educationOrder',
          name: 'educationOrder',
          component: resolve => require(['@/components/education/educationOrder'], resolve),
        },
        //网课 教育-订单详情
        {
          path: '/educationOrderDetail',
          name: 'educationOrderDetail',
          component: resolve => require(['@/components/education/educationOrderDetail'], resolve),
        },
        //网课 上传配置
        {
          path: '/uploadKCSet',
          name: 'uploadKCSet',
          component: resolve => require(['@/components/education/uploadKCSet'], resolve),
        },
        //网课 活动页面
        {
          path: '/activityList',
          name: 'activityList',
          component: resolve => require(['@/components/education/activityList'], resolve),
        },
        //网课 新增活动
        {
          path: '/addActivity',
          name: 'addActivity',
          component: resolve => require(['@/components/education/addActivity'], resolve),
        },
        //网课 问卷列表
        {
          path: '/questionnaireList',
          name: 'questionnaireList',
          component: resolve => require(['@/components/education/questionnaireList'], resolve),
        },
        //网课 用户问卷调查列表
        {
          path: '/resultPageList',
          name: 'resultPageList',
          component: resolve => require(['@/components/education/resultPageList'], resolve),
        },
        //网课 点数分页
        {
          path: '/pointList',
          name: 'pointList',
          component: resolve => require(['@/components/education/pointList'], resolve),
        },
        //网课 新增点数
        {
          path: '/addpoint',
          name: 'addpoint',
          component: resolve => require(['@/components/education/addpoint'], resolve),
        },
        //网课 在线分类列表
        {
          path: '/onlineclassifyList',
          name: 'onlineclassifyList',
          component: resolve => require(['@/components/education/onlineclassifyList'], resolve),
        },
        //网课 新增、修改分类
        {
          path: '/addclassify',
          name: 'addclassify',
          component: resolve => require(['@/components/education/addclassify'], resolve),
        },
        //网课 老师排课
        {
          path: '/teacherCourseList',
          name: 'teacherCourseList',
          component: resolve => require(['@/components/education/teacherCourseList'], resolve),
        },
        //网课 新增/修改老师排课
        {
          path: '/addteacherCourse',
          name: 'addteacherCourse',
          component: resolve => require(['@/components/education/addteacherCourse'], resolve),
        },
        //网课 排课订单
        {
          path: '/pointOrderList',
          name: 'pointOrderList',
          component: resolve => require(['@/components/education/pointOrderList'], resolve),
        },
        //网课 明细列表
        {
          path: '/userPointDetailList',
          name: 'userPointDetailList',
          component: resolve => require(['@/components/education/userPointDetailList'], resolve),
        },
        //网课 充值列表
        {
          path: '/rechargeList',
          name: 'rechargeList',
          component: resolve => require(['@/components/education/rechargeList'], resolve),
        }
      ]
    },
    {
      path: '/offlineIndex', //线下服务
      name: 'offlineIndex',
      component: resolve => require(['@/components/offlineService/offlineIndex'], resolve),
      children: [
        //线下基本设置
        {
          path: '/offlineSetup',
          name: 'offlineSetup',
          component: resolve => require(['@/components/offlineService/offlineSetup'], resolve),
        },
        //线下 套餐卡列表
        {
          path: '/osMealCardmanage',
          name: 'osMealCardmanage',
          component: resolve => require(['@/components/offlineService/osMealCardmanage'], resolve),
        },
        //线下 套餐卡编辑
        {
          path: '/osAddmealcard',
          name: 'osAddmealcard',
          component: resolve => require(['@/components/offlineService/osAddmealcard'], resolve),
        },
        //线下 套餐卡自动发放
        {
          path: '/osCardrelease',
          name: 'osCardrelease',
          component: resolve => require(['@/components/offlineService/osCardrelease'], resolve),
        },
        //线下 套餐卡自动发放编辑
        {
          path: '/osAddcardrelease',
          name: 'osAddcardrelease',
          component: resolve => require(['@/components/offlineService/osAddcardrelease'], resolve),
        },
        //线下 套餐卡发放
        {
          path: '/osedgrantCouPon',
          name: 'osedgrantCouPon',
          component: resolve => require(['@/components/offlineService/osedgrantCouPon'], resolve),
        },
        //线下服务产品列表
        {
          path: '/serviceProductList',
          name: 'serviceProductList',
          component: resolve => require(['@/components/offlineService/serviceProductList'], resolve),
        },
        //线下 服务产品列表 新增修改
        {
          path: '/serviceProductEdit',
          name: 'serviceProductEdit',
          component: resolve => require(['@/components/offlineService/serviceProductEdit'], resolve),
        },
        //线下服务产品订单列表
        {
          path: '/osOrderList',
          name: 'osOrderList',
          component: resolve => require(['@/components/offlineService/osOrderList'], resolve),
        },
        // 线下服务订单管理 商品详情
        {
          path: '/osOrderDetails',
          name: 'osOrderDetails',
          component: resolve => require(['@/components/offlineService/osOrderDetails'], resolve),
        },
        //线下 服务人员管理
        {
          path: '/ServiceMannage',
          name: 'ServiceMannage',
          component: resolve => require(['@/components/offlineService/ServiceMannage'], resolve)
        },
        //线下 服务人员新增修改
        {
          path: '/ServiceManageEdit',
          name: 'ServiceManageEdit',
          component: resolve => require(['@/components/offlineService/ServiceManageEdit'], resolve)
        },
        {
          path: '/scheduling',
          name: 'scheduling',
          component: resolve => require(['@/components/offlineService/scheduling'], resolve)
        },
        //店铺管理 内容管理 门店管理
        {
          path: '/storesManage',
          name: 'storesManage',
          component: resolve => require(['@/components/offlineService/storesManage'], resolve),
        },
        //线下 预约看板
        {
          path: '/appointmentBoard',
          name: 'appointmentBoard',
          component: resolve => require(['@/components/offlineService/appointmentBoard'], resolve),
        },
        //线下 服务人员绩效统计
        {
          path: '/performanceStatics',
          name: 'performanceStatics',
          component: resolve => require(['@/components/offlineService/performanceStatics'], resolve),
        },
        //线下 会员卡
        {
          path: '/osVipList',
          name: 'osVipList',
          component: resolve => require(['@/components/offlineService/osVipList'], resolve),
        },
        //线下 会员卡新增修改
        {
          path: '/osAddVip',
          name: 'osAddVip',
          component: resolve => require(['@/components/offlineService/osAddVip'], resolve),
        }
      ]
    },
    {
      path: '/tradePavilionIndex', //贸易管理
      name: 'tradePavilionIndex',
      component: resolve => require(['@/components/tradePavilion/tradePavilionIndex'], resolve),
      children: [
        //贸易管理--联系我们
        {
          path: '/contactus',
          name: 'contactus',
          component: resolve => require(['@/components/tradePavilion/contactus'], resolve),
        },
        //贸易管理--联系我们--新增联系人
        {
          path: '/addContact',
          name: 'addContact',
          component: resolve => require(['@/components/tradePavilion/addContact'], resolve),
        },
        //贸易管理--公司资料管理
        {
          path: '/companyList',
          name: 'companyList',
          component: resolve => require(['@/components/tradePavilion/companyList'], resolve),
        },
        //贸易管理--公司资料管理--公司详情
        {
          path: '/companyinfo',
          name: 'companyinfo',
          component: resolve => require(['@/components/tradePavilion/companyinfo'], resolve),
        },
        //贸易管理--活动类型管理
        {
          path: '/activityType',
          name: 'activityType',
          component: resolve => require(['@/components/tradePavilion/activityType'], resolve),
        },
        //贸易管理--活动列表
        {
          path: '/tradeactivityList',
          name: 'tradeactivityList',
          component: resolve => require(['@/components/tradePavilion/tradeactivityList'], resolve),
        },
        //贸易管理--新闻列表
        {
          path: '/newsList',
          name: 'newsList',
          component: resolve => require(['@/components/tradePavilion/newsList'], resolve),
        },
        //贸易管理--服务类型
        {
          path: '/serviceTypeList',
          name: 'serviceTypeList',
          component: resolve => require(['@/components/tradePavilion/serviceTypeList'], resolve),
        },
        //贸易管理--投资列表
        {
          path: '/investmentList',
          name: 'investmentList',
          component: resolve => require(['@/components/tradePavilion/investmentList'], resolve),
        },
        //贸易管理--采购列表
        {
          path: '/procurementList',
          name: 'procurementList',
          component: resolve => require(['@/components/tradePavilion/procurementList'], resolve),
        },
        //贸易管理--咨询管理
        {
          path: '/consultList',
          name: 'consultList',
          component: resolve => require(['@/components/tradePavilion/consultList'], resolve),
        },
        //贸易管理--载体管理
        {
          path: '/VehicleManagement',
          name: 'VehicleManagement',
          component: resolve => require(['@/components/tradePavilion/VehicleManagement'], resolve),
        },
        //贸易管理--载体管理编辑
        {
          path: '/editVehicle',
          name: 'editVehicle',
          component: resolve => require(['@/components/tradePavilion/editVehicle'], resolve),
        },
        //贸易管理--实名认证
        {
          path: '/realAuthentication',
          name: 'realAuthentication',
          component: resolve => require(['@/components/tradePavilion/realAuthentication'], resolve),
        },
        //贸易管理--品牌分类
        {
          path: '/brandClassification',
          name: 'brandClassification',
          component: resolve => require(['@/components/tradePavilion/brandClassification'], resolve),
        },
        //贸易管理--新增修改品牌
        {
          path: '/addbrand',
          name: 'addbrand',
          component: resolve => require(['@/components/tradePavilion/addbrand'], resolve),
        },
        //贸易管理--品牌管理
        {
          path: '/brandManagement',
          name: 'brandManagement',
          component: resolve => require(['@/components/tradePavilion/brandManagement'], resolve),
        },
        //贸易管理--首店申请
        {
          path: '/firstStoreApply',
          name: 'firstStoreApply',
          component: resolve => require(['@/components/tradePavilion/firstStoreApply'], resolve),
        },
        //贸易管理--首店详情
        {
          path: '/firstStoreDetail',
          name: 'firstStoreDetail',
          component: resolve => require(['@/components/tradePavilion/firstStoreDetail'], resolve),
        }
      ]
    },

    {
      path: '/mall',
      name: 'mall',
      component: resolve => require(['@/components/mall'], resolve),
      children: [{
          path: '/mallIndex',
          name: 'mallIndex',
          component: resolve => require(['@/components/mallIndex'], resolve),
        },
        // 用户管理 用户列表
        {
          path: '/usersList',
          name: 'usersList',
          component: resolve => require(['@/components/UserMan/usersList'], resolve),
        },
        // 用户管理 用户列表编辑
        {
          path: '/usersListEdit',
          name: 'usersListEdit',
          component: resolve => require(['@/components/UserMan/usersListEdit'], resolve),
        },
        // 用户管理 相亲用户列表
        {
          path: '/blindDateUsersList',
          name: 'blindDateUsersList',
          component: resolve => require(['@/components/UserMan/blindDateUsersList'], resolve),
        },
        // 用户管理 用户列表的编辑
        {
          path: '/blindDateUsersListEdit',
          name: 'blindDateUsersListEdit',
          component: resolve => require(['@/components/UserMan/blindDateUsersListEdit'], resolve),
        },
        // 用户管理 新增用户
        {
          path: '/addUsers',
          name: 'addUsers',
          component: resolve => require(['@/components/UserMan/addUsers'], resolve),
        },
        // 用户管理 相亲用户新增
        {
          path: '/addblindDateuser',
          name: 'addblindDateuser',
          component: resolve => require(['@/components/UserMan/addblindDateuser'], resolve),
        },

        // 用户管理 核销员
        {
          path: '/verificationMember',
          name: 'verificationMember',
          component: resolve => require(['@/components/UserMan/verificationMember'], resolve),
        },
        // 用户管理 会员等级
        {
          path: '/MembershipGrade',
          name: 'MembershipGrade',
          component: resolve => require(['@/components/UserMan/MembershipGrade'], resolve),
        },
        // 用户管理 会员等级/会员设置
        {
          path: '/setMember',
          name: 'setMember',
          component: resolve => require(['@/components/UserMan/setMember'], resolve),
        },
        // 用户管理 充值中心
        {
          path: '/depositCenter',
          name: 'depositCenter',
          component: resolve => require(['@/components/UserMan/depositCenter'], resolve),
        },
        //用户管理 村联卡编辑
        {
          path: '/editDeposit',
          name: 'editDeposit',
          component: resolve => require(['@/components/UserMan/editDeposit'], resolve),
        },
        // 用户管理 会员等级/会员购买
        {
          path: '/MembersBuy',
          name: 'MembersBuy',
          component: resolve => require(['@/components/UserMan/MembersBuy'], resolve),
        },
        // 用户管理 分销商管理 基础设置
        {
          path: '/baseSet',
          name: 'baseSet',
          component: resolve => require(['@/components/UserMan/baseSet'], resolve),
        },
        // 用户管理 分销商管理 自定义设置
        {
          path: '/customSet',
          name: 'customSet',
          component: resolve => require(['@/components/UserMan/customSet'], resolve),
        },
        // 用户管理 分销商管理 粉象分销等级
        {
          path: '/fxDistribution',
          name: 'fxDistribution',
          component: resolve => require(['@/components/UserMan/fxDistribution'], resolve),
        },
        //用户管理 分销商管理 粉象返佣
        {
          path: '/fxCommission',
          name: 'fxCommission',
          component: resolve => require(['@/components/UserMan/fxCommission'], resolve),
        },
        // 用户管理 分销商管理 分销商等级
        {
          path: '/distributorLevel',
          name: 'distributorLevel',
          component: resolve => require(['@/components/UserMan/distributorLevel'], resolve),
        },
        // 用户管理 分销商管理 新增或编辑分销商等级
        {
          path: '/setDistributorLevel',
          name: 'setDistributorLevel',
          component: resolve => require(['@/components/UserMan/setDistributorLevel'], resolve),
        },
        // 用户管理 分销商管理 和平分销商等级
        {
          path: '/PdistributorLevel',
          name: 'PdistributorLevel',
          component: resolve => require(['@/components/UserMan/PdistributorLevel'], resolve),
        },
        // 用户管理 分销商管理 和平分销商
        {
          path: '/PeaceDistribution',
          name: 'PeaceDistribution',
          component: resolve => require(['@/components/UserMan/PeaceDistribution'], resolve),
        },
        // 用户管理 分销商管理 和平分销商
        {
          path: '/PeaceDistributionSet',
          name: 'PeaceDistributionSet',
          component: resolve => require(['@/components/UserMan/PeaceDistributionSet'], resolve),
        },
        // 用户管理 分销商管理 分销商
        {
          path: '/distributors',
          name: 'distributors',
          component: resolve => require(['@/components/UserMan/distributors'], resolve),
        },
        // 用户管理 分销商管理 分销提现
        {
          path: '/disWithdrawal',
          name: 'disWithdrawal',
          component: resolve => require(['@/components/UserMan/disWithdrawal'], resolve),
        },
        //用户管理 分销商管理 vip购买记录
        {
          path: '/buyRecords',
          name: 'buyRecords',
          component: resolve => require(['@/components/UserMan/buyRecords'], resolve),
        },
        //用户管理 分销商管理 vip购买分销
        {
          path: '/vipbuySales',
          name: 'vipbuySales',
          component: resolve => require(['@/components/UserMan/vipbuySales'], resolve),
        },
        // 用户管理 分销订单
        {
          path: '/distributionOrder',
          name: 'distributionOrder',
          component: resolve => require(['@/components/UserMan/distributionOrder'], resolve),
        },
        // 用户管理 推荐返利列表
        {
          path: '/RecommendRebate',
          name: 'RecommendRebate',
          component: resolve => require(['@/components/UserMan/RecommendRebate'], resolve),
        },

        // 用户管理 优惠券管理
        {
          path: '/usersCoupon',
          name: 'usersCoupon',
          component: resolve => require(['@/components/UserMan/usersCoupon'], resolve),
        },
        // 用户管理 微店的基础设置
        {
          path: '/tinyMerchantSet',
          name: 'tinyMerchantSet',
          component: resolve => require(['@/components/UserMan/tinyMerchant/tinyMerchantSet'], resolve),
        },
        // 用户管理 微店的自定义设置
        {
          path: '/wdCustomSet',
          name: 'wdCustomSet',
          component: resolve => require(['@/components/UserMan/tinyMerchant/wdCustomSet'], resolve),
        },
        // 用户管理 微店审核
        {
          path: '/wdExamine',
          name: 'wdExamine',
          component: resolve => require(['@/components/UserMan/tinyMerchant/wdExamine'], resolve),
        },
        // 用户管理 微店订单
        {
          path: '/wdOrder',
          name: 'wdOrder',
          component: resolve => require(['@/components/UserMan/tinyMerchant/wdOrder'], resolve),
        },
        // 用户管理 微店提现
        {
          path: '/wdWithdrawal',
          name: 'wdWithdrawal',
          component: resolve => require(['@/components/UserMan/tinyMerchant/wdWithdrawal'], resolve),
        },
        // 商品管理 素材管理
        {
          path: '/materialMan',
          name: 'materialMan',
          component: resolve => require(['@/components/CommodityMan/materialMan'], resolve),
        },
        // 商品管理 商品分类
        {
          path: '/goodsClassification',
          name: 'goodsClassification',
          component: resolve => require(['@/components/CommodityMan/goodsClassification'], resolve),
        },
        // 商品管理 添加商品分类
        {
          path: '/addGoodsClass',
          name: 'addGoodsClass',
          component: resolve => require(['@/components/CommodityMan/addGoodsClass'], resolve),
        },
        // 商品管理 规格模板
        {
          path: '/SpecificationTemplate',
          name: 'SpecificationTemplate',
          component: resolve => require(['@/components/CommodityMan/SpecificationTemplate'], resolve),
        },
        // 商品管理 快速购买
        {
          path: '/quickBuy',
          name: 'quickBuy',
          component: resolve => require(['@/components/CommodityMan/quickBuy'], resolve),
        },
        // 商品管理 推荐设置
        {
          path: '/RecSettings',
          name: 'RecSettings',
          component: resolve => require(['@/components/CommodityMan/RecSettings'], resolve),
        },
        // 商品管理 商品服务
        {
          path: '/goodsServices',
          name: 'goodsServices',
          component: resolve => require(['@/components/CommodityMan/goodsServices'], resolve),
        },
        // 商品管理 商品服务新增或修改
        {
          path: '/goodsServicesEdit',
          name: 'goodsServicesEdit',
          component: resolve => require(['@/components/CommodityMan/goodsServicesEdit'], resolve),
        },
        // 商品管理 商品列表
        {
          path: '/goodsList',
          name: 'goodsList',
          component: resolve => require(['@/components/CommodityMan/goodsList'], resolve),
        },
        // 商品管理 商品列表新增
        {
          path: '/goodsListEdit',
          name: 'goodsListEdit',
          component: resolve => require(['@/components/CommodityMan/goodsListEdit'], resolve),
        },
        // 商品管理 批量导入
        {
          path: '/bulkImport',
          name: 'bulkImport',
          component: resolve => require(['@/components/CommodityMan/bulkImport'], resolve),
        },

        // 商品管理 淘宝CSV
        {
          path: '/taoBaoCSV',
          name: 'taoBaoCSV',
          component: resolve => require(['@/components/CommodityMan/taoBaoCSV'], resolve),
        }, // 商品管理 供应商管理
        {
          path: '/supplierManage',
          name: 'supplierManage',
          component: resolve => require(['@/components/CommodityMan/supplierManage'], resolve),
        },
        // 商品管理 供应商新增或修改
        {
          path: '/supplierEdit',
          name: 'supplierEdit',
          component: resolve => require(['@/components/CommodityMan/supplierEdit'], resolve),
        },
        // 订单管理 商品列表新增
        {
          path: '/orderList',
          name: 'orderList',
          component: resolve => require(['@/components/orderMan/orderList'], resolve),
        },
        // 订单管理 商品详情
        {
          path: '/orderDetails',
          name: 'orderDetails',
          component: resolve => require(['@/components/orderMan/orderDetails'], resolve),
        },
        // 订单管理 售后订单
        {
          path: '/afterSalesOrder',
          name: 'afterSalesOrder',
          component: resolve => require(['@/components/orderMan/afterSalesOrder'], resolve),
        },
        //订单管理 推荐账单
        {
          path: '/RecommendBill',
          name: 'RecommendBill',
          component: resolve => require(['@/components/orderMan/RecommendBill'], resolve),
        },
        //订单管理 推荐账单-详情
        {
          path: '/RecomBillDetail',
          name: 'RecomBillDetail',
          component: resolve => require(['@/components/orderMan/RecomBillDetail'], resolve),
        },
        //成本管理
        {
          path: '/CostManagement',
          name: 'CostManagement',
          component: resolve => require(['@/components/orderMan/CostManagement'], resolve),
        },
        //出库管理
        {
          path: '/outboundManage',
          name: 'outboundManage',
          component: resolve => require(['@/components/orderMan/outboundManage'], resolve),
        },

        // 订单管理 售后订单详情
        {
          path: '/salesOrderDetails',
          name: 'salesOrderDetails',
          component: resolve => require(['@/components/orderMan/salesOrderDetails'], resolve),
        },
        // 订单管理 评价模板
        {
          path: '/evaluationTemplate',
          name: 'evaluationTemplate',
          component: resolve => require(['@/components/orderMan/evaluationTemplate'], resolve),
        },
        // 订单管理 评价管理
        {
          path: '/evaluationMan',
          name: 'evaluationMan',
          component: resolve => require(['@/components/orderMan/evaluationMan'], resolve),
        },
        //订单管理 司导评价
        {
          path: '/carEvaluation',
          name: 'carEvaluation',
          component: resolve => require(['@/components/orderMan/carEvaluation'], resolve),
        },
        // 订单管理 客户评价
        {
          path: '/customerEvaluation',
          name: 'customerEvaluation',
          component: resolve => require(['@/components/orderMan/customerEvaluation'], resolve),
        },
        // 订单管理 批量发货
        {
          path: '/BulkShipment',
          name: 'BulkShipment',
          component: resolve => require(['@/components/orderMan/BulkShipment'], resolve),
        },
        // 订单管理 批量发货
        {
          path: '/BulkShipment',
          name: 'BulkShipment',
          component: resolve => require(['@/components/orderMan/BulkShipment'], resolve),
        },
        // 订单管理 财务配置
        {
          path: '/financialAllocation',
          name: 'financialAllocation',
          component: resolve => require(['@/components/orderMan/financialAllocation'], resolve),
        },
        // 订单管理 损益核算
        {
          path: '/OrderProfitLossList',
          name: 'OrderProfitLossList',
          component: resolve => require(['@/components/orderMan/OrderProfitLossList'], resolve),
        },
        //订单管理 直播订单
        {
          path: '/LiveOrder',
          name: 'LiveOrder',
          component: resolve => require(['@/components/orderMan/LiveOrder'], resolve),
        },
        //订单管理 操作记录
        {
          path: '/operationList',
          name: 'operationList',
          component: resolve => require(['@/components/orderMan/operationList'], resolve),
        },
        //设置 基础设置
        {
          path: '/basicSetUp',
          name: 'basicSetUp',
          component: resolve => require(['@/components/setup/basicSetUp'], resolve),
        },
        // 物流设置 规则设置
        {
          path: '/ruleSetup',
          name: 'ruleSetup',
          component: resolve => require(['@/components/setup/ruleSetup'], resolve),
        },
        //店铺管理 轮播图
        {
          path: '/ShufflingFigure',
          name: 'ShufflingFigure',
          component: resolve => require(['@/components/StoreDesign/ShufflingFigure'], resolve),
        },
        //店铺管理 导航图标
        {
          path: '/navigationIcon',
          name: 'navigationIcon',
          component: resolve => require(['@/components/StoreDesign/navigationIcon'], resolve),
        },
        // 物流设置 新增运费规则
        {
          path: '/addFreightRule',
          name: 'addFreightRule',
          component: resolve => require(['@/components/setup/addFreightRule'], resolve),
        },
        //物流设置 新增包邮规则
        {
          path: '/addFreeshipping',
          name: 'addFreeshipping',
          component: resolve => require(['@/components/setup/addFreeshipping'], resolve),
        },
        //活动设置 活动列表
        {
          path: '/setupActivityList',
          name: 'setupActivityList',
          component: resolve => require(['@/components/setup/setupActivityList'], resolve),
        }, //活动设置 中奖列表
        {
          path: '/winningList',
          name: 'winningList',
          component: resolve => require(['@/components/setup/winningList'], resolve),
        }, //活动设置 新增和修改
        {
          path: '/AddsetupActicity',
          name: 'AddsetupActicity',
          component: resolve => require(['@/components/setup/AddsetupActicity'], resolve),
        },
        //店铺管理 导航图标
        {
          path: '/navigationIcon',
          name: 'navigationIcon',
          component: resolve => require(['@/components/StoreDesign/navigationIcon'], resolve),
        },
        //店铺管理 商城风格
        {
          path: '/storeStyle',
          name: 'storeStyle',
          component: resolve => require(['@/components/StoreDesign/storeStyle'], resolve),
        },
        //店铺管理 图片魔方
        {
          path: '/imgCube',
          name: 'imgCube',
          component: resolve => require(['@/components/StoreDesign/imgCube'], resolve),
        },
        //店铺管理 标签栏
        {
          path: '/labelBar',
          name: 'labelBar',
          component: resolve => require(['@/components/StoreDesign/labelBar'], resolve),
        },
        //店铺设计 首页布局
        {
          path: '/HomePageLayout',
          name: 'HomePageLayout',
          component: resolve => require(['@/components/StoreDesign/HomePageLayout'], resolve),
        },
        //店铺管理 小程序页面
        {
          path: '/minipage',
          name: 'minipage',
          component: resolve => require(['@/components/StoreDesign/minipage'], resolve),
        },
        //店铺管理 内容管理 文章
        {
          path: '/Article',
          name: 'Article',
          component: resolve => require(['@/components/StoreDesign/Article'], resolve),
        },
        //店铺管理 内容管理 专题分类
        {
          path: '/ProjectClassific',
          name: 'ProjectClassific',
          component: resolve => require(['@/components/StoreDesign/ProjectClassific'], resolve),
        },
        //店铺管理 内容管理 专题
        {
          path: '/special',
          name: 'special',
          component: resolve => require(['@/components/StoreDesign/special'], resolve),
        },
        //店铺管理 内容管理 视频管理
        {
          path: '/videoManage',
          name: 'videoManage',
          component: resolve => require(['@/components/StoreDesign/videoManage'], resolve),
        },
        //店铺管理 内容管理 直播管理
        {
          path: '/liveManage',
          name: 'liveManage',
          component: resolve => require(['@/components/StoreDesign/liveManage'], resolve),
        },
        //直播管理 内容管理 直播配置
        {
          path: '/liveConfig',
          name: 'liveConfig',
          component: resolve => require(['@/components/StoreDesign/liveConfig'], resolve),
        },
        //直播管理 内容管理 直播配置=复制
        {
          path: '/liveSet',
          name: 'liveSet',
          component: resolve => require(['@/components/StoreDesign/liveSet'], resolve),
        },
        //店铺管理 员工管理 基础设置
        {
          path: '/Infrastructure',
          name: 'Infrastructure',
          component: resolve => require(['@/components/StoreDesign/Infrastructure'], resolve),
        },
        //店铺管理 员工管理 角色列表
        {
          path: '/roleList',
          name: 'roleList',
          component: resolve => require(['@/components/StoreDesign/roleList'], resolve),
        },
        //店铺管理 员工管理 员工列表
        {
          path: '/EmployeesList',
          name: 'EmployeesList',
          component: resolve => require(['@/components/StoreDesign/EmployeesList'], resolve),
        },
        //店铺管理 小程序页面标题
        {
          path: '/minititle',
          name: 'minititle',
          component: resolve => require(['@/components/StoreDesign/minititle'], resolve),
        }, //店铺管理 版权设置
        {
          path: '/copyrightset',
          name: 'copyrightset',
          component: resolve => require(['@/components/StoreDesign/copyrightset'], resolve),
        },
        //店铺管理 用户中心
        {
          path: '/userCenter',
          name: 'userCenter',
          component: resolve => require(['@/components/StoreDesign/userCenter'], resolve),
        },
        //店铺管理 自定义海报
        {
          path: '/customPoster',
          name: 'customPoster',
          component: resolve => require(['@/components/StoreDesign/customPoster'], resolve),
        },
        //店铺管理 相亲海报
        {
          path: '/blindDatebill',
          name: 'blindDatebill',
          component: resolve => require(['@/components/StoreDesign/blindDatebill'], resolve),
        },
        //店铺管理 校园海报
        {
          path: '/schoolPoster',
          name: 'schoolPoster',
          component: resolve => require(['@/components/StoreDesign/schoolPoster'], resolve),
        },
        //店铺管理 财务管理-出纳提现
        {
          path: '/CashierWithdrawal',
          name: 'CashierWithdrawal',
          component: resolve => require(['@/components/StoreDesign/CashierWithdrawal'], resolve),
        },
        //营销中心 插件中心
        {
          path: '/pluginCenter',
          name: 'pluginCenter',
          component: resolve => require(['@/components/sallCenter/pluginCenter'], resolve),
        },
        //物流设置 退货地址列表
        {
          path: '/returnAddressList',
          name: 'returnAddressList',
          component: resolve => require(['@/components/setup/returnAddressList'], resolve),
        },
        //物流设置 新增退货地址
        {
          path: '/addAddress',
          name: 'addAddress',
          component: resolve => require(['@/components/setup/addAddress'], resolve),
        },
        //物流设置 区域购买
        {
          path: '/regionBuy',
          name: 'regionBuy',
          component: resolve => require(['@/components/setup/regionBuy'], resolve),
        },
        //物流设置 电子面单
        {
          path: '/electronFaceSheet',
          name: 'electronFaceSheet',
          component: resolve => require(['@/components/setup/electronFaceSheet'], resolve),
        },
        //物流设置 新增电子面单
        {
          path: '/addElectronFaceSheet',
          name: 'addElectronFaceSheet',
          component: resolve => require(['@/components/setup/addElectronFaceSheet'], resolve),
        },
        //物流设置 新包邮规则
        {
          path: '/mailRules',
          name: 'mailRules',
          component: resolve => require(['@/components/setup/mailRules'], resolve),
        },
        //物流设置 新包邮规则修改/新增
        {
          path: '/mailRulesSet',
          name: 'mailRulesSet',
          component: resolve => require(['@/components/setup/mailRulesSet'], resolve),
        },

        //设置 上传设置
        {
          path: '/uploadSettings',
          name: 'uploadSettings',
          component: resolve => require(['@/components/setup/uploadSettings'], resolve),
        },
        //设置 快递设置
        {
          path: '/expressSetup',
          name: 'expressSetup',
          component: resolve => require(['@/components/setup/expressSetup'], resolve),
        },
        //数据统计 发放统计
        {
          path: '/grantStatistics',
          name: 'grantStatistics',
          component: resolve => require(['@/components/statistics/grantStatistics'], resolve),
        },

        //数据统计 分销排行
        {
          path: '/retailRanking',
          name: 'retailRanking',
          component: resolve => require(['@/components/statistics/retailRanking'], resolve),
        },
        //数据统计 积分收支
        {
          path: '/integralBudget',
          name: 'integralBudget',
          component: resolve => require(['@/components/statistics/integralBudget'], resolve),
        },
        //营销中心 余额收支
        {
          path: '/balanceBudget',
          name: 'balanceBudget',
          component: resolve => require(['@/components/sallCenter/balanceBudget'], resolve),
        },
        //数据统计 销售统计
        {
          path: '/salesStatistics',
          name: 'salesStatistics',
          component: resolve => require(['@/components/statistics/salesStatistics'], resolve),
        },
        //数据统计 用户统计
        {
          path: '/cutomerStatistics',
          name: 'cutomerStatistics',
          component: resolve => require(['@/components/statistics/cutomerStatistics'], resolve),
        },
        //营销中心 充值管理
        {
          path: '/rechargeManage',
          name: 'rechargeManage',
          component: resolve => require(['@/components/sallCenter/rechargeManage'], resolve),
        },
        //营销中心 新增充值方案
        {
          path: '/addRechargeScheme',
          name: 'addRechargeScheme',
          component: resolve => require(['@/components/sallCenter/addRechargeScheme'], resolve),
        },
        //营销中心 充值设置
        {
          path: '/rechargeSet',
          name: 'rechargeSet',
          component: resolve => require(['@/components/sallCenter/rechargeSet'], resolve),
        },
        //营销中心 积分设置
        {
          path: '/integralSetting',
          name: 'integralSetting',
          component: resolve => require(['@/components/sallCenter/integralSetting'], resolve),
        },
        //营销中心 积分记录
        {
          path: '/IntegralRecord',
          name: 'IntegralRecord',
          component: resolve => require(['@/components/sallCenter/IntegralRecord'], resolve),
        },
        //营销中心 卡券列表
        {
          path: '/cardTicketList',
          name: 'cardTicketList',
          component: resolve => require(['@/components/sallCenter/cardTicketList'], resolve),
        },
        //营销中心 优惠券管理
        {
          path: '/couponManage',
          name: 'couponManage',
          component: resolve => require(['@/components/sallCenter/couponManage'], resolve),
        },
        //营销中心 自动发放
        {
          path: '/autorelease',
          name: 'autorelease',
          component: resolve => require(['@/components/sallCenter/autorelease'], resolve),
        },
        //营销中心 新增优惠券
        {
          path: '/addCoupon',
          name: 'addCoupon',
          component: resolve => require(['@/components/sallCenter/addCoupon'], resolve),
        },
        //营销中心 新增卡券
        {
          path: '/addCardTicket',
          name: 'addCardTicket',
          component: resolve => require(['@/components/sallCenter/addCardTicket'], resolve),
        },
        //营销中心 优惠券=》发放优惠券
        {
          path: '/grantCouPon',
          name: 'grantCouPon',
          component: resolve => require(['@/components/sallCenter/grantCouPon'], resolve),
        },
        //营销中心 自动发放优惠券
        {
          path: '/addAutoreleaseCoupon',
          name: 'addAutoreleaseCoupon',
          component: resolve => require(['@/components/sallCenter/addAutoreleaseCoupon'], resolve),
        },

      ]
    },
    {
      path: '/pintuanMain',
      name: 'pintuanMain',
      component: resolve => require(['@/components/pintuanMain'], resolve),
      children: [
        //拼团 拼团设置
        {
          path: '/pintuanSet',
          name: 'pintuanSet',
          component: resolve => require(['@/components/pintuan/pintuanSet'], resolve),
        },
        //拼团 消息通知
        {
          path: '/pintuanMsg',
          name: 'pintuanMsg',
          component: resolve => require(['@/components/pintuan/pintuanMsg'], resolve),
        },
        //拼团 拼团活动-列表
        {
          path: '/pintuanList',
          name: 'pintuanList',
          component: resolve => require(['@/components/pintuan/pintuanList'], resolve),
        },
        //拼团 拼团活动
        {
          path: '/pintuanActive',
          name: 'pintuanActive',
          component: resolve => require(['@/components/pintuan/pintuanActive'], resolve),
        },
        //拼团 活动数据
        {
          path: '/ActiveData',
          name: 'ActiveData',
          component: resolve => require(['@/components/pintuan/ActiveData'], resolve),
        },
        //拼团 活动数据 列表跳过去
        {
          path: '/ActiveDataDetail',
          name: 'ActiveDataDetail',
          component: resolve => require(['@/components/pintuan/ActiveDataDetail'], resolve),
        }
      ]
    },
    //一键发圈
    {
      path: "/FShareMain",
      name: 'FShareMain',
      component: resolve => require(['@/components/FShareMain'], resolve),
      children: [
        //一键发圈=>分类
        {
          path: '/shareCategory',
          name: 'shareCategory',
          component: resolve => require(['@/components/Share/shareCategory'], resolve),
        },
        //一键发圈
        {
          path: '/shareFriend',
          name: 'shareFriend',
          component: resolve => require(['@/components/Share/shareFriend'], resolve),
        }
      ]
    }

  ]
})
