import Vue from 'vue'
import Router from 'vue-router'

Vue.use(Router)
/**
 * 重写路由的push方法
 */
const routerPush = Router.prototype.push
Router.prototype.push = function push(location) {
  return routerPush.call(this, location).catch(error => error)
}

export default new Router({
  routes: [{
      path: '/',
      name: 'login',
      component: resolve => require(['@/components/Login'], resolve),
    },
    {
      path: '/login',
      name: 'login',
      component: resolve => require(['@/components/Login'], resolve),
    },
    {
      path: '/Forgetpassword',
      name: 'Forgetpassword',
      component: resolve => require(['@/components/Forgetpassword'], resolve),
    },
    {
      path: '/Register',
      name: 'Register',
      component: resolve => require(['@/components/Register'], resolve),
    },
    {
      path: '/index',
      name: 'index',
      component: resolve => require(['@/components/index'], resolve),
    },
    {
      path: '/menu',
      name: 'menu',
      component: resolve => require(['@/components/system/menu'], resolve),
    },
    {
      path: '/minimenu', //小程序菜单管理
      name: 'minimenu',
      component: resolve => require(['@/components/system/minimenu'], resolve),
    },
    {
      path: '/setminipage', //设置小程序菜单
      name: 'setminipage',
      component: resolve => require(['@/components/system/setminipage'], resolve),
    },
    {
      path: '/Fsetting', //微信小程序设置
      name: 'Fsetting',
      component: resolve => require(['@/components/Fsetting'], resolve),
      children: [
        //店铺管理 微信基础设置
        {
          path: '/wexinappconfig',
          name: 'wexinappconfig',
          component: resolve => require(['@/components/StoreDesign/wexinappconfig'], resolve),
        }, //店铺管理 微信基础设置
        {
          path: '/wexinappmsg',
          name: 'wexinappmsg',
          component: resolve => require(['@/components/StoreDesign/wexinappmsg'], resolve),
        },
        //店铺管理 小程序发布
        {
          path: '/AppletPublishing',
          name: 'AppletPublishing',
          component: resolve => require(['@/components/StoreDesign/AppletPublishing'], resolve),
        }
      ]
    },
    {
      path: '/Ftemplate', //DIY装修
      name: 'Ftemplate',
      component: resolve => require(['@/components/Ftemplate'], resolve),
      children: [{ //模板管理
        path: '/templateManage',
        name: 'templateManage',
        component: resolve => require(['@/components/sallCenter/templateManage'], resolve),
      }, { //添加 修改模板
        path: '/templateEdit',
        name: 'templateEdit',
        component: resolve => require(['@/components/sallCenter/templateEdit'], resolve),
      }, { //自定义页面
        path: '/CustomPage',
        name: 'CustomPage',
        component: resolve => require(['@/components/sallCenter/CustomPage'], resolve),
      }, { //授权页面
        path: '/authorization',
        name: 'authorization',
        component: resolve => require(['@/components/sallCenter/authorization'], resolve),
      }, { //模板市场
        path: '/templateMarket',
        name: 'templateMarket',
        component: resolve => require(['@/components/sallCenter/templateMarket'], resolve),
      }, { //模板市场管理页面
        path: '/templateMarketManage',
        name: 'templateMarketManage',
        component: resolve => require(['@/components/sallCenter/templateMarketManage'], resolve),
      }]
    },
    {
      path: '/authorize', //授权中心
      name: 'authorize',
      component: resolve => require(['@/components/authorize'], resolve),
      children: [
        //授权中心 集团授权状态
        {
          path: '/groupEmpower',
          name: 'groupEmpower',
          component: resolve => require(['@/components/empower/groupEmpower'], resolve),
        }, 
         //授权中心 授权管理
         {
          path: '/empowerManage',
          name: 'empowerManage',
          component: resolve => require(['@/components/empower/empowerManage'], resolve),
        }, 
         //授权中心 授权详情
         {
          path: '/empowerEdit',
          name: 'empowerEdit',
          component: resolve => require(['@/components/empower/empowerEdit'], resolve),
        },
        //授权中心 物料管理
        {
          path: '/materialQuery',
          name: 'materialQuery',
          component: resolve => require(['@/components/empower/materialQuery'], resolve),
        },
        //授权中心 采购管理
        {
          path: '/procurementMange',
          name: 'procurementMange',
          component: resolve => require(['@/components/empower/procurementMange'], resolve),
        }, 
         //授权中心 物料仓库
         {
          path: '/Materialwarehouse',
          name: 'Materialwarehouse',
          component: resolve => require(['@/components/empower/Materialwarehouse'], resolve),
        }, 
         //授权中心 入库
         {
          path: '/putinStorage',
          name: 'putinStorage',
          component: resolve => require(['@/components/empower/putinStorage'], resolve),
        }, 
         //授权中心 打印
         {
          path: '/printManage',
          name: 'printManage',
          component: resolve => require(['@/components/empower/printManage'], resolve),
        }, 
        
        
      ]
    },
    {
      path: '/mall',
      name: 'mall',
      component: resolve => require(['@/components/mall'], resolve),
      children: [{
          path: '/mallIndex',
          name: 'mallIndex',
          component: resolve => require(['@/components/mallIndex'], resolve),
        },
        // 用户管理 用户列表
        {
          path: '/usersList',
          name: 'usersList',
          component: resolve => require(['@/components/UserMan/usersList'], resolve),
        },
        // 用户管理 用户列表编辑
        {
          path: '/usersListEdit',
          name: 'usersListEdit',
          component: resolve => require(['@/components/UserMan/usersListEdit'], resolve),
        },

        // 用户管理 核销员
        {
          path: '/verificationMember',
          name: 'verificationMember',
          component: resolve => require(['@/components/UserMan/verificationMember'], resolve),
        },
        // 用户管理 会员等级
        {
          path: '/MembershipGrade',
          name: 'MembershipGrade',
          component: resolve => require(['@/components/UserMan/MembershipGrade'], resolve),
        },
        // 用户管理 会员等级/会员设置
        {
          path: '/setMember',
          name: 'setMember',
          component: resolve => require(['@/components/UserMan/setMember'], resolve),
        },
        // 用户管理 会员等级/会员购买
        {
          path: '/MembersBuy',
          name: 'MembersBuy',
          component: resolve => require(['@/components/UserMan/MembersBuy'], resolve),
        },
        // 用户管理 分销商管理 基础设置
        {
          path: '/baseSet',
          name: 'baseSet',
          component: resolve => require(['@/components/UserMan/baseSet'], resolve),
        },
        // 用户管理 分销商管理 自定义设置
        {
          path: '/customSet',
          name: 'customSet',
          component: resolve => require(['@/components/UserMan/customSet'], resolve),
        },
        // 用户管理 分销商管理 粉象分销等级
        {
          path: '/fxDistribution',
          name: 'fxDistribution',
          component: resolve => require(['@/components/UserMan/fxDistribution'], resolve),
        },
        //用户管理 分销商管理 粉象返佣
        {
          path: '/fxCommission',
          name: 'fxCommission',
          component: resolve => require(['@/components/UserMan/fxCommission'], resolve),
        },
        // 用户管理 分销商管理 分销商等级
        {
          path: '/distributorLevel',
          name: 'distributorLevel',
          component: resolve => require(['@/components/UserMan/distributorLevel'], resolve),
        },
        // 用户管理 分销商管理 新增或编辑分销商等级
        {
          path: '/setDistributorLevel',
          name: 'setDistributorLevel',
          component: resolve => require(['@/components/UserMan/setDistributorLevel'], resolve),
        },
        // 用户管理 分销商管理 和平分销商等级
        {
          path: '/PdistributorLevel',
          name: 'PdistributorLevel',
          component: resolve => require(['@/components/UserMan/PdistributorLevel'], resolve),
        },
        // 用户管理 分销商管理 和平分销商
        {
          path: '/PeaceDistribution',
          name: 'PeaceDistribution',
          component: resolve => require(['@/components/UserMan/PeaceDistribution'], resolve),
        },
        // 用户管理 分销商管理 和平分销商
        {
          path: '/PeaceDistributionSet',
          name: 'PeaceDistributionSet',
          component: resolve => require(['@/components/UserMan/PeaceDistributionSet'], resolve),
        },
        // 用户管理 分销商管理 分销商
        {
          path: '/distributors',
          name: 'distributors',
          component: resolve => require(['@/components/UserMan/distributors'], resolve),
        },
        // 用户管理 分销商管理 分销提现
        {
          path: '/disWithdrawal',
          name: 'disWithdrawal',
          component: resolve => require(['@/components/UserMan/disWithdrawal'], resolve),
        },
        //用户管理 分销商管理 vip购买记录
        {
          path: '/buyRecords',
          name: 'buyRecords',
          component: resolve => require(['@/components/UserMan/buyRecords'], resolve),
        },
        //用户管理 分销商管理 vip购买分销
        {
          path: '/vipbuySales',
          name: 'vipbuySales',
          component: resolve => require(['@/components/UserMan/vipbuySales'], resolve),
        },
        // 用户管理 分销订单
        {
          path: '/distributionOrder',
          name: 'distributionOrder',
          component: resolve => require(['@/components/UserMan/distributionOrder'], resolve),
        },
        // 用户管理 推荐返利列表
        {
          path: '/RecommendRebate',
          name: 'RecommendRebate',
          component: resolve => require(['@/components/UserMan/RecommendRebate'], resolve),
        },
        
        // 用户管理 优惠券管理
        {
          path: '/usersCoupon',
          name: 'usersCoupon',
          component: resolve => require(['@/components/UserMan/usersCoupon'], resolve),
        },
        // 商品管理 素材管理
        {
          path: '/materialMan',
          name: 'materialMan',
          component: resolve => require(['@/components/CommodityMan/materialMan'], resolve),
        },
        // 商品管理 商品分类
        {
          path: '/goodsClassification',
          name: 'goodsClassification',
          component: resolve => require(['@/components/CommodityMan/goodsClassification'], resolve),
        },
        // 商品管理 添加商品分类
        {
          path: '/addGoodsClass',
          name: 'addGoodsClass',
          component: resolve => require(['@/components/CommodityMan/addGoodsClass'], resolve),
        },
        // 商品管理 规格模板
        {
          path: '/SpecificationTemplate',
          name: 'SpecificationTemplate',
          component: resolve => require(['@/components/CommodityMan/SpecificationTemplate'], resolve),
        },
        // 商品管理 快速购买
        {
          path: '/quickBuy',
          name: 'quickBuy',
          component: resolve => require(['@/components/CommodityMan/quickBuy'], resolve),
        },
        // 商品管理 推荐设置
        {
          path: '/RecSettings',
          name: 'RecSettings',
          component: resolve => require(['@/components/CommodityMan/RecSettings'], resolve),
        },
        // 商品管理 商品服务
        {
          path: '/goodsServices',
          name: 'goodsServices',
          component: resolve => require(['@/components/CommodityMan/goodsServices'], resolve),
        },
        // 商品管理 商品服务新增或修改
        {
          path: '/goodsServicesEdit',
          name: 'goodsServicesEdit',
          component: resolve => require(['@/components/CommodityMan/goodsServicesEdit'], resolve),
        },
        // 商品管理 商品列表
        {
          path: '/goodsList',
          name: 'goodsList',
          component: resolve => require(['@/components/CommodityMan/goodsList'], resolve),
        },
        // 商品管理 商品列表新增
        {
          path: '/goodsListEdit',
          name: 'goodsListEdit',
          component: resolve => require(['@/components/CommodityMan/goodsListEdit'], resolve),
        },
        // 商品管理 批量导入
        {
          path: '/bulkImport',
          name: 'bulkImport',
          component: resolve => require(['@/components/CommodityMan/bulkImport'], resolve),
        },

        // 商品管理 淘宝CSV
        {
          path: '/taoBaoCSV',
          name: 'taoBaoCSV',
          component: resolve => require(['@/components/CommodityMan/taoBaoCSV'], resolve),
        }, // 商品管理 供应商管理
        {
          path: '/supplierManage',
          name: 'supplierManage',
          component: resolve => require(['@/components/CommodityMan/supplierManage'], resolve),
        },
        // 商品管理 供应商新增或修改
        {
          path: '/supplierEdit',
          name: 'supplierEdit',
          component: resolve => require(['@/components/CommodityMan/supplierEdit'], resolve),
        },
        // 订单管理 商品列表新增
        {
          path: '/orderList',
          name: 'orderList',
          component: resolve => require(['@/components/orderMan/orderList'], resolve),
        },
        // 订单管理 商品详情
        {
          path: '/orderDetails',
          name: 'orderDetails',
          component: resolve => require(['@/components/orderMan/orderDetails'], resolve),
        },
        // 订单管理 售后订单
        {
          path: '/afterSalesOrder',
          name: 'afterSalesOrder',
          component: resolve => require(['@/components/orderMan/afterSalesOrder'], resolve),
        },
        //订单管理 推荐账单
        {
          path: '/RecommendBill',
          name: 'RecommendBill',
          component: resolve => require(['@/components/orderMan/RecommendBill'], resolve),
        },
        //订单管理 推荐账单-详情
        {
          path: '/RecomBillDetail',
          name: 'RecomBillDetail',
          component: resolve => require(['@/components/orderMan/RecomBillDetail'], resolve),
        },
        //成本管理
        {
          path: '/CostManagement',
          name: 'CostManagement',
          component:resolve => require(['@/components/orderMan/CostManagement'], resolve),
        },
         //出库管理
         {
          path: '/outboundManage',
          name: 'outboundManage',
          component:resolve => require(['@/components/orderMan/outboundManage'], resolve),
        },
        
        // 订单管理 售后订单详情
        {
          path: '/salesOrderDetails',
          name: 'salesOrderDetails',
          component: resolve => require(['@/components/orderMan/salesOrderDetails'], resolve),
        },
        // 订单管理 评价模板
        {
          path: '/evaluationTemplate',
          name: 'evaluationTemplate',
          component: resolve => require(['@/components/orderMan/evaluationTemplate'], resolve),
        },
        // 订单管理 评价管理
        {
          path: '/evaluationMan',
          name: 'evaluationMan',
          component: resolve => require(['@/components/orderMan/evaluationMan'], resolve),
        },
        // 订单管理 客户评价
        {
          path: '/customerEvaluation',
          name: 'customerEvaluation',
          component: resolve => require(['@/components/orderMan/customerEvaluation'], resolve),
        },
        // 订单管理 批量发货
        {
          path: '/BulkShipment',
          name: 'BulkShipment',
          component: resolve => require(['@/components/orderMan/BulkShipment'], resolve),
        },
        // 订单管理 批量发货
        {
          path: '/BulkShipment',
          name: 'BulkShipment',
          component: resolve => require(['@/components/orderMan/BulkShipment'], resolve),
        },
        // 订单管理 财务配置
        {
          path: '/financialAllocation',
          name: 'financialAllocation',
          component: resolve => require(['@/components/orderMan/financialAllocation'], resolve),
        },
        // 订单管理 损益核算
        {
          path: '/OrderProfitLossList',
          name: 'OrderProfitLossList',
          component: resolve => require(['@/components/orderMan/OrderProfitLossList'], resolve),
        },
        //设置 基础设置
        {
          path: '/basicSetUp',
          name: 'basicSetUp',
          component: resolve => require(['@/components/setup/basicSetUp'], resolve),
        },
        // 物流设置 规则设置
        {
          path: '/ruleSetup',
          name: 'ruleSetup',
          component: resolve => require(['@/components/setup/ruleSetup'], resolve),
        },
        //店铺管理 轮播图
        {
          path: '/ShufflingFigure',
          name: 'ShufflingFigure',
          component: resolve => require(['@/components/StoreDesign/ShufflingFigure'], resolve),
        },
        //店铺管理 导航图标
        {
          path: '/navigationIcon',
          name: 'navigationIcon',
          component: resolve => require(['@/components/StoreDesign/navigationIcon'], resolve),
        },
        // 物流设置 新增运费规则
        {
          path: '/addFreightRule',
          name: 'addFreightRule',
          component: resolve => require(['@/components/setup/addFreightRule'], resolve),
        },
        //物流设置 新增包邮规则
        {
          path: '/addFreeshipping',
          name: 'addFreeshipping',
          component: resolve => require(['@/components/setup/addFreeshipping'], resolve),
        },
        //店铺管理 导航图标
        {
          path: '/navigationIcon',
          name: 'navigationIcon',
          component: resolve => require(['@/components/StoreDesign/navigationIcon'], resolve),
        },
        //店铺管理 商城风格
        {
          path: '/storeStyle',
          name: 'storeStyle',
          component: resolve => require(['@/components/StoreDesign/storeStyle'], resolve),
        },
        //店铺管理 图片魔方
        {
          path: '/imgCube',
          name: 'imgCube',
          component: resolve => require(['@/components/StoreDesign/imgCube'], resolve),
        },
        //店铺管理 标签栏
        {
          path: '/labelBar',
          name: 'labelBar',
          component: resolve => require(['@/components/StoreDesign/labelBar'], resolve),
        },
        //店铺设计 首页布局
        {
          path: '/HomePageLayout',
          name: 'HomePageLayout',
          component: resolve => require(['@/components/StoreDesign/HomePageLayout'], resolve),
        },
        //店铺管理 小程序页面
        {
          path: '/minipage',
          name: 'minipage',
          component: resolve => require(['@/components/StoreDesign/minipage'], resolve),
        },
        //店铺管理 内容管理 文章
        {
          path: '/Article',
          name: 'Article',
          component: resolve => require(['@/components/StoreDesign/Article'], resolve),
        },
        //店铺管理 内容管理 专题分类
        {
          path: '/ProjectClassific',
          name: 'ProjectClassific',
          component: resolve => require(['@/components/StoreDesign/ProjectClassific'], resolve),
        },
        //店铺管理 内容管理 专题
        {
          path: '/special',
          name: 'special',
          component: resolve => require(['@/components/StoreDesign/special'], resolve),
        },
        //店铺管理 内容管理 视频管理
        {
          path: '/videoManage',
          name: 'videoManage',
          component: resolve => require(['@/components/StoreDesign/videoManage'], resolve),
        },
        //店铺管理 内容管理 门店管理
        {
          path: '/storesManage',
          name: 'storesManage',
          component: resolve => require(['@/components/StoreDesign/storesManage'], resolve),
        },
        //店铺管理 内容管理 直播管理
        {
          path: '/liveManage',
          name: 'liveManage',
          component: resolve => require(['@/components/StoreDesign/liveManage'], resolve),
        },
        //店铺管理 员工管理 基础设置
        {
          path: '/Infrastructure',
          name: 'Infrastructure',
          component: resolve => require(['@/components/StoreDesign/Infrastructure'], resolve),
        },
        //店铺管理 员工管理 角色列表
        {
          path: '/roleList',
          name: 'roleList',
          component: resolve => require(['@/components/StoreDesign/roleList'], resolve),
        },
        //店铺管理 员工管理 员工列表
        {
          path: '/EmployeesList',
          name: 'EmployeesList',
          component: resolve => require(['@/components/StoreDesign/EmployeesList'], resolve),
        },
        //店铺管理 小程序页面标题
        {
          path: '/minititle',
          name: 'minititle',
          component: resolve => require(['@/components/StoreDesign/minititle'], resolve),
        }, //店铺管理 版权设置
        {
          path: '/copyrightset',
          name: 'copyrightset',
          component: resolve => require(['@/components/StoreDesign/copyrightset'], resolve),
        },
        //店铺管理 用户中心
        {
          path: '/userCenter',
          name: 'userCenter',
          component: resolve => require(['@/components/StoreDesign/userCenter'], resolve),
        },
        //店铺管理 自定义海报
        {
          path: '/customPoster',
          name: 'customPoster',
          component: resolve => require(['@/components/StoreDesign/customPoster'], resolve),
        },
        //营销中心 插件中心
        {
          path: '/pluginCenter',
          name: 'pluginCenter',
          component: resolve => require(['@/components/sallCenter/pluginCenter'], resolve),
        },
        //物流设置 退货地址列表
        {
          path: '/returnAddressList',
          name: 'returnAddressList',
          component: resolve => require(['@/components/setup/returnAddressList'], resolve),
        },
        //物流设置 新增退货地址
        {
          path: '/addAddress',
          name: 'addAddress',
          component: resolve => require(['@/components/setup/addAddress'], resolve),
        },
        //物流设置 区域购买
        {
          path: '/regionBuy',
          name: 'regionBuy',
          component: resolve => require(['@/components/setup/regionBuy'], resolve),
        },
        //物流设置 电子面单
        {
          path: '/electronFaceSheet',
          name: 'electronFaceSheet',
          component: resolve => require(['@/components/setup/electronFaceSheet'], resolve),
        },
        //物流设置 新增电子面单
        {
          path: '/addElectronFaceSheet',
          name: 'addElectronFaceSheet',
          component: resolve => require(['@/components/setup/addElectronFaceSheet'], resolve),
        },
        //物流设置 新包邮规则
        {
          path: '/mailRules',
          name: 'mailRules',
          component: resolve => require(['@/components/setup/mailRules'], resolve),
        },
           //物流设置 新包邮规则修改/新增
        {
          path: '/mailRulesSet',
          name: 'mailRulesSet',
          component: resolve => require(['@/components/setup/mailRulesSet'], resolve),
        },
        
        //设置 上传设置
        {
          path: '/uploadSettings',
          name: 'uploadSettings',
          component: resolve => require(['@/components/setup/uploadSettings'], resolve),
        },
        //数据统计 发放统计
        {
          path: '/grantStatistics',
          name: 'grantStatistics',
          component: resolve => require(['@/components/statistics/grantStatistics'], resolve),
        },

        //数据统计 分销排行
        {
          path: '/retailRanking',
          name: 'retailRanking',
          component: resolve => require(['@/components/statistics/retailRanking'], resolve),
        },
        //数据统计 积分收支
        {
          path: '/integralBudget',
          name: 'integralBudget',
          component: resolve => require(['@/components/statistics/integralBudget'], resolve),
        },
        //营销中心 余额收支
        {
          path: '/balanceBudget',
          name: 'balanceBudget',
          component: resolve => require(['@/components/sallCenter/balanceBudget'], resolve),
        },
        //数据统计 销售统计
        {
          path: '/salesStatistics',
          name: 'salesStatistics',
          component: resolve => require(['@/components/statistics/salesStatistics'], resolve),
        },
        //营销中心 充值管理
        {
          path: '/rechargeManage',
          name: 'rechargeManage',
          component: resolve => require(['@/components/sallCenter/rechargeManage'], resolve),
        },
        //营销中心 新增充值方案
        {
          path: '/addRechargeScheme',
          name: 'addRechargeScheme',
          component: resolve => require(['@/components/sallCenter/addRechargeScheme'], resolve),
        },
        //营销中心 充值设置
        {
          path: '/rechargeSet',
          name: 'rechargeSet',
          component: resolve => require(['@/components/sallCenter/rechargeSet'], resolve),
        },
        //营销中心 积分设置
        {
          path: '/integralSetting',
          name: 'integralSetting',
          component: resolve => require(['@/components/sallCenter/integralSetting'], resolve),
        },
        //营销中心 积分记录
        {
          path: '/IntegralRecord',
          name: 'IntegralRecord',
          component: resolve => require(['@/components/sallCenter/IntegralRecord'], resolve),
        },
        //营销中心 卡券列表
        {
          path: '/cardTicketList',
          name: 'cardTicketList',
          component: resolve => require(['@/components/sallCenter/cardTicketList'], resolve),
        },
        //营销中心 优惠券管理
        {
          path: '/couponManage',
          name: 'couponManage',
          component: resolve => require(['@/components/sallCenter/couponManage'], resolve),
        },
        //营销中心 自动发放
        {
          path: '/autorelease',
          name: 'autorelease',
          component: resolve => require(['@/components/sallCenter/autorelease'], resolve),
        },
        //营销中心 新增优惠券
        {
          path: '/addCoupon',
          name: 'addCoupon',
          component: resolve => require(['@/components/sallCenter/addCoupon'], resolve),
        },
        //营销中心 新增卡券
        {
          path: '/addCardTicket',
          name: 'addCardTicket',
          component: resolve => require(['@/components/sallCenter/addCardTicket'], resolve),
        },
        //营销中心 优惠券=》发放优惠券
        {
          path: '/grantCouPon',
          name: 'grantCouPon',
          component: resolve => require(['@/components/sallCenter/grantCouPon'], resolve),
        },
        //营销中心 自动发放优惠券
        {
          path: '/addAutoreleaseCoupon',
          name: 'addAutoreleaseCoupon',
          component: resolve => require(['@/components/sallCenter/addAutoreleaseCoupon'], resolve),
        },

      ]
    },
    {
      path: '/pintuanMain',
      name: 'pintuanMain',
      component: resolve => require(['@/components/pintuanMain'], resolve),
      children: [
        //拼团 拼团设置
        {
          path: '/pintuanSet',
          name: 'pintuanSet',
          component: resolve => require(['@/components/pintuan/pintuanSet'], resolve),
        },
        //拼团 消息通知
        {
          path: '/pintuanMsg',
          name: 'pintuanMsg',
          component: resolve => require(['@/components/pintuan/pintuanMsg'], resolve),
        },
        //拼团 拼团活动-列表
        {
          path: '/pintuanList',
          name: 'pintuanList',
          component: resolve => require(['@/components/pintuan/pintuanList'], resolve),
        },
        //拼团 拼团活动
        {
          path: '/pintuanActive',
          name: 'pintuanActive',
          component: resolve => require(['@/components/pintuan/pintuanActive'], resolve),
        }
      ]
    }

  ]
})
