import { HttpResponse } from '../@types'
import request from './request'

class HotelService {
  
    /**
     * 查詢城市信息
     * @param params 
     * @returns 
     */
  static async GetDestination(params: any): Promise<HttpResponse> {
    return request('dict_post_Destination_GetChildList', params)
  }
  
  /**
   * 查詢酒店信息
   * @param name 酒店名稱，支持空格分割
   * @param province 省編號
   * @param city 城市編號
   * @returns 
   */
  static async GetHotels(name:string, province: number, city: number): Promise<HttpResponse> {
    let params = {
      pageIndex: 1,
      pageSize: 1000,
      Name: name,
      QCountry: 651,
      QProvince: province,
      QCity: city,
      Status: '0',
      HotelPirceType: '-1',
      HotelType: '-1',
      QDistrict: '',
      total: 0,
      currentPage: 1,
      ID: 0,
      UpdateBy: 0,
      ProductType: 1
    }
    return request('hotel_post_GetPageList', params)
  }
}

export default HotelService
