/*
 * This file runs in a Node context (it's NOT transpiled by Babel), so use only
 * the ES6 features that are supported by your Node version. https://node.green/
 */

// Configuration for your app
// https://v2.quasar.dev/quasar-cli/quasar-conf-js

/* eslint-env node */
/* eslint-disable @typescript-eslint/no-var-requires */
const { configure } = require('quasar/wrappers')
const path = require('path')

module.exports = configure(function (ctx) {
  return {
    // https://v2.quasar.dev/quasar-cli/supporting-ts
    // supportTS: {
    //   tsCheckerConfig: {
    //     eslint: {
    //       enabled: true,
    //       files: './src/**/*.{ts,tsx,js,jsx,vue}'
    //     }
    //   }
    // },

    // https://v2.quasar.dev/quasar-cli/prefetch-feature
    // preFetch: true,

    // app boot file (/src/boot)
    // --> boot files are part of "main.js"
    // https://v2.quasar.dev/quasar-cli/boot-files
    boot: ['i18n', 'axios', 'dict', 'permission', 'globalcmp'],

    // https://v2.quasar.dev/quasar-cli/quasar-conf-js#Property%3A-css
    css: ['app.scss'],

    // https://github.com/quasarframework/quasar/tree/dev/extras
    extras: [
      // 'ionicons-v4',
      'mdi-v5',
      // 'fontawesome-v5',
      // 'eva-icons',
      // 'themify',
      // 'line-awesome',
      // 'roboto-font-latin-ext', // this or either 'roboto-font', NEVER both!

      'roboto-font', // optional, you are not bound to it
      'material-icons' // optional, you are not bound to it
    ],

    // Full list of options: https://v2.quasar.dev/quasar-cli/quasar-conf-js#Property%3A-build
    build: {
      vueRouterMode: 'history', // available values: 'hash', 'history'
      target: {
        browser: ['es2019', 'edge88', 'firefox78', 'chrome87', 'safari13.1'],
        node: 'node16'
      },
      // transpile: false,

      // Add dependencies for transpiling with Babel (Array of string/regex)
      // (from node_modules, which are by default not transpiled).
      // Applies only if "transpile" is set to true.
      // transpileDependencies: [],
      publicPath: ctx.dev ? '/' : './',
      env: ctx.dev
        ? {
          BASE_APP_API: 'http://192.168.5.46/api/common/post',
          JAVA_URL_API: 'http://efficient.oytour.com',
          VERSION:require('./package.json').version,

        }
        : {
          BASE_APP_API:"http://reborn.oytour.com/api/common/post",//和平使用
          JAVA_URL_API: 'http://efficient.oytour.com',
          VERSION:require('./package.json').version
        },

      // extendWebpack(cfg, { isServer, isClient }) {
      //   cfg.resolve.alias = {
      //     ...cfg.resolve.alias,
      //     '@': path.resolve(__dirname, './src')
      //   }
      // },

      vitePlugins: [
        [
          '@intlify/vite-plugin-vue-i18n',
          {
            // if you want to use Vue I18n Legacy API, you need to set `compositionOnly: false`
            compositionOnly: false,
            // you need to set i18n resource including paths !
            include: path.resolve(__dirname, './src/i18n/**')
          }
        ]
      ],
      // alias:[{
      //   '@': path.resolve(__dirname, './src')
      // }],
      // rtl: true, // https://v2.quasar.dev/options/rtl-support
      // preloadChunks: true,
      // showProgress: false,
      // gzip: true,
      // analyze: true,

      // Options below are automatically set depending on the env, set them if you want to override
      // extractCSS: false,

      // https://v2.quasar.dev/quasar-cli/handling-webpack
      // "chain" is a webpack-chain object https://github.com/neutrinojs/webpack-chain
      // chainWebpack(/* chain */) {
      //   //
      // }
    },

    // Full list of options: https://v2.quasar.dev/quasar-cli/quasar-conf-js#Property%3A-devServer
    devServer: {
      https: false,
      port: 8080,
      open: true, // opens browser window automatically
      proxy: {
        '/getCountry': {
          target: 'https://api.map.baidu.com',
          changeOrigin: true,
          rewrite: (path) => path.replace(/^\/getCountry/, '')
        }
      }
    },

    // https://v2.quasar.dev/quasar-cli/quasar-conf-js#Property%3A-framework
    framework: {
      config: {},
      lang: 'en-US',
      // iconSet: 'material-icons', // Quasar icon set
      // lang: 'en-US', // Quasar language pack

      // For special cases outside of where the auto-import strategy can have an impact
      // (like functional components as one of the examples),
      // you can manually specify Quasar components/directives to be available everywhere:
      //
      // components: [],
      directives: ['ClosePopup'],

      // Quasar plugins
      plugins: ['Loading','Notify', 'SessionStorage', 'Dialog', 'LoadingBar']
    },

    animations: 'all', // --- includes all animations
    // https://v2.quasar.dev/options/animations
    animations: ['bounceInLeft', 'bounceOutRight','fadeInLeft','fadeInRight','fadeInDown','fadeInUp'],

    // https://v2.quasar.dev/quasar-cli/developing-ssr/configuring-ssr
    ssr: {
      pwa: false,

      // manualStoreHydration: true,
      // manualPostHydrationTrigger: true,

      prodPort: 3000, // The default port that the production server should use
      // (gets superseded if process.env.PORT is specified at runtime)

      maxAge: 1000 * 60 * 60 * 24 * 30,
      // Tell browser when a file from the server should expire from cache (in ms)

      chainWebpackWebserver(/* chain */) {
        //
      },

      middlewares: [
        ctx.prod ? 'compression' : '',
        'render' // keep this as last one
      ]
    },

    // https://v2.quasar.dev/quasar-cli/developing-pwa/configuring-pwa
    pwa: {
      // workboxPluginMode: 'generateSW', // 'GenerateSW' or 'InjectManifest'
      // workboxOptions: {}, // only for GenerateSW

      // // for the custom service worker ONLY (/src-pwa/custom-service-worker.[js|ts])
      // // if using workbox in InjectManifest mode
      // chainWebpackCustomSW(/* chain */) {
      //   //
      // },

      // manifest: {
      //   name: 'Ocss App',
      //   short_name: 'Ocss App',
      //   description: 'niuu bee',
      //   display: 'standalone',
      //   orientation: 'portrait',
      //   background_color: '#ffffff',
      //   theme_color: '#027be3',
      //   icons: [
      //     {
      //       src: 'icons/icon-128x128.png',
      //       sizes: '128x128',
      //       type: 'image/png'
      //     },
      //     {
      //       src: 'icons/icon-192x192.png',
      //       sizes: '192x192',
      //       type: 'image/png'
      //     },
      //     {
      //       src: 'icons/icon-256x256.png',
      //       sizes: '256x256',
      //       type: 'image/png'
      //     },
      //     {
      //       src: 'icons/icon-384x384.png',
      //       sizes: '384x384',
      //       type: 'image/png'
      //     },
      //     {
      //       src: 'icons/icon-512x512.png',
      //       sizes: '512x512',
      //       type: 'image/png'
      //     }
      //   ]
      // }
      workboxMode: 'generateSW', // or 'injectManifest'
      injectPwaMetaTags: true,
      swFilename: 'sw.js',
      manifestFilename: 'manifest.json',
      useCredentialsForManifestTag: false
      // useFilenameHashes: true,
      // extendGenerateSWOptions (cfg) {}
      // extendInjectManifestOptions (cfg) {},
      // extendManifestJson (json) {}
      // extendPWACustomSWConf (esbuildConf) {}
    },

    // Full list of options: https://v2.quasar.dev/quasar-cli-vite/developing-cordova-apps/configuring-cordova
    cordova: {
      // noIosLegacyBuildFlag: true, // uncomment only if you know what you are doing
    },

    // Full list of options: https://v2.quasar.dev/quasar-cli-vite/developing-capacitor-apps/configuring-capacitor
    capacitor: {
      hideSplashscreen: true
    },

    // Full list of options: https://v2.quasar.dev/quasar-cli-vite/developing-electron-apps/configuring-electron
    electron: {
      // extendElectronMainConf (esbuildConf)
      // extendElectronPreloadConf (esbuildConf)

      inspectPort: 5858,

      bundler: 'packager', // 'packager' or 'builder'

      packager: {
        // https://github.com/electron-userland/electron-packager/blob/master/docs/api.md#options
        // OS X / Mac App Store
        // appBundleId: '',
        // appCategoryType: '',
        // osxSign: '',
        // protocol: 'myapp://path',
        // Windows only
        // win32metadata: { ... }
      },

      builder: {
        // https://www.electron.build/configuration/configuration

        appId: 'bigwood'
      }
    },

    // Full list of options: https://v2.quasar.dev/quasar-cli-vite/developing-browser-extensions/configuring-bex
    bex: {
      contentScripts: ['PIC']

      // extendBexScriptsConf (esbuildConf) {}
      // extendBexManifestJson (json) {}
    }
  }
})
