import { HttpResponse } from '../@types'
import request from './request'

class HotelService {
  // 提交訂單
  static async SetCustomerOrder(param:any):Promise<HttpResponse>{
    return request('dict_post_SetCustomerOrder',param)
  }

    /**
     * 查詢城市信息
     * @param params
     * @returns
     */
  static async GetDestination(params: any): Promise<HttpResponse> {

    return request('dict_post_Destination_GetChildList', params)
  }


    /**
     * 查詢城市信息
     * @param params
     * @returns
     */
    static async GetCityExtList(params: any): Promise<HttpResponse> {

      return request('dict_get_Destination_GetCityExtList', params)
    }
  

  /**
   * 上次旅客名單
   * @param OrderId 訂單ID
   * @param GuestFile 文件路徑
   * @returns
   */
  static async SetGuestFile(OrderId:number,GuestFile:string): Promise<HttpResponse> {
    let GuestFileList = [GuestFile]
    return request('dict_post_SetOrderGuestFile', {OrderId,GuestFileList})
  }

  /**
   * 取消酒店订单
   * @param OrderId 订单编号
   * @returns
   */
  static async CancelHotelOrder(OrderId: number): Promise<HttpResponse> {

    return request('dict_post_CancelCustomerOrder', {OrderId})
  }

  /**
   * 獲取酒店訂單詳情
   * @param OrderId 订单编号
   * @returns
   */
   static async GetOrderDetail(OrderId: number): Promise<HttpResponse> {

    return request('dict_post_GetMyCustomerOrderInfo', {OrderId})
  }

  /**
   * 獲取酒店訂單詳情
   * @param hotelID 酒店編號
   * @returns
   */
   static async GetHotelDetail(hotelID: number): Promise<HttpResponse> {

    return request('hotel_post_GetAll', {hotelID})
  }

  static async GetHasStockHotelList(): Promise<HttpResponse> {
    let params={
      IsMoreThanZero: 0,
      QCountry: "651"
    }
    return request('hotel_post_GetHasStockHotelList', params)
  }

  /**
   * 酒店温馨提示
   * @param QStartDate 开始时间
   * @returns
   */
  static async GetHotelTips(QStartDate:string): Promise<HttpResponse> {
    let params= {
      "QStartDate":QStartDate,
      "QEndDate":"",
      "pageIndex":1,
      "pageSize":100,
      "currentPage":1,
      "total":0,
      "OpType":1
    }
    return request('hoteltip_get_GetPageList', params)
  }

  static async GetHotelList(param:any):Promise<HttpResponse>{
    param.MaxPrice=param.MaxPrice&&param.MaxPrice!=''?param.MaxPrice:0
    param.MinPrice=param.MinPrice&&param.MinPrice!=''?param.MinPrice:0
    return request('dict_post_HotelOffer_GetClientHotelStatics',param)
  }

  /**
   * 查詢當前登入用戶的酒店訂單信息
   * @param param
   * @returns
   */
  static async GetHotelOrders(param:any):Promise<HttpResponse>{
    return request('dict_post_GetMyCustomerOrderPageList',param)
  }

  /**
   * 查詢酒店信息
   * @param name 酒店名稱，支持空格分割
   * @param province 省編號
   * @param city 城市編號
   * @returns
   */
  static async GetHotels(name:string, province: number, city: number): Promise<HttpResponse> {
    let params = {
      pageIndex: 1,
      pageSize: 1000,
      Name: name,
      QCountry: 651,
      QProvince: province,
      QCity: city,
      Status: '0',
      HotelPirceType: '-1',
      HotelType: '-1',
      QDistrict: '',
      total: 0,
      currentPage: 1,
      ID: 0,
      UpdateBy: 0,
      ProductType: 1
    }
    return request('hotel_post_GetPageList', params)
  }
}

export default HotelService
