import { defineAsyncComponent } from 'vue'
import { RouteRecordRaw } from 'vue-router'
const MainLayout = defineAsyncComponent(()=>import('layouts/MainLayout.vue')) 
const Index = defineAsyncComponent(()=>import('pages/Index.vue'))
const HotelList = defineAsyncComponent(()=>import('pages/hotel/HotelList.vue'))
const HotelOrder = defineAsyncComponent(()=>import('pages/hotel/HotelOrder.vue') )
const ModifyHotelOrder = defineAsyncComponent(()=>import('pages/hotel/ModifyHotelOrder.vue'))
const personal = defineAsyncComponent(()=>import('pages/personal/personal.vue'))
const login = defineAsyncComponent(()=>import('pages/auth/login.vue'))
const regist = defineAsyncComponent(()=>import('pages/auth/regist.vue'))
const forget = defineAsyncComponent(()=>import('pages/auth/forget.vue'))
const newpassword = defineAsyncComponent(()=>import('pages/auth/newpassword.vue'))
const Error404 = defineAsyncComponent(()=>import('pages/Error404.vue'))
const routes: RouteRecordRaw[] = [
  {
    path: '/index',
    component: MainLayout,
    children: [
      { path: '', component: Index },
      { path: '/hotel', component: HotelList },
      { path: '/hotel/order/:orderId?', component: HotelOrder },
      { path: '/hotel/modify/:orderId', component: ModifyHotelOrder },
      { path: '/personal', component: personal }
    ]
  },
  {
    path: '/auth/login',
    component: login
  },
  {
    path: '/auth/regist',
    component: regist
  },
  {
    path: '/auth/forget',
    component: forget
  },
  {
    path: '/auth/newpassword/:code',
    component: newpassword
  },
  // Always leave this as last one,
  // but you can also remove it
  {
    path: '/:catchAll(.*)*',
    component: Error404
  }
]

export default routes
