// import { store } from 'quasar/wrappers'
import { InjectionKey } from 'vue'
import { Router } from 'vue-router'
import { createStore, Store as VuexStore, useStore as vuexUseStore } from 'vuex'

import createPersistedState from 'vuex-persistedstate'
import mutations from './mutations'
import modules from './modules'
import { StateType } from '../@types'

// provide typings for `this.$store`
declare module '@vue/runtime-core' {
  interface ComponentCustomProperties {
    $store: VuexStore<StateType>
  }
}

export const storeKey: InjectionKey<VuexStore<StateType>> = Symbol()

declare module 'vuex' {
  export interface Store<S> {
    readonly $router: Router
  }
}

const store: VuexStore<StateType> = createStore<StateType>({
  mutations,
  actions: {},
  modules: { ...modules },
  // enable strict mode (adds overhead!)
  // for dev mode and --debug builds only
  strict: !!process.env.DEBUGGING,
  plugins: [
    createPersistedState({
      paths: ['app', 'user']
    })
  ]
})

export default store
export function useStore() {
  return vuexUseStore(storeKey)
}

// const store: Store<StateType> = createStore({
//   strict: !!process.env.DEBUGGING,
//   mutations,
//   actions: {},
//   modules: { ...modules },

// })

// export default store
