import service from "./axios";
import Store from '../store'
import md5 from "md5-ts";
import { HttpResponse } from "../@types";
import * as OpenCC from 'opencc-js'
import { i18n } from '../boot/i18n'
import { DirtionmaryHelper } from '../config/dictionary'
let {locale} =i18n.global
let converterSW = OpenCC.Converter({ from: 'tw', to: 'cn' }) //转简
let datas: any  // 接收需要转简数据
let language = '' as any //语言
let currencyCode = 'JPY' //币种
const request = (cmd:string,msg:any,isTrans:boolean=true): Promise<HttpResponse>=>{
	datas = msg
	if(locale.value=='zhTW'){
		if(isTrans){
			let stringifyData = converterSW(JSON.stringify(msg))
			datas = JSON.parse(stringifyData)
		}
		language = 'zh_TW'
		// currencyCode = 'TWD'
	}else if(locale.value=='zhSW'){
		language = 'zh_CN'
		// currencyCode = 'CNY'
	}else if(locale.value=='koHG'){
		language = 'ko_KR'
		// currencyCode = 'KRW'
	}else if(locale.value=='jaRB'){
		// language = 'JP_Y'
		// currencyCode = 'JPY'
	}
	msg = datas??{}
	let token = ''
	let key = ""
	let groupId = ''
	let timestamp = (new Date()).valueOf();
	if (Store.state && Store.state.user?.token) {
		token = Store.state.user?.token?.access_token
		key = Store.state.user?.secretKey
	}
	if (Store.state && Store.state.user?.userDetail) {
		groupId = Store.state.user?.userDetail?.groupId
	}
	var encodeMsg = encodeURIComponent(JSON.stringify(msg)).toLowerCase();
	var md5Str = md5(`cmd=${cmd}&msg=${encodeMsg}&timestamp=${timestamp}&token=${token}&key=${key}`);
	var postData = {
		"groupId": groupId,
		"msg": msg,
		"cmd": cmd,
		"timestamp": timestamp,
		"token": token,
		"sign": md5Str,
		"locale": language,
		"currencyCode": currencyCode
	}
    return service.post('', postData)
}

export default request;
