
import { boot } from 'quasar/wrappers'
import { createI18n } from 'vue-i18n'
import { getDomainName } from '../utils/validate'
import messages from 'src/i18n'

export type MessageLanguages = keyof typeof messages;
// Type-define 'en-US' as the master schema for the resource
export type MessageSchema = typeof messages['enUS'];

// See https://vue-i18n.intlify.dev/guide/advanced/typescript.html#global-resource-schema-type-definition
/* eslint-disable @typescript-eslint/no-empty-interface */
declare module 'vue-i18n' {
  // define the locale messages schema
  export interface DefineLocaleMessage extends MessageSchema { }

  // define the datetime format schema
  export interface DefineDateTimeFormat { }

  // define the number format schema
  export interface DefineNumberFormat { }
}
let Language
if (getDomainName()) {
  Language = localStorage.getItem('lanuage') ?? 'zhTW'
} else {
  Language = localStorage.getItem('lanuage') ?? 'zhSW'
}
const i18n = createI18n({
  locale: Language,
  legacy: false,
  warnHtmlInMessage: false,
  warnHtmlMessage: false,
  globalInjection: true,
  messages
})
export default boot(({ app }) => {
  app.use(i18n)
})
export { i18n }
