import { ResultType } from '../../../@types/enumHelper'
import store from '../../../store'
import { DirtionmaryHelper } from '../../../config/dictionary'

const userGetter = {
  getUserToken() {
    const token = store.state.user.token
    return token.access_token ?? ResultType.Empty
  },
  getUserAllAuth() {
    const menuList: any[] = store.state.user.menuList
    return menuList.length > 0 ? menuList : ResultType.EmptyArray
  },
  getUser(){
    const userInfo=store.state.user.userDetail
    return userInfo
  }
}

type UserGetter = typeof userGetter
export { type UserGetter }
export default userGetter
