import { HttpResponse } from '../@types'
import request from './request'

//道旅酒店API
class DidaService {


  //道旅城市
  static async GetDidaCity(param: any): Promise<HttpResponse> {
    return request('dmc_post_GetDiDaCityBaseInfo', param, false)
  }

  //获取道旅国家
  static async GetDiDaCountry(): Promise<HttpResponse> {
    return request('dmc_post_GetDiDaCountryExtList', {}, false)
  }

  //获取道旅酒店类型
  static async GetDidaPropertyCategory(param: any): Promise<HttpResponse> {
    return request('dmc_post_GetDidaPropertyCategory', param, false)
  }

  //获取道旅餐食类型
  static async GetDidaMealType(param: any): Promise<HttpResponse> {
    return request('dmc_post_GetDidaMealType', param, false)
  }


  //道旅床型
  static async GetDidaBedType(param: any): Promise<HttpResponse> {
    return request('dmc_post_GetDidaBedTypeBaseInfo', param, false)
  }

  //道旅酒店详情
  static async GetHotelRoomsList(param: any): Promise<HttpResponse> {
    return request('dmc_post_GetDiDaPriceSearchList', param)
  }
  //道旅酒店详情
  static async GetHotelDetails(param: any): Promise<HttpResponse> {
    return request('dmc_post_GetDidaHotelDetails', param)
  }

  //道旅酒店下单确认
  static async GetDiDaPriceConfirm(param: any): Promise<HttpResponse> {
    return request('dmc_post_GetDiDaPriceConfirm', param)
  }

  //道旅酒店创建订单
  static async GetDiDaBookingConfirm(param: any): Promise<HttpResponse> {
    return request('dmc_post_GetDiDaBookingConfirm', param)
  }

  //散客订单取消确认
  static async GetDiDaBookingCancelConfirm(param: any): Promise<HttpResponse> {
    return request('dmc_post_GetDiDaBookingCancelConfirm', param)
  }

  //散客订单预取消
  static async GetDiDaBookingCancel(param: any): Promise<HttpResponse> {
    return request('dmc_post_GetDiDaBookingCancel', param)
  }

  //散客订单详情
  static async GetDiDaBookingSearchList(param: any): Promise<HttpResponse> {
    return request('dmc_post_GetDiDaBookingSearchList', param)
  }
  // 道旅酒店列表
  static async GetDidaHotelList(param: any): Promise<HttpResponse> {
    param.reviewRatingUpperLimits = param.reviewRatingUpperLimits && param.reviewRatingUpperLimits != '' ? param.reviewRatingUpperLimits : 0
    param.reviewRatingLowerLimits = param.reviewRatingLowerLimits && param.reviewRatingLowerLimits != '' ? param.reviewRatingLowerLimits : 0
    param.searchMaxRate = param.searchMaxRate && param.searchMaxRate != '' ? param.searchMaxRate : 0
    param.searchMinRate = param.searchMinRate && param.searchMinRate != '' ? param.searchMinRate : 0
    return request('dmc_post_GetDiDaLowPriceSearchList', param, false)
  }

  //道旅实施查询接口
  static async GetDidaHotelListV2(param: any): Promise<HttpResponse> {
    param.reviewRatingUpperLimits = param.reviewRatingUpperLimits && param.reviewRatingUpperLimits != '' ? param.reviewRatingUpperLimits : 0
    param.reviewRatingLowerLimits = param.reviewRatingLowerLimits && param.reviewRatingLowerLimits != '' ? param.reviewRatingLowerLimits : 0
    param.searchMaxRate = param.searchMaxRate && param.searchMaxRate != '' ? param.searchMaxRate : 0
    param.searchMinRate = param.searchMinRate && param.searchMinRate != '' ? param.searchMinRate : 0
    return request('dmc_post_GetDiDaLowPriceSearchList', param, false)
  }
}

export default DidaService
