import { RouteRecordRaw } from 'vue-router'

const routes: RouteRecordRaw[] = [
  {
    path: '/index',
    component: () => import('layouts/MainLayout.vue'),
    children: [
      { path: '', component: () => import('pages/Index.vue') },

      { path: '/hotel', component: () => import('pages/hotel/HotelList.vue') },//酒店
      { path: '/hotel/order/:orderId?', component: () => import('pages/hotel/HotelOrder.vue') },
      { path: '/hotel/modify/:orderId', component: () => import('pages/hotel/ModifyHotelOrder.vue') },
      { path: '/hotel/offer/:orderId', component: () => import('pages/hotel/ListOfQuotation.vue') },

      { path: '/personal', component: () => import('pages/personal/personal.vue') },

      { path: '/scattered', component: () => import('pages/scattered/HotelList.vue') },//散客
      { path: '/scattered/HotelDetails/:hotelId/:groupBookingFlg/:lowrateBySetCurrency', component: () => import('pages/scattered/hotelDetails.vue') },
      { path: '/scattered/HotelSure/:hotelId/:roomOptionCd', component: () => import('pages/scattered/HotelSure.vue') },
      { path: '/scattered/HotelOrder', component: () => import('pages/scattered/HotelOrder.vue') },

      { path: '/comingsoon', component: () => import('pages/ComingSoon.vue') },

      { path: '/ticket/list', component: () => import('pages/ticket/TicketList.vue') },//门票
      { path: '/ticket/preview/:ticketId/:Time', component: () => import('pages/ticket/TicketOrderPreview.vue') },
      { path: '/ticket/order', component: () => import('pages/ticket/TicketOrder.vue') },
      { path: '/ticket/preview/:ticketId/:Time', component: () => import('pages/ticket/TicketOrderPreview.vue') },
      { path: '/ticket/order/:orderId?', component: () => import('pages/ticket/TicketOrder.vue') },

      { path: '/vehicle/index', component: () => import('pages/CharteredBus/CharteredBusList.vue') },//车辆
      { path: '/vehicle/Preview/:ProductId/:Time/:orderId?', component: () => import('pages/CharteredBus/CharteredBusPreview.vue') },
      { path: '/vehicle/addEditVehicle/:Id?', component: () => import('pages/vehicle/addEditVehicle.vue') },
      { path: '/vehicle/order/:pages?', component: () => import('pages/vehicle/vehicleOrder.vue') },

      { path: '/scheduledTrip/index', component: () => import('pages/scheduledTrip/scheduledTripList.vue') },//预定行程
      { path: '/scheduledTrip/details/:id/:tcid', component: () => import('pages/scheduledTrip/detailsNew.vue') },
      
    ]
  },
  {
    path: '/auth/login',
    component: () => import('pages/auth/login.vue')
  },
  {
    path: '/auth/regist',
    component: () => import('pages/auth/regist.vue')
  },
  {
    path: '/auth/forget',
    component: () => import('pages/auth/forget.vue')
  },
  {
    path: '/auth/newpassword/:code',
    component: () => import('pages/auth/newpassword.vue')
  },
  // Always leave this as last one,
  // but you can also remove it
  {
    path: '/:catchAll(.*)*',
    component: () => import('pages/Error404.vue')
  }
]

export default routes
