/**
 * 验证工具类
 */

/* 合法uri*/
export function validateURL(textval: string) {
	const urlregex =
		/^(https?|ftp):\/\/([a-zA-Z0-9.-]+(:[a-zA-Z0-9.&%$-]+)*@)*((25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]?)(\.(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])){3}|([a-zA-Z0-9-]+\.)*[a-zA-Z0-9-]+\.(com|edu|gov|int|mil|net|org|biz|arpa|info|name|pro|aero|coop|museum|[a-zA-Z]{2}))(:[0-9]+)*(\/($|[a-zA-Z0-9.,?'\\+&%$#=~_-]+))*$/
	return urlregex.test(textval)
}

/* 小写字母*/
export function validateLowerCase(str: string) {
	const reg = /^[a-z]+$/
	return reg.test(str)
}

/* 大写字母*/
export function validateUpperCase(str: string) {
	const reg = /^[A-Z]+$/
	return reg.test(str)
}

/* 大小写字母*/
export function validatAlphabets(str: string) {
	const reg = /^[A-Za-z]+$/
	return reg.test(str)
}

/* 英文名*/
export function validatAlphabetsName(str: string) {
	const reg = /[a-zA-z]$/
	return reg.test(str)
}

export function isEmail(account: string): boolean {
	let serchfind: boolean;
	let regexp = new RegExp(/^(([^<>()\[\]\\.,;:\[email protected]"]+(\.[^<>()\[\]\\.,;:\[email protected]"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/);
	serchfind = regexp.test(account);
	return serchfind
}

export function isPhone(account: string): boolean {
	let serchfind: boolean;
	let regexp = new RegExp(/^((13|14|15|16|17|18|19)[0-9]{1}\d{8})$/);
	serchfind = regexp.test(account);
	return serchfind
}

/** 比对数组是否相同 */
export function compareArray(arrA: any[], arrB: any[]) {
	let isSame = true
	if (arrA.length !== arrB.length) {
		return false
	} else {
		arrA.some((el, idx) => {
			if (el !== arrB[idx]) {
				isSame = false
				return true
			}
		})
	}
	return isSame
}

/** 获取当前域名 localhost、192.168.10.xx、pic.oytour.com、sell.oytour.com、typic.oytour.com*/
export function getDomainName() {
	let domainNameUrl = window.location.hostname;
	if (domainNameUrl == 'localhost') {
		return 'pic.oytour'
	} else if (domainNameUrl.indexOf("192.168.10") > -1) {
		return "typic.oytour"
	}
	else if (domainNameUrl == "typic.oytour.com") {
		return "typic.oytour"
	}
	else if (domainNameUrl == 'pic.oytour.com') {
		return 'pic.oytour'
	} else if (domainNameUrl == 'sell.oytour.com') {
		return 'sell.oytour'
	}
}
