//import { message } from 'ant-design-vue';
import { ApiResult } from './../../../@types/enumHelper';
import UserService from '../../../api/user'
import { setStoreState } from '../../utils'
import Store from '../../../store'
import message from '../../../utils/message'
import { i18n } from '../../../boot/i18n'
import { DirtionmaryHelper } from '../../../config/dictionary'
//import router from '../../../router';
/**
 * @description 所有跟用户相关的内容
 * @return status 返回状态  err_code：1，逻辑正确，err_code：0，发生错误。
 */

const userActions = {
  // 刷新令牌
  refreshToken() {
    return UserService.refreshToken({
      // eslint-disable-next-line
      refresh_token: Store.state.user.token.refresh_token
    }).then(res => {
      // token过期时间
      const expireTime = res.data.expires_in * 1000 + new Date().getTime()
      setStoreState('user', 'token', { ...res.data, expireTime })
    })
  },

  // 获取用户信息
  getUserDetail() {
    return UserService.getUserDetail().then(res => {
      setStoreState('user', 'userDetail', res.data.data)
    })
  },

  setUserSignout() {
    //清理用户数据
    const loginUser = {}
    setStoreState('user', 'userDetail', loginUser)
    //清除token
    // const token = {}
    // const expireTime = 1 + new Date().getTime()
    setStoreState('user', 'token', {})
    //清除菜单权限
    setStoreState('user', 'menuList', [])

  },

  /**
   * 更新用戶資料
   * @param param0
   * @param params
   */
  setUserDetail({ }, params: any) {
    setStoreState('user', 'userDetail', params)
  },

  async userLogin({ }, params: { account: string; password: string, platform: number }): Promise<[boolean, string]> {
    const { t } = i18n.global
    let flag: [boolean, string] = [false, '']
    try {
      let param = {
        'account': params.account,
        'password': params.password,
        'platform': params.platform
      }
      let loginResult = await UserService.login(param)
      if (loginResult.data.resultCode == ApiResult.SUCCESS) {
        message.successMsg(t("login.success"))
        setStoreState('user', 'userDetail', loginResult.data.data)
        setStoreState('user', 'menuList', loginResult.data.data.MenuList)
        const token = {
          token_type: 'login_auth',
          access_token: loginResult.data.data.token
        }
        const expireTime = 72 * 60 * 60 * 1000 + new Date().getTime()
        setStoreState('user', 'token', { ...token, expireTime })
        flag[0] = true;

      } else {
        flag[1] = loginResult.data.message
        flag[0] = false
      }
    } catch (error) {
      flag[1] = error as string
      flag[0] = false
    }

    return flag;

  }
}

type UserActionsType = typeof userActions

export { type UserActionsType }
export default userActions
