import { RouteRecordRaw } from 'vue-router'

const routes: RouteRecordRaw[] = [
	{
		path: '/index',
		component: () => import('../layouts/MainLayout.vue'),
		children: [{ path: '', component: () => import('../pages/index.vue') }]
	},
	{
		path:'/auth/login',
		component: () => import('../pages/auth/login.vue')
	},
	{
		path:'/auth/regist',
		component: () => import('../pages/auth/regist.vue')
	},
	{
		path:'/auth/forget',
		component: () => import('../pages/auth/forget.vue')
	},
	// Always leave this as last one,
	// but you can also remove it
	{
		path: '/:catchAll(.*)*',
		component: () => import('../pages/Error404.vue')
	}
]

export default routes
