import { i18n } from '../boot/i18n'
interface HotelRate {
    id:number,
    name:string
}
interface HotelArea {
    name:string,
}

const {t} =i18n.global
const useHotel={
    // 酒店星级
    getHotelRate():HotelRate[]{
        let rates=[] as HotelRate[]
        rates.push({
            id:0,
            name:t('hotel.rates.normal')
        })
        rates.push({
            id:3,
            name:t('hotel.rates.low')
        })
        rates.push({
            id:4,
            name:t('hotel.rates.middle')
        })
        rates.push({
            id:5,
            name:t('hotel.rates.hight')
        })
        return rates
    },
    // 酒店住宿类型
    getAccommodationType():HotelRate[]{
        let rates=[] as HotelRate[]
        rates.push({
            id:1,
            name:t('v101.scattered.jiudian'),
        })
        rates.push({
            id:2,
            name:t('v101.scattered.rishilg'),
        })
        rates.push({
            id:3,
            name:t('v101.scattered.chuzubs'),
        })
        rates.push({
            id:4,
            name:t('v101.scattered.jiudiansw'),
        })
        rates.push({
            id:5,
            name:t('v101.scattered.jianyilgms'),
        })
        return rates
    },
    // 区域
    getHotelArea():HotelArea[]{
        let rates=[] as HotelArea[]
        for(let i=1;i<48;i++){
            rates.push({name:t(`v101.scattered.HotelArea${i}`)})
        }
        return rates
    },
    // 房类型
    getHotelRoom():HotelRate[]{
        let rates=[] as HotelRate[]
        for(let i=1;i<8;i++){
            rates.push({name:t(`v101.scattered.HotelRoom${i}`),id:i})
        }
        return rates
    },
    // 餐饮
    getHotelMeal():HotelRate[]{
        let rates=[] as HotelRate[]
        for(let i=1;i<5;i++){
            rates.push({name:t(`v101.scattered.HotelMeal${i}`),id:i})
        }
        return rates
    },
    // 理念
    getHotelConcept():HotelRate[]{
        let rates=[] as HotelRate[]
        for(let i=1;i<24;i++){
            rates.push({name:t(`v101.scattered.HotelConcept${i}`),id:i})
        }
        return rates
    },
    // 主题标签
    getHotelTheme():HotelArea[]{
        let rates=[] as HotelArea[]
        for(let i=1;i<5;i++){
            rates.push({name:t(`v101.scattered.zhutifea${i}`)})
        }
        return rates
    },
    // 网络链接
    getHotelInter():HotelArea[]{
        let rates=[] as HotelArea[]
        for(let i=1;i<7;i++){
            rates.push({name:t(`v101.scatteredDetails.InterTitle${i}`)})
        }
        return rates
    },
    // 洗漱用品是否免费
    getHotelSpring():HotelArea[]{
        let rates=[] as HotelArea[]
        for(let i=1;i<26;i++){
            rates.push({name:t(`v101.scatteredDetails.SpringText${i}`)})
        }
        return rates
    },
    // 设施与服务是否免费
    getHotelServices():HotelArea[]{
        let rates=[] as HotelArea[]
        for(let i=1;i<35;i++){
            rates.push({name:t(`v101.scatteredDetails.ServicesText${i}`)})
        }
        return rates
    },
    // 房间等级标准、豪华等
    getHotelRoomType():HotelArea[]{
        let rates=[] as HotelArea[]
        for(let i=1;i<35;i++){
            rates.push({name:t(`v101.scatteredDetails.RoomType${i}`)})
        }
        return rates
    },
    // 散客详情房型
    getHotelScatRoom():HotelArea[]{
        let rates=[] as HotelArea[]
        for(let i=1;i<10;i++){
            rates.push({name:t(`v101.scatteredDetails.HotelRoom${i}`)})
        }
        return rates
    },
    // 散客详情含餐
    getHotelScatMeal():HotelArea[]{
        let rates=[] as HotelArea[]
        for(let i=1;i<10;i++){
            rates.push({name:t(`v101.scatteredDetails.iscan${i}`)})
        }
        return rates
    },
    // 散客下单周一至周日
    getHotelWeek():HotelArea[]{
        let rates=[] as HotelArea[]
        for(let i=1;i<8;i++){
            rates.push({name:t(`v101.scatteredOrder.week${i}`)})
        }
        return rates
    },
}
export {useHotel, 
    type HotelRate,
    type HotelArea,
}