import { HttpResponse } from '../@types'
import request from './request'
class HotelService {

    /**
     * 查詢當前登入用戶的酒店訂單信息
     * @param param
     * @returns
     */
    static async vehicletripbus(param: any): Promise<HttpResponse> {
        return request('tripbus_SetTripBus', param)
    }
    /**
         * 查詢用车类型上面
         * @param param
         * @returns
         */
    static async TypeVehicle(param: any): Promise<HttpResponse> {
        return request('tripbus_GetBusTypeList', param)
    }
    /**
         * 查詢用车类型列表下面
         * @param param
         * @returns
         */
    static async listTypeVehicle(param: any): Promise<HttpResponse> {
        return request('tripbus_GetTripBusUseType', param)
    }
    /**
       * 查詢用车类预定列表
       * @param param
       * @returns
       */
    static async vehicleList(param: any): Promise<HttpResponse> {
        return request('tripbus_GetTripBusPage', param)
    }

    /**
       * 修改查詢用车类详情
       * @param param
       * @returns
       */
    static async VehicleDetails(Id: number): Promise<HttpResponse> {
        return request('tripbus_GetTripBusInfo', { Id })
    }
    /**
       * 取消用车
       * @param param
       * @returns
       */
    static async cancellation(Id: number, CancelRemark: any): Promise<HttpResponse> {
        return request('tripbus_CancelBusTrip', { Id, CancelRemark })
    }

    /**
      * 申请报价
      * @param param
      * @returns
      */
    static async applyBusPricelation(Id: number): Promise<HttpResponse> {
        return request('tripbus_ApplyTripBusOffer', { Id })
    }
    /**
     * 确认报价
     * @param param
     * @returns
     */
    static async sureBusPricelation(Id: number): Promise<HttpResponse> {
        return request('tripbus_SureBusTripOffer', { Id })
    }
}
export default HotelService