import { i18n } from '../boot/i18n'
interface Menu {
    name: string,
    url: string,
    id: number,
    parentId: number,
    icon?: string,
    childs?: Menu[]
}
const { t } = i18n.global
const useMenus = {
    getMenus(): Menu[] {
        let menus = [] as Menu[]
        menus.push({
            name: t('menu.hotel.first'),
            url: '',
            id: 1,
            parentId: 0,
            icon: 'Home/Building.svg',
            childs: [
                {
                    name: t('menu.hotel.second'),
                    url: '/hotel',
                    id: 2,
                    parentId: 1,
                },
                {
                    name: t('menu.hotel.three'),
                    url: '/hotel/order',
                    id: 3,
                    parentId: 1,
                }
            ]
        })
        menus.push({
            name: t('menu.scattered.first'),
            url: '',
            id: 13,
            parentId: 0,
            icon: 'scattered/The.svg',
            childs: [
                {
                    name: t('menu.scattered.second'),
                    url: '/scattered',
                    id: 14,
                    parentId: 13,
                },
                {
                    name: t('menu.scattered.three'),
                    url: '/scattered/HotelOrder',
                    id: 15,
                    parentId: 13,
                }
            ]
        })
        menus.push({
            name: t('menu.car.first'),
            url: '',
            id: 4,
            parentId: 0,
            icon: 'Electric/Iron.svg',
            childs: [
                {
                    name: t('menu.car.second'),
                    url: '/vehicle/index',
                    id: 5,
                    parentId: 4,
                },
                {
                    name: t('menu.car.three'),
                    url: '/comingsoon',
                    id: 6,
                    parentId: 4,
                }
            ]
        }),
            menus.push({
                name: t('menu.ticket.first'),
                url: '',
                id: 7,
                parentId: 0,
                icon: 'Shopping/Ticket.svg',
                childs: [
                    {
                        name: t('menu.ticket.second'),
                        url: '/ticket/list',
                        id: 8,
                        parentId: 7,
                    },
                    {
                        name: t('menu.ticket.three'),
                        url: '/ticket/order',
                        id: 9,
                        parentId: 7,
                    }
                ]
            })
        menus.push({
            name: t('menu.finance.first'),
            url: '',
            id: 10,
            parentId: 0,
            icon: 'Shopping/Money.svg',
            childs: [
                {
                    name: t('menu.finance.second'),
                    url: '/comingsoon',
                    id: 11,
                    parentId: 10,
                },
                {
                    name: t('menu.finance.three'),
                    url: '/comingsoon',
                    id: 12,
                    parentId: 10,
                }
            ]
        })
        return menus
    }
}
export { useMenus, type Menu }
