import service from "./axiosJava";
import md5 from "md5-ts";
import { HttpResponse } from "../@types";
import * as OpenCC from 'opencc-js'
import Store from '../store'
import { i18n } from '../boot/i18n'
let {locale} =i18n.global
let converterSW = OpenCC.Converter({ from: 'tw', to: 'cn' }) //转简
let datas: any  // 接收需要转简数据
let language = '' as any //语言
let currencyCode = '' as any //币种
const request = (cmd:string,msg:any): Promise<HttpResponse>=>{
	datas = msg
	if(locale.value=='zhTW'){
		// let stringifyData = converterSW(JSON.stringify(msg))
		// datas = JSON.parse(stringifyData)
		language = 'zh_TW'
		currencyCode = 'TWD'
	}else if(locale.value=='zhSW'){
		language = 'zh_CN'
		currencyCode = 'CNY'
	}else if(locale.value=='koHG'){
		language = 'ko_KR'
		currencyCode = 'KRW'
	}else if(locale.value=='jaRB'){
		// language = 'JP_Y'
		currencyCode = 'JPY'
	}
	msg = datas??{}
	let token = "";
	let key = "";
	let groupId = 0
	let timestamp = (new Date()).valueOf();
	if (Store.state.user?.token) {
		token = Store.state.user?.token?.access_token
		key = Store.state.user?.userDetail?.secretKey
	}
	if (Store.state.user?.userDetail) {
		groupId = Store.state.user?.userDetail?.groupId
	}
	var encodeMsg = encodeURIComponent(JSON.stringify(msg)).toLowerCase();
	var md5Str = md5(`msg=${encodeMsg}&timestamp=${timestamp}&token=${token}&key=${key}`);
	var postData = {
		"groupId": groupId,
		"msg": msg,
		"timestamp": timestamp,
		"token": token,
		"sign": md5Str,
	}
    return service.post(process.env.JAVA_URL_API+cmd, postData)
}

export default request;
