import service from "./axios";
import Store from '../store'
import md5 from "md5-ts";
import { HttpResponse } from "@/@types";
import * as OpenCC from 'opencc-js'
import { i18n } from '../boot/i18n'
let {locale} =i18n.global
let converterSW = OpenCC.Converter({ from: 'tw', to: 'cn' }) //转简
let datas: any  // 接收需要转简数据
const request = (cmd:string,msg:any): Promise<HttpResponse>=>{
	if(locale.value=='zhTW'){
		let stringifyData = converterSW(JSON.stringify(msg))
		datas = JSON.parse(stringifyData)
	}else{
		datas = msg
	}
	msg = datas??{}
	let token = "";
	let key = "";
	let timestamp = (new Date()).valueOf();
	if (localStorage.vuex && JSON.parse(localStorage.vuex).user?.token) {
		token = Store.state.user?.token?.access_token
		key = Store.state.user?.secretKey
	}
	var encodeMsg = encodeURIComponent(JSON.stringify(msg)).toLowerCase();
	var md5Str = md5(`cmd=${cmd}&msg=${encodeMsg}&timestamp=${timestamp}&token=${token}&key=${key}`);
	var postData = {
		"msg": msg,
		"cmd": cmd,
		"timestamp": timestamp,
		"token": token,
		"sign": md5Str,
		"languageId": 1
	}
    return service.post('', postData)
}

export default request;