import request from '../../utils/request'
/**
 * 选项配置
 */
export function getOptionList() {
  var array = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'];
  return array;
}

/**
 * 选择题选项配置【单选、多选】
 */
export function optionListConfig() {
  return [{
    Name: "A",
    Content: "",
    IsAnswer: false
  }, {
    Name: "B",
    Content: "",
    IsAnswer: false
  }, {
    Name: "C",
    Content: "",
    IsAnswer: false
  }, {
    Name: "D",
    Content: "",
    IsAnswer: false
  }];
}

/**
 * 创建问题
 */
export function CreateQuestion(questionKey) {
  var AnswerList = [];
  switch (questionKey) {
    //单选题
    case "single":
      AnswerList = optionListConfig();
      break;
      //多选题
    case "multiple":
      AnswerList = optionListConfig();
      break;
      //填空题
    case "fill-in":
      AnswerList.push({
        Content: ""
      })
      break;
      //判断题
    case "judge":
      AnswerList.push({
        Name: "A",
        Content: "对",
        IsAnswer: true
      }, {
        Name: "B",
        Content: "错",
        IsAnswer: false
      })
      break;
      //分录题
    case "entry-problem":
      AnswerList.push({
        Content: ""
      })
      break;
      //资料题
    case "data-question":
      AnswerList.push({
        Content: ""
      })
      break;
      //连线题
    case "matching":
      var array1 = [{
        Name: "1",
        Content: ""
      }];
      var array2 = [{
        Name: "A",
        Content: ""
      }];
      var array2 = [{
        Name: "1",
        Content: "A"
      }];
      AnswerList.push(array1);
      AnswerList.push(array2);
      AnswerList.push(array2);
      break;
      //排序题
    case "sorting-problem":
      var tempArray = [{
        Name: "A",
        Content: ""
      }, {
        Name: "B",
        Content: ""
      }, {
        Name: "C",
        Content: ""
      }, {
        Name: "D",
        Content: ""
      }];
      var array2 = [{
        Name: "A",
        Content: ""
      }, {
        Name: "A",
        Content: ""
      }, {
        Name: "A",
        Content: ""
      }, {
        Name: "A",
        Content: ""
      }];
      AnswerList.push(tempArray);
      AnswerList.push(array2);
      break;
      //完型天空
    case "cloze":
      var tempArray = optionListConfig();
      AnswerList.push(tempArray);
      break;
      //阅读理解
    case "reading-comprehensio":
      AnswerList.push({
        QuestionType: 1,
        QuestionKey: "single",
        QuestionName: "单选题",
        SubTitle: "", //题目内容
        SubAnwser: optionListConfig()
      });
      break;
      //听力题
    case "listening":
      AnswerList.push({
        QuestionType: 1,
        QuestionKey: "single",
        QuestionName: "单选题",
        SubTitle: "", //题目内容
        SubAnwser: optionListConfig()
      });
      break;
      //共用选择题
    case "sharing-choose":
      var tempArray = [{
        Name: "A",
        Content: ""
      }, {
        Name: "B",
        Content: ""
      }, {
        Name: "C",
        Content: ""
      }, {
        Name: "D",
        Content: ""
      }];
      var array2 = [{
        Name: "",
        Content: "",
      }, {
        Name: "",
        Content: "",
      }];
      AnswerList.push(tempArray);
      AnswerList.push(array2);
      break;
  }
  return AnswerList;
}
