const routes = [{
    path: "/",
    component: () =>
      import("pages/user/login.vue")
  },
  {
    path: "/login",
    component: () =>
      import("pages/user/login.vue")
  },
  {
    path: "/home",
    component: () =>
      import("layouts/MainLayout.vue"),
    children: [{
        path: "",
        component: () =>
          import("pages/Index.vue")
      },
      {
        path: "/school/manager",
        component: () =>
          import("pages/school/manager.vue")
      },
      {
        path: "/school/teacher",
        component: () =>
          import("pages/school/teacher.vue")
      },
      {
        path: "/school/assistant",
        component: () =>
          import("pages/school/assistant.vue")
      },
      {
        path: "/school/classroom", //教室管理
        component: () =>
          import("pages/school/classroom.vue")
      },
      {
        path: "/school/student", //学员管理
        component: () =>
          import("pages/school/student.vue")
      },
      {
        path: "/school/sysuser", //后台用户管理
        component: () =>
          import("pages/school/sysuser.vue")
      },
      {
        path: "/system/menu", //菜单管理
        component: () =>
          import("pages/system/menu.vue")
      },
      {
        path: "/system/menufunction", //菜单功能权限管理
        component: () =>
          import("pages/system/menufunction.vue")
      },
      {
        path: "/system/dept", //部门管理
        component: () =>
          import("pages/system/dept.vue")
      },
      {
        path: "/system/deptrelation", //部门关系图
        component: () =>
          import("pages/system/deptrelation.vue")
      },
      {
        path: "/system/post", //岗位管理
        component: () =>
          import("pages/system/post.vue")
      },
      {
        path: "/system/role", //角色管理
        component: () =>
          import("pages/system/role.vue")
      },
      {
        path: "/system/siteconfig", //站点配置
        component: () =>
          import("pages/system/siteconfig.vue")
      },
      {
        path: "/system/msgmanage", //短信管理
        component: () =>
          import("pages/system/msgmanage.vue")
      },
      {
        path: "/system/processSet", //流程配置
        component: () =>
          import("pages/system/processSet.vue")
      },
      {
        path: "/course/catagory", //课程分类
        component: () =>
          import("pages/course/catagory.vue")
      },
      {
        path: "/course/course", //课程管理
        component: () =>
          import("pages/course/course.vue")
      },
      {
        path: "/course/classManage", //班级管理
        component: () =>
          import("pages/course/classManage.vue")
      },
      {
        path: "/course/baseSet", //基础设置
        component: () =>
          import("pages/course/baseSet.vue")
      },
      {
        path: "/course/paymentDetail", //收支明细
        component: () =>
          import("pages/course/paymentDetail.vue")
      },
      {
        path: "/course/classorder", //班级订单
        component: () =>
          import("pages/course/classorder.vue")
      },

      {
        path: "/course/socialclass", //教学奖励-社会班设置
        component: () =>
          import("pages/course/socialclass.vue")
      },
      {
        path: "/course/studentClass", //教学奖励-学生班设置
        component: () =>
          import("pages/course/studentClass.vue")
      },
      {
        path: "/course/teacherLesson", //教师备课列表
        component: () =>
          import("pages/course/teacherLesson.vue")
      },
      {
        path: "/course/lessonPreparation", //教师备课
        component: () =>
        import("pages/course/lessonPreparation.vue")
      },
      {
        path: "/course/prepareclassDetails", //教师备课 备课详情
        component: () =>
          import("pages/course/prepareclassDetails.vue")
      },
      {
        path: "/financial/PlatformAccount", //平台账户
        component: () =>
          import("pages/financial/PlatformAccount.vue")
      },
      {
        path: "/financial/CompanyAccount", //银行账户
        component: () =>
          import("pages/financial/CompanyAccount.vue")
      },
      {
        path: "/financial/TeamRevenueReport", //营收报表
        component: () =>
          import("pages/financial/TeamRevenueReport.vue")
      },
      {
        path: "/financial/institutionsManagement", //金融机构管理
        component: () =>
          import("pages/financial/institutionsManagement.vue")
      },
      {
        path: "/financial/currencyManagement", //币种管理
        component: () =>
          import("pages/financial/currencyManagement.vue")
      },
      {
        path: "/financial/AccountType", //账户类型
        component: () =>
          import("pages/financial/AccountType.vue")
      },
      {
        path: "/financial/AccountPageList", //关联账户
        component: () =>
          import("pages/financial/AccountPageList.vue")
      },
      {
        path: "/financial/CostType", //费用类型
        component: () =>
          import("pages/financial/CostType.vue")
      },
      {
        path: "/financial/paySetting", //支付配置管理
        component: () =>
          import("pages/financial/paySetting.vue")
      },
      {
        path: '/financial/HistoryRateQuery', //历史汇率
        component: () =>
          import("pages/financial/HistoryRateQuery.vue")
      },
      {
        path: "/financial/Maninfo", //未认款信息
        component: () =>
          import("pages/financial/Maninfo.vue")
      },
      {
        path: "/financial/Manfunds", //未认款管理
        component: () =>
          import("pages/financial/Manfunds.vue")
      },
      {
        path: "/financial/HuiChaImport", //汇差批量制单
        component: () =>
          import("pages/financial/HuiChaImport.vue")
      },
      {
        path: "/financial/CashAccount", //汇差批量制单
        component: () =>
          import("pages/financial/CashAccount.vue")
      },
      {
        path: "/financial/sellCommissionRules", //提成规则
        component: () =>
          import("pages/financial/sellCommissionRules.vue")
      },
      {
        path: "/financial/FProcessManagement", //流程管理、
        component: () =>
          import("pages/financial/FProcessManagement.vue")
      },
      {
        path: "/financial/addFinancialProcess", //新增修改等级
        component: () =>
          import("pages/financial/addFinancialProcess.vue")
      },
      {
        path: "/financial/accountingWork", //会计窗口
        component: () =>
          import("pages/financial/accountingWork.vue")
      },
      {
        path: "/financial/CashierWork", //出纳窗口
        component: () =>
          import("pages/financial/CashierWork.vue")
      },
      {
        path: "/financial/empBankAccount", //常用付款对象
        component: () =>
          import("pages/financial/empBankAccount.vue")
      },
      {
        path: "/financial/accDetail/CashAccDetail", //现金账户明细
        component: () =>
          import("pages/financial/accDetail/CashAccDetail.vue")
      },
      {
        path: "/financial/accDetail/CompanyAccDetail", //银行账户明细
        component: () =>
          import("pages/financial/accDetail/CompanyAccDetail.vue")
      },
      {
        path: "/financial/accDetail/PlatformAccDetail", //平台账户明细
        component: () =>
          import("pages/financial/accDetail/PlatformAccDetail.vue")
      },
      {
        path: "/financial/accDetail/TransferReport", //银行日报表
        component: () =>
          import("pages/financial/accDetail/TransferReport.vue")
      },
      {
        path: "/financial/accDetail/CashReport", //现金日报表
        component: () =>
          import("pages/financial/accDetail/CashReport.vue")
      }, {
        path: "/financial/accDetail/CashReport", //现金日报表
        component: () =>
          import("pages/financial/accDetail/CashReport.vue")
      },
      {
        path: "/financial/financalDocument/ChoiceAddFinancialDocuments",
        component: () =>
          import("pages/financial/financalDocument/ChoiceAddFinancialDocuments.vue")
      },
      {
        path: "/financial/financalDocument/addReceivablesDocuments",
        component: () =>
          import("pages/financial/financalDocument/addReceivablesDocuments.vue")
      },
      {
        path: "/financial/financalDocument/invoicesManager", //发票管理
        component: () =>
          import("pages/financial/financalDocument/invoicesManager.vue")
      },
      {
        path: "/financial/financalDocument/refundQuery", //发票管理
        component: () =>
          import("pages/financial/financalDocument/refundQuery.vue")
      },
      {
        path: "/financial/financalDocument/CapitalAllocation", //资金调拨
        component: () =>
          import("pages/financial/financalDocument/CapitalAllocation.vue")
      },
      {
        path: "/financial/financalDocument/addCapitalAllocation", //资金调拨 新增
        component: () =>
          import("pages/financial/financalDocument/addCapitalAllocation.vue")
      },
      {
        path: "/financial/financalDocument/RecPayQuery", //收支查询
        component: () =>
          import("pages/financial/financalDocument/RecPayQuery.vue")
      },
      {
        path: "/financial/financalDocument/FinancialDocuments", //我的财务单据
        component: () =>
          import("pages/financial/financalDocument/FinancialDocuments.vue")
      },
      {
        path: "/financial/financalDocument/WorkEntrustmentMy", //工作委托
        component: () =>
          import("pages/financial/financalDocument/WorkEntrustmentMy.vue")
      },
      {
        path: "/financial/financalDocument/CapitalAllocationDetail", //资金调拨单 详情
        component: () =>
          import("pages/financial/financalDocument/CapitalAllocationDetail.vue")
      },
      {
        path: "/financial/financalDocument/addFinancialDocuments", //新增财务单据
        component: () =>
          import("pages/financial/financalDocument/addFinancialDocuments.vue")
      },
      {
        path: "/financial/financalDocument/FinancialDocumentsDetail", //我的财务单据详情
        component: () =>
          import("pages/financial/financalDocument/FinancialDocumentsDetail.vue")
      },
      {
        path: "/financial/financalDocument/BasicDocuments", //财务 财务单据 审核标准单据
        component: () =>
          import("pages/financial/financalDocument/BasicDocuments.vue")
      },
      {
        path: "/administration/document", //行政公告
        component: () =>
          import("pages/administration/document.vue")
      },
      {
        path: "/administration/Approval", //行政审批
        component: () =>
          import("pages/administration/Approval.vue")
      },
      {
        path: "/administration/ApprovalProcess", //审批流程详情
        component: () =>
          import("pages/administration/ApprovalProcess.vue")
      },
      {
        path: "/administration/processDesign", //分条件审批
        component: () =>
          import("pages/administration/processDesign.vue")
      },
      {
        path: "/administration/updateProcessDesign", //分条件审批
        component: () =>
          import("pages/administration/updateProcessDesign.vue")
      },
      {
        path: "/administration/myApprovalList", //我的审批
        component: () =>
          import("pages/administration/myApprovalList.vue")
      },
      {
        path: "/administration/myApproval", //我的发起
        component: () =>
          import("pages/administration/myApproval.vue")
      }, {
        path: "/administration/forMyApproval", //我的审批
        component: () =>
          import("pages/administration/forMyApproval.vue")
      },
      {
        path: "/administration/ApprovalStatistical", //审批统计
        component: () =>
          import("pages/administration/ApprovalStatistical.vue")
      },
      {
        path: "/administration/sendToMeApproval", //抄送
        component: () =>
          import("pages/administration/sendToMeApproval.vue")
      },
      {
        path: "/administration/leaveApproval", //请假
        component: () =>
          import("pages/administration/leaveApproval.vue")
      },
      {
        path: "/administration/Attendance", //考勤管理
        component: () =>
          import("pages/administration/Attendance.vue")
      },
      {
        path: "/administration/AttendanceRules", //考勤设置
        component: () =>
          import("pages/administration/AttendanceRules.vue")
      },
      {
        path: "/administration/outWorkApproval", //外勤考勤
        component: () =>
          import("pages/administration/outWorkApproval.vue")
      },
      {
        path: "/sale/japaneseTrain", //日语培训列表
        component: () =>
          import("pages/sale/japaneseTrain.vue")
      },
      {
        path: "/sale/myOrder", //销售 我的订单
        component: () =>
          import("pages/sale/myOrder.vue")
      },
      {
        path: "/sale/studentList", //销售 学生名单
        component: () =>
          import("pages/sale/studentList.vue")
      },
      {
        path: "/course/classHourReward", //教学奖励 课时奖励
        component: () =>
          import("pages/course/classHourReward.vue")
      },
      {
        path: "/course/rewardDetailed", //教学奖励 奖励明细
        component: () =>
          import("pages/course/rewardDetailed.vue")
      },
      {
        path: "/course/achievements", //教学奖励 绩效列表
        component: () =>
          import("pages/course/achievements.vue")
      },
      {
        path: "/user/backbill", //退课单据
        component: () =>
          import("pages/user/backbill.vue")
      },
      {
        path: "/course/questionlist", //题库列表
        component: () =>
          import("pages/course/questionlist.vue")
      },
      {
        path: "/course/courseinfo",
        component: () => import("pages/course/courseinfo.vue"),
        children: [{
            path: "/course/teachplan", //教案管理
            component: () =>
              import("pages/course/teachplan.vue")
          },
          {
            path: "/course/chapter", //章节管理
            component: () =>
              import("pages/course/chapter.vue")
          },
          {
            path: "/course/question", //课程题库列表
            component: () =>
              import("pages/course/question.vue")
          },
          {
            path: "/course/coursejob", //作业管理
            component: () =>
              import("pages/course/coursejob.vue")
          },
        ]
      },

      {
        path: "/test", //API测试
        component: () =>
          import("pages/test.vue")
      },
    ]
  },
  // Always leave this as last one,
  // but you can also remove it
  {
    path: "/financial/financalDocument/PrintPage", //财务单据打印
    component: () =>
      import("pages/financial/financalDocument/PrintPage.vue")
  },
  {
    path: "/financial/financalDocument/PrintPageN", //财务凭证打印
    component: () =>
      import("pages/financial/financalDocument/PrintPageN.vue")
  },
  {
    path: "*",
    component: () =>
      import("pages/Error404.vue")
  }
];

export default routes;
