import request from '../../utils/request'
import {
  Loading
} from 'quasar'
/**
 * 获取富文本编辑器Font
 */
export function getFontConfig() {
  return {
    arial: 'Arial',
    arial_black: 'Arial Black',
    comic_sans: 'Comic Sans MS',
    courier_new: 'Courier New',
    impact: 'Impact',
    lucida_grande: 'Lucida Grande',
    times_new_roman: 'Times New Roman',
    verdana: 'Verdana'
  };
}

/**
 * 文件上传配置
 */
var uploadMsg = {
  //http://imgfile.oytour.com  http://192.168.1.214:8130
  //http://upload.oytour.com   http://192.168.1.214:8120
  imgDomain: "http://192.168.1.214:8130",
  uploadUrl: "http://192.168.1.214:8120",
}

/**
 * 自定义上传文件 
 */
export function UploadSelfFile(path, file, callback) {
  Loading.show({
    message: '正在上传文件,请稍后...'
  })
  var newPath = '/Upload/' + path + "/";
  let url = uploadMsg.uploadUrl + "/Upload?filePath=" + newPath;
//   if (isTrans && isTrans == 1) {
//     url += "&isTrans=1"
//   }
  let formData = new FormData()
  formData.append('myfile', file)
  let xhr = new XMLHttpRequest()
  xhr.onload = function () {
    var jsonObj = JSON.parse(xhr.responseText);
    if (jsonObj.StatusCode == 1 && callback) {
      var tempArray = [];
      if (jsonObj.OtherFile && jsonObj.OtherFile.length > 0) {
        jsonObj.OtherFile.forEach(item => {
          tempArray.push(uploadMsg.imgDomain + item);
        })
      }
      Loading.hide();
      var uploadResult = {
        resultCode: 1,
        FileName: file.name,
        FileUrl: uploadMsg.imgDomain + jsonObj.FilePath,
        VideoCoverImg: uploadMsg.imgDomain + jsonObj.VideoCoverImg,
        ExtFile: tempArray
      }
      callback(uploadResult);
    }
  }
  xhr.open('post', url, true)
  xhr.send(formData)
}

/**
 * 获取省市区
 */
export function queryAreaTree(data) {
  return request({
    url: '/Public/GetAreaTree',
    method: 'post',
    data
  })
}

/**
 * 获取省市区列表
 */
export function queryAreaList(data) {
  return request({
    url: '/Public/GetAreaList',
    method: 'post',
    data
  })
}

/**
 * 获取文件扩展名
 */
export function getFileExt(filename) {
  var index = filename.lastIndexOf(".");
  var suffix = filename.substr(index + 1);
  return suffix
}
