import request from '../../utils/request'

/**
 * 获取课程分页列表
 * @param {JSON参数} data
 */
export function queryClassPage(data) {
  return request({
    url: '/Class/GetClassPageList',
    method: 'post',
    data
  })
}


/**
 * 获取课程状态列表
 * @param {JSON参数} data
 */
export function queryClassStatusList() {
  return request({
    url: '/Class/GetClassStatusList',
    method: 'post',
    data: ""
  })
}

/**
 * 获取班级学员列表
 */
export function queryClassStudent(data) {
  return request({
    url: '/Class/GetClassStudent',
    method: 'post',
    data
  });
}

/**
 * 获取上课计划列表
 */
export function quertClassPlan(data) {
  return request({
    url: '/Class/GetClassPlan',
    method: 'post',
    data
  });
}

/**
 * 新增修改课程安排
 */
export function setClassPlan(data) {
  return request({
    url: '/Class/SetClassPlan',
    method: 'post',
    data
  });
}

/**
 * 删除课程安排
 */
export function RemoveClassPlan(data) {
  return request({
    url: '/Class/RemoveClassPlan',
    method: 'post',
    data
  });
}

/**
 * 学员退课
 */
export function StudentDropOut(data) {
  return request({
    url: '/Class/UpdateClassStudentDropOut',
    method: 'post',
    data
  });
}

/**
 * 获取学员下拉数据
 */
export function GetStudentList(data) {
  return request({
    url: '/class/GetStudentList',
    method: 'post',
    data
  });
}

/**
 * 邀请学员
 */
export function AddClassStudent(data) {
  return request({
    url: '/class/AddClassStudent',
    method: 'post',
    data
  });
}

/**
 * 获取签到列表数据
 */
export function GetClassPlanLogPageList(data) {
  return request({
    url: '/class/GetClassPlanLogPageList',
    method: 'post',
    data
  });
}

/**
 * 获取某一天计划
 */
export function GetDayClassPlan(data) {
  return request({
    url: '/class/GetDayClassPlan',
    method: 'post',
    data
  });
}

/**
 * 点击签到
 */
export function addClassCheck(data) {
  return request({
    url: '/class/AddClassCheck',
    method: 'post',
    data
  });
}

/**
 * 获取班级日志
 */
export function queryClassLogPageList(data) {
  return request({
    url: '/class/GetClassLogPageList',
    method: 'post',
    data
  });
}

/**
 * 教师课时奖励 分页列表
 */
export function getTeachingBonusPageList(data) {
  return request({
    url: '/TeachingRewards/GetTeachingBonusPageList',
    method: 'post',
    data
  });
}

/**
 * 教师奖励状态 枚举
 */
export function getBonusStateEnumList(data) {
  return request({
    url: '/TeachingRewards/GetBonusStateEnumList',
    method: 'post',
    data
  });
}
