import request from '../../utils/request'

/**
 * 获取题库类型列表
 * @param {JSON参数} data 
 */
export function queryQuestionTypeList(data) {
  return request({
    url: '/Question/GetQuestionTypeList',
    method: 'post',
    data
  })
}


/**
 * 获取题库分页列表
 * @param {JSON参数} data 
 */
export function queryQuestionPageList(data) {
  return request({
    url: '/Question/GetQuestionPageList',
    method: 'post',
    data
  })
}

/**
 * 添加修改题库
 * @param {JSON参数} data 
 */
export function saveQuestion(data) {
  return request({
    url: '/Question/SetQuestion',
    method: 'post',
    data
  })
}


/**
 * 根据编号获取问题详情
 * @param {JSON参数} data 
 */
export function queryQuestionInfo(data) {
  return request({
    url: '/Question/GetQuestion',
    method: 'post',
    data
  })
}

/**
 * 根据编号删除问题详情
 * @param {JSON参数} data 
 */
export function deleteQuestion(data) {
  return request({
    url: '/Question/RemoveQuestion',
    method: 'post',
    data
  })
}

/**
 * 修改问题排序
 * @param {JSON参数} data 
 */
export function setQuestionSort(data) {
  return request({
    url: '/Question/UpdateQuestionSort',
    method: 'post',
    data
  })
}

/**
 * 添加知识点
 * @param {JSON参数} data 
 */
export function addQuestionPoint(data) {
  return request({
    url: '/Question/SetQuestionPoint',
    method: 'post',
    data
  })
}


/**
 * 获取知识点分页列表
 * @param {JSON参数} data 
 */
export function queryPointPageList(data) {
  return request({
    url: '/Question/GetPointPageList',
    method: 'post',
    data
  })
}

/**
 * 根据编号删除知识点
 * @param {JSON参数} data 
 */
export function deleteQuestionPoint(data) {
  return request({
    url: '/Question/RemoveQuestionPoint',
    method: 'post',
    data
  })
}

/**
 * 获取问题难易程度列表
 * @param {JSON参数} data 
 */
export function queryDifficultyType() {
  return request({
    url: '/Question/GetDifficultyType',
    method: 'post',
    data: {}
  })
}

/**
 * 批量添加问题
 * @param {JSON参数} data 
 */
export function saveQuestionBeatch(data) {
  return request({
    url: '/Question/SetQuestionBeatch',
    method: 'post',
    data
  })
}

/**
 * 获取问题大类
 */
export function queryQuestionCategory() {
  return request({
    url: '/Question/GetQuestionCategory',
    method: 'post',
  })
}
