import request from '../../utils/request'

/**
 * 获取广告图分页列表
 * @param {JSON参数} data 
 */
export function getAdvertisingList(data) {
    return request({
        url: '/Advertising/GetAdvertisingList',
        method: 'post',
        data
    })
}

/**
 * 新增/修改广告
 * @param {JSON参数} data 
 */
export function SetAdvertising(data) {
    return request({
        url: '/Advertising/SetAdvertising',
        method: 'post',
        data
    })
}

/**
 * 删除广告图
 * @param {JSON参数} data 
 */
export function delAd(data) {
    return request({
        url: '/Advertising/DelAdvertising',
        method: 'post',
        data
    })
}

/**
 * 保存制作的广告图
 * @param {JSON参数} data 
 */
export function saveMakeAd(data) {
    return request({
        url: '/Advertising/Set',
        method: 'post',
        data
    })
}


/**
 * 获取我的广告图
 * @param {JSON参数} data 
 */
export function getMyAd(data) {
    return request({
        url: '/Advertising/GetPageList',
        method: 'post',
        data
    })
}

/**
 * 删除我的广告图
 * @param {JSON参数} data 
 */
export function delMyAd(data) {
    return request({
        url: '/Advertising/Remove',
        method: 'post',
        data
    })
}

/**
 * 我的广告图详情
 * @param {JSON参数} data 
 */
export function getMyAdDetail(data) {
    return request({
        url: '/Advertising/Get',
        method: 'post',
        data
    })
}