import request from '../../utils/request'

/**
 * 获取当日排课计划
 * @param {JSON参数} data 
 */
export function getUseClassRoomList(data) {
    return request({
        url: '/ClassRoom/GetUseClassRoomList',
        method: 'post',
        data
    })
}

/**
 * 获取学校以及教室导航
 * @param {JSON参数} data 
 */
export function getSchoolAndRoomNav(data) {
    return request({
        url: '/ClassRoom/GetSchoolAndRoomList',
        method: 'post',
        data
    })
}

/**
 * 获取教室使用记录
 * @param {JSON参数} data 
 */
export function getClassRoomTimeList(data) {
    return request({
        url: '/ClassRoom/GetNewClassRoomTimeList',
        method: 'post',
        data
    })
}

/**
 * 获取教室使用记录类型1详情
 * @param {JSON参数} data 
 */
export function getClassRoomLogDetail(data) {
    return request({
        url: '/ClassRoom/GetRoomUseLogDetails',
        method: 'post',
        data
    })
}

/**
 * 根据排课时间id获取详情
 * @param {JSON参数} data 
 */
export function getTimeDetail(data) {
    return request({
        url: '/ClassRoom/GetTimeDetaild',
        method: 'post',
        data
    })
}