import request from '../../utils/request'

/**
 * 学员约访分页列表
 * @param {JSON参数} data
 */
export function queryStudentAppointmentPage(data) {
  return request({
    url: '/CustomerStudent/GetStudentAppointmentPage',
    method: 'post',
    data
  })
}

/**
 * 添加修改约访
 * @param {JSON参数} data
 */
export function saveStudentAppointment(data) {
  return request({
    url: '/CustomerStudent/SetStudentAppointment',
    method: 'post',
    data
  })
}

/**
 * 添加修改约访反馈
 * @param {JSON参数} data
 */
export function saveStudentAppointmentFeedBack(data) {
  return request({
    url: '/CustomerStudent/SetStudentAppointmentFeedBack',
    method: 'post',
    data
  })
}



/**
 * 根据编号获取约访
 * @param {JSON参数} data
 */
export function queryStudentAppointment(data) {
  return request({
    url: '/CustomerStudent/GetStudentAppointment',
    method: 'post',
    data
  })
}

/**
 * 根据编号删除学员约访
 * @param {JSON参数} data
 */
export function deleteStudentAppointment(data) {
  return request({
    url: '/CustomerStudent/RemoveStudentAppointment',
    method: 'post',
    data
  })
}


/**
 * 学员跟进分页列表
 * @param {JSON参数} data
 */
export function queryStudentFollowPage(data) {
  return request({
    url: '/CustomerStudent/GetStudentFollowPage',
    method: 'post',
    data
  })
}

/**
 * 新增修改学员跟进
 * @param {JSON参数} data
 */
export function saveStudentFollow(data) {
  return request({
    url: '/CustomerStudent/SetStudentFollow',
    method: 'post',
    data
  })
}


/**
 * 根据编号获取跟进信息
 * @param {JSON参数} data
 */
export function queryStudentFollow(data) {
  return request({
    url: '/CustomerStudent/GetStudentFollow',
    method: 'post',
    data
  })
}

/**
 * 根据编号删除学员跟进信息
 * @param {JSON参数} data
 */
export function deleteStudentFollow(data) {
  return request({
    url: '/CustomerStudent/RemoveStudentFollow',
    method: 'post',
    data
  })
}

/**
 * 学员到访分页列表
 * @param {JSON参数} data
 */
export function queryStudentVisitPage(data) {
  return request({
    url: '/CustomerStudent/GetStudentVisitPage',
    method: 'post',
    data
  })
}

/**
 * 新增修改学员到访
 * @param {JSON参数} data
 */
export function saveStudentVisit(data) {
  return request({
    url: '/CustomerStudent/SetStudentVisit',
    method: 'post',
    data
  })
}

/**
 * 根据编号获取到访信息
 * @param {JSON参数} data
 */
export function queryStudentVisit(data) {
  return request({
    url: '/CustomerStudent/GetStudentVisit',
    method: 'post',
    data
  })
}

/**
 * 跟进编号删除学员到访信息
 * @param {JSON参数} data
 */
export function deleteStudentVisit(data) {
  return request({
    url: '/CustomerStudent/RemoveStudentVisit',
    method: 'post',
    data
  })
}

/**
 * 新增修改学员到访反馈信息
 * @param {JSON参数} data
 */
export function saveStudentVisitFeedback(data) {
  return request({
    url: '/CustomerStudent/SetStudentVisitFeedback',
    method: 'post',
    data
  })
}



/**
 * 获取学员日志分页列表
 * @param {JSON参数} data
 */
export function queryStudentLogPage(data) {
  return request({
    url: '/CustomerStudent/GetStudentLogPage',
    method: 'post',
    data
  })
}

/**
 * 获取学员订单分页列表
 * @param {JSON参数} data
 */
export function queryStuOrderPage(data) {
  return request({
    url: '/CustomerStudent/GetStuOrderPage',
    method: 'post',
    data
  })
}


/**
 * 获取学员合同分页列表
 * @param {JSON参数} data
 */
export function queryStuContractPage(data) {
  return request({
    url: '/CustomerStudent/GetStuContractPage',
    method: 'post',
    data
  })
}

/**
 * 转交学员
 * @param {JSON参数} data
 */
export function ForwardStudent(data) {
  return request({
    url: '/User/ForwardStudent',
    method: 'post',
    data
  })
}

/**
 * 设置客户状态
 * @param {JSON参数} data
 */
export function SetStuStage(data) {
  return request({
    url: '/User/SetStudentStage',
    method: 'post',
    data
  })
}
/**
 * 保存学员咨询信息
 * @param {JSON参数} data
 */
 export function setStudentConsultResults(data) {
  return request({
    url: '/User/SetStudentConsultResults',
    method: 'post',
    data
  })
}

/**
 * 获取跟进状态下拉
 * @param {JSON参数} data
 */
export function GetStudentAdvisorConfigList(data) {
  return request({
    url: '/User/GetStudentAdvisorConfigList',
    method: 'post',
    data
  })
}

/**
 * 保存跟进
 * @param {JSON参数} data
 */
export function SetStudentAdvisor(data) {
  return request({
    url: '/User/SetStudentAdvisor',
    method: 'post',
    data
  })
}

/**
 * 获取跟进列表
 * @param {JSON参数} data
 */
export function GetStudentAdvisorPage(data) {
  return request({
    url: '/User/GetStudentAdvisorPage',
    method: 'post',
    data
  })
}

/**
 * 获取上课记录
 * @param {JSON参数} data
 */
export function GetStuLearnChapterList(data) {
  return request({
    url: '/Scroll/GetStuLearnChapterList',
    method: 'post',
    data
  })
}