import request from '../../utils/request'
import request_zc from '../../utils/request_zc'

/**
 * 获取收支明细数据
 *
 */
export function GetClassBalanceSheet(data) {
  return request({
    url: '/Finance/GetClassBalanceSheet',
    method: 'post',
    data
  })
}
/**
 * 根据 班级ids 获取班级信息
 *
 */
export function getClassNameList(data) {
  return request({
    url: '/order/GetClassNameList',
    method: 'post',
    data
  })
}

/**
 * 根据 留学就业ids 获取留学就业信息
 *
 */
export function queryStudyNameList(data) {
  return request({
    url: '/order/GetStudyNameList',
    method: 'post',
    data
  })
}

/**
 *获取简易报表数据
 */
export function getEasyReportList(data) {
  return request({
    url: '/finance/GetEasyReportList',
    method: 'post',
    data
  })
}
// 财务单据 资产采购详情
export function getPropertyProcurementInfo(data) {
  return request_zc({
    url: '/property/GetPropertyProcurementInfo',
    method: 'post',
    data
  });
}
// 财务单据 耗材采购详情
export function getSuppliesProcurementInfo(data) {
  return request_zc({
    url: '/supplies/GetSuppliesProcurementInfo',
    method: 'post',
    data
  });
}
// 财务单据 教育出库详情
export function getStockOutPageList(data) {
  return request_zc({
    url: '/Warehouse/GetStockOutPageList',
    method: 'post',
    data
  });
}
// 财务流程 销售提成规则
export function getSellCommissionRuleList(data) {
  return request({
    url: '/SellCommission/GetSellCommissionRuleList',
    method: 'post',
    data
  });
}

// 财务流程 保存销售提成规则
export function setSellCommissionRule(data) {
  return request({
    url: '/SellCommission/SetSellCommissionRule',
    method: 'post',
    data
  });
}
// 财务工作台 获取提成周期列表
export function getSellCommissionPeriodsPageList(data) {
  return request({
    url: '/SellCommission/GetSellCommissionPeriodsPageList',
    method: 'post',
    data
  });
}
// 财务工作台 获取周期提成 用户统计列表
export function getSellCommissionUserList(data) {
  return request({
    url: '/SellCommission/GetSellCommissionUserList',
    method: 'post',
    data
  });
}
// 财务工作台 获取周期提成 用户统计列表
export function getSellCommissionUserDetailList(data) {
  return request({
    url: '/SellCommission/GetSellCommissionUserDetailList',
    method: 'post',
    data
  });
}
// 财务工作台 获取周期提成 用户统计列表
export function getSellCommissionForOrderList(data) {
  return request({
    url: '/SellCommission/GetSellCommissionForOrderList',
    method: 'post',
    data
  });
}

// 财务工作台 获取周期提成 创建提成
export function setSellCommissionInfo(data) {
  return request({
    url: '/SellCommission/SetSellCommissionInfo',
    method: 'post',
    data
  });
}

// 财务工作台 获取周期提成  提成统计
export function getSellCommissionStatistics(data) {
  return request({
    url: '/SellCommission/GetSellCommissionStatistics',
    method: 'post',
    data
  });
}

// 财务工作台 获取周期提成  周期列表下拉选择
export function getSellCommissionPeriodsList(data) {
  return request({
    url: '/SellCommission/GetSellCommissionPeriodsList',
    method: 'post',
    data
  });
}

// 财务报表 获取老师课耗统计
export function getTeacherConsumptionHoursStatistics(data) {
  return request({
    url: '/finance/GetTeacherConsumptionHoursStatistics',
    method: 'post',
    data
  });
}


// 财务报表 获取老师课时消费明细列表
export function getTeacherConsumptionHoursDetialPageList(data) {
  return request({
    url: '/finance/GetTeacherConsumptionHoursDetialPageList',
    method: 'post',
    data
  });
}

// 财务报表 学生课耗明细列表
export function getStudentConsumptionHoursDetialPageList(data) {
  return request({
    url: '/finance/GetStudentConsumptionHoursDetialPageList',
    method: 'post',
    data
  });
}

// 财务报表 销售业绩排名统计
export function getSaleAchievementsRankStatistics(data) {
  return request({
    url: '/finance/GetSaleAchievementsRankStatistics',
    method: 'post',
    data
  });
}

//  获取可发放提成的用户
export function getSellCommissionSendEmployeeList(data) {
  return request({
    url: '/SellCommission/GetSellCommissionSendEmployeeList',
    method: 'post',
    data
  });
}

//  设置用户已发
export function setSellCommissionSendEmployee(data) {
  return request({
    url: '/SellCommission/SetSellCommissionSendEmployee',
    method: 'post',
    data
  });
}


//  获取月度班级收支统计
export function getAllClassNowMonthStatistics(data) {
  return request({
    url: '/finance/GetAllClassNowMonthStatistics',
    method: 'post',
    data
  });
}

//  财务轧账月份列表
export function getFinanceMonthStatementPageList(data) {
  return request({
    url: '/finance/GetFinanceMonthStatementPageList',
    method: 'post',
    data
  });
}
//  财务轧账月份n 新增修改
export function setFinanceMonthStatementInfo(data) {
  return request({
    url: '/finance/SetFinanceMonthStatementInfo',
    method: 'post',
    data
  });
}

//  财务流程 获取活动配置
export function getActivityConfigInfo(data) {
  return request({
    url: '/Activity/GetActivityConfigInfo',
    method: 'post',
    data
  });
}

//  财务流程 新增/修改 活动配置
export function setActivityConfig(data) {
  return request({
    url: '/Activity/SetActivityConfig',
    method: 'post',
    data
  });
}

//  工作台 获取提成期数列表
export function getActivityCommissionPeriodsPageList(data) {
  return request({
    url: '/Activity/GetActivityCommissionPeriodsPageList',
    method: 'post',
    data
  });
}

//  工作台 获取提成明细列表
export function getActivityCommissionUserDetailList(data) {
  return request({
    url: '/Activity/GetActivityCommissionUserDetailList',
    method: 'post',
    data
  });
}

//  工作台 查询订单活动提成明细
export function getActivityCommissionForOrderList(data) {
  return request({
    url: '/Activity/GetActivityCommissionForOrderList',
    method: 'post',
    data
  });
}


//  工作台 查询订单活动提成明细
export function getActivityCommissionUserList(data) {
  return request({
    url: '/Activity/GetActivityCommissionUserList',
    method: 'post',
    data
  });
}

//  活动获取可发放提成的用户
export function getActivityCommissionSendEmployeeList(data) {
  return request({
    url: '/Activity/GetActivityCommissionSendEmployeeList',
    method: 'post',
    data
  });
}


//  活动设置人员为已发放
export function setActivityCommissionSendEmployee(data) {
  return request({
    url: '/Activity/SetActivityCommissionSendEmployee',
    method: 'post',
    data
  });
}

//  获取活动提成总统计
export function getActivityCommissionStatistics(data) {
  return request({
    url: '/Activity/GetActivityCommissionStatistics',
    method: 'post',
    data
  });
}


//  获取活动期数下拉列表
export function getActivityCommissionPeriodsList(data) {
  return request({
    url: '/Activity/GetActivityCommissionPeriodsList',
    method: 'post',
    data
  });
}

//  获取留学提成规则
export function getSellStudyAbroadRuleList(data) {
  return request({
    url: '/SellCommission/GetSellStudyAbroadRuleList',
    method: 'post',
    data
  });
}

//  新增修改留学提成
export function setSellStudyAbroadRule(data) {
  return request({
    url: '/SellCommission/SetSellStudyAbroadRule',
    method: 'post',
    data
  });
}


//  新增修改留学提成
export function getSellStudyAbroadPeriodsPageList(data) {
  return request({
    url: '/SellCommission/GetSellStudyAbroadPeriodsPageList',
    method: 'post',
    data
  });
}


//  新增修改留学提成
export function getSellStudyAbroadUserList(data) {
  return request({
    url: '/SellCommission/GetSellStudyAbroadUserList',
    method: 'post',
    data
  });
}
//  获取留学销售提成明细列表
export function getSellStudyAbroadUserDetailList(data) {
  return request({
    url: '/SellCommission/GetSellStudyAbroadUserDetailList',
    method: 'post',
    data
  });
}

//  获取销售提成 - 订单跳转列表
export function getSellStudyAbroadForOrderList(data) {
  return request({
    url: '/SellCommission/GetSellStudyAbroadForOrderList',
    method: 'post',
    data
  });
}
//  获取留学提成统计
export function getSellStudyAbroadStatistics(data) {
  return request({
    url: '/SellCommission/GetSellStudyAbroadStatistics',
    method: 'post',
    data
  });
}
//  获取留学提成统计
export function getSellStudyAbroadPeriodsList(data) {
  return request({
    url: '/SellCommission/GetSellStudyAbroadPeriodsList',
    method: 'post',
    data
  });
}

//  生成留学提成
export function setSellStudyAbroadInfo(data) {
  return request({
    url: '/SellCommission/SetSellStudyAbroadInfo',
    method: 'post',
    data
  });
}
//获取提成发放人员
export function getSellStudyAbroadSendEmployeeList(data) {
  return request({
    url: '/SellCommission/GetSellStudyAbroadSendEmployeeList',
    method: 'post',
    data
  });
}
//设置已制单人员
export function setSellStudyAbroadSendEmployee(data) {
  return request({
    url: '/SellCommission/SetSellStudyAbroadSendEmployee',
    method: 'post',
    data
  });
}
/**
 * 获取收据配置
 */
 export function getReceiptConfigInfo(data) {
  return request({
    url: '/Finance/GetReceiptConfigInfo',
    method: 'post',
    data
  })
}
/**
 * 保存收据配置
 */
 export function setReceiptConfigInfo(data) {
  return request({
    url: '/Finance/SetReceiptConfigInfo',
    method: 'post',
    data
  })
}

/**
 * 获取收据详情
 */
 export function getReceiptInfoForFinanceId(data) {
  return request({
    url: '/Finance/GetReceiptInfoForFinanceId',
    method: 'post',
    data
  })
}

/**
 * 新增修改收据信息
 */
 export function setReceiptInfo(data) {
  return request({
    url: '/Finance/SetReceiptInfo',
    method: 'post',
    data
  })
}

/**
 * 新增修改收据信息
 */
 export function delReceiptInfo(data) {
  return request({
    url: '/Finance/DelReceiptInfo',
    method: 'post',
    data
  })
}

/**
 * 获取收据分页列表
 */
 export function getReceiptInfoPageList(data) {
  return request({
    url: '/Finance/GetReceiptInfoPageList',
    method: 'post',
    data
  })
}
/**
 * 获取收据分享二维码链接
 *
 */
export function createWeChatCodeForReceipt(data) {
    return request({
      url: '/EducationContract/CreateWeChatCodeForReceipt',
      method: 'post',
      data
    })
  }
  //获取投稿提成配置
export function getTeacherContributeConfig(data) {
    return request({
      url: '/TeachingRewards/GetTeacherContributeConfig',
      method: 'post',
      data
    })
}
  //设置投稿提成配置
  export function setTeacherContributeConfig(data) {
    return request({
      url: '/TeachingRewards/SetTeacherContributeConfig',
      method: 'post',
      data
    })
}
  //获取投稿提成期数分页列表
  export function getTeaConCommissionPeriodsPageList(data) {
    return request({
      url: '/TeachingRewards/GetTeaConCommissionPeriodsPageList',
      method: 'post',
      data
    })
}
  //创建投稿提成
  export function SetTeaConCommissionInfo(data) {
    return request({
      url: '/TeachingRewards/SetTeaConCommissionInfo',
      method: 'post',
      data
    })
}
  //获取投稿提成用户列表
  export function getTeaConCommissionUserList(data) {
    return request({
      url: '/TeachingRewards/GetTeaConCommissionUserList',
      method: 'post',
      data
    })
}
  //获取投稿提成明细列表
  export function getTeaConCommissionUserDetailList(data) {
    return request({
      url: '/TeachingRewards/GetTeaConCommissionUserDetailList',
      method: 'post',
      data
    })
}
  //投稿提成统计
  export function getTeaConCommissionStatistics(data) {
    return request({
      url: '/TeachingRewards/GetTeaConCommissionStatistics',
      method: 'post',
      data
    })
}
  //获取投稿提成期数下拉列表
  export function getTeaConCommissionPeriodsList(data) {
    return request({
      url: '/TeachingRewards/GetTeaConCommissionPeriodsList',
      method: 'post',
      data
    })
}
  //获取投稿提成发放人员列表
  export function getTeaConCommissionSendEmployeeList(data) {
    return request({
      url: '/TeachingRewards/GetTeaConCommissionSendEmployeeList',
      method: 'post',
      data
    })
}

  //设置提成发放人员
  export function setTeaConCommissionSendEmployee(data) {
    return request({
      url: '/TeachingRewards/SetTeaConCommissionSendEmployee',
      method: 'post',
      data
    })
}
/**
 * 获取市场顾问提成规则列表
 */

 export function getSellAchievementsRuleList(data) {
  return request({
    url: '/SellAchievements/GetSellAchievementsRuleList',
    method: 'post',
    data
  });
}

/**
 * 市场顾问保存规则
 */
 export function setSellAchievementsRule(data) {
  return request({
    url: '/SellAchievements/SetSellAchievementsRule',
    method: 'post',
    data
  });
}
/**
 * 市场顾问保存删除
 */
 export function delSellAchievementsRule(data) {
  return request({
    url: '/SellAchievements/DelSellAchievementsRule',
    method: 'post',
    data
  });
}

/**
 * 获取人头奖金配置分页列表
 */
export function GetBounsPlanPage(data) {
  return request({
    url: '/Bonus/GetBounsPlanPage',
    method: 'post',
    data
  });
}

/**
 * 新增修改人头奖金配置
 */
export function SetBounsPlan(data) {
  return request({
    url: '/Bonus/SetBounsPlan',
    method: 'post',
    data
  });
}

/**
 * 新增修改人头奖金配置
 */
export function RemoveBonusPlan(data) {
  return request({
    url: '/Bonus/RemoveBonusPlan',
    method: 'post',
    data
  });
}

/**
 * 生成人头奖励
 */
export function CreateEmpBonus(data) {
  return request({
    url: '/Bonus/CreateEmpBonus',
    method: 'post',
    data
  });
}

/**
 * 设置人头奖励未已发放
 */
export function saveEmployeeBounsIssue(data) {
  return request({
    url: '/Bonus/SetEmployeeBounsIssue',
    method: 'post',
    data
  });
}

/**
 * 获取人头奖励分页列表
 */
export function queryPersonnelPeriodPage(data) {
  return request({
    url: '/Bonus/GetPersonnelPeriodPage',
    method: 'post',
    data
  });
}


/**
 * 获取人头奖金配置
 */
export function GetBonusPlan(data) {
  return request({
    url: '/Bonus/GetBonusPlan',
    method: 'post',
    data
  });
}
/**
 * 获取业绩期数分页列表
 */
 export function getSellAchievementsPeriodsPageList(data) {
  return request({
    url: '/SellAchievements/GetSellAchievementsPeriodsPageList',
    method: 'post',
    data
  });
}
/**
 * 生成业绩提成
 */
 export function setAchievementsCommissionInfo(data) {
  return request({
    url: '/SellAchievements/SetAchievementsCommissionInfo',
    method: 'post',
    data
  });
}
/**
 * 业绩提成 获取提成可发放人员
 */
 export function getSellAchievementsSendEmployeeList(data) {
  return request({
    url: '/SellAchievements/GetSellAchievementsSendEmployeeList',
    method: 'post',
    data
  });
}
/**
 * 业绩提成 获取提成可发放人员
 */
 export function setSellAchievementsSendEmployee(data) {
  return request({
    url: '/SellAchievements/SetSellAchievementsSendEmployee',
    method: 'post',
    data
  });
}

/**
 * 业绩提成 获取提成期数 员工提成
 */
 export function getSellAchievementsUserList(data) {
  return request({
    url: '/SellAchievements/GetSellAchievementsUserList',
    method: 'post',
    data
  });
}

/**
 * 业绩提成 获取期数提成 员工提成明细列表
 */
 export function getSellAchievementsUserDetailList(data) {
  return request({
    url: '/SellAchievements/GetSellAchievementsUserDetailList',
    method: 'post',
    data
  });
}

/**
 * 业绩提成 获取订单跳转 提成详情
 */
 export function getSellAchievementsForOrderList(data) {
  return request({
    url: '/SellAchievements/GetSellAchievementsForOrderList',
    method: 'post',
    data
  });
}
/**
 * 业绩提成 获取订单跳转 提成详情
 */
 export function getSellAchievementsStatistics(data) {
  return request({
    url: '/SellAchievements/GetSellAchievementsStatistics',
    method: 'post',
    data
  });
}
/**
 * 业绩提成 获取提成期数下拉列表
 */
 export function getSellAchievementsPeriodsList(data) {
  return request({
    url: '/SellAchievements/GetSellAchievementsPeriodsList',
    method: 'post',
    data
  });
}

/**
 * 业绩提成 提成明细界面 查询应发提成 变更记录
 */
 export function getSellAchievementsChangeLog(data) {
  return request({
    url: '/SellAchievements/GetSellAchievementsChangeLog',
    method: 'post',
    data
  });
}

/**
 * 员工人头奖励 详情
 */
export function GetPersonnelPeriodDetails(data) {
  return request({
    url: '/Bonus/GetPersonnelPeriodDetails',
    method: 'post',
    data
  });
}
/**
 * 返佣和幸福存折   获取期数分页列表
 */
 export function getCommissionPeriodsPageList(data) {
  return request({
    url: '/CustomerCommission/GetCommissionPeriodsPageList',
    method: 'post',
    data
  });
}
export function SetCommissionPeriodsFinanace(data) {
  return request({
    url: '/CustomerCommission/SetBatchFinance',
    method: 'post',
    data
  });
}

/**
 * 返佣和幸福存折   生成期数
 */
 export function setUserReturnCommission(data) {
  return request({
    url: '/finance/SetUserReturnCommission',
    method: 'post',
    data
  });
}
/**
 * 返佣和幸福存折  获取周期下 用户分组统计列表
 */
 export function getCommissionUserList(data) {
  return request({
    url: '/CustomerCommission/GetCommissionUserList',
    method: 'post',
    data
  });
}
/**
 * 返佣和幸福存折  获取周期下 用户分组统计列表
 */
 export function getCommissionPeriodsList(data) {
  return request({
    url: '/CustomerCommission/GetCommissionPeriodsList',
    method: 'post',
    data
  });
}

/**
 * 获取收支明细数据
 *
 */
export function GetReserveClassBalanceSheet(data) {
  return request({
    url: '/Finance/GetReserveClassBalanceSheet',
    method: 'post',
    data
  });
}

/**
 * 返佣和幸福存折  获取用户返佣/存折明细
 */
 export function getCommissionStatistics(data) {
  return request({
    url: '/CustomerCommission/GetCommissionStatistics',
    method: 'post',
    data
  });
}