import request from '../../utils/request'

/**
 * 获取OKR左侧人员列表
 * @param {JSON参数} data 
 */
export function queryOKRMyEmployeeList(data) {
  return request({
    url: '/OKRPeriod/GetOKRMyEmployeeList',
    method: 'post',
    data
  })
}
/**
 * 查询已存在的指定人员的Objective
 * @param {*} data 
 */
export function queryOKRPeriodList(data) {
  return request({
    url: '/OKRPeriod/GetOKRPeriodList',
    method: 'post',
    data
  })
}
/**
 * 新增目标
 * @param {*} data 
 */
export function saveMyObjective(data) {
  return request({
    url: '/OKRPeriod/SgetOKRMyObjectiveInfo',
    method: 'post',
    data
  })
}
/**
 * 新增KR
 * @param {*} data 
 */
export function saveMyKR(data) {
  return request({
    url: '/OKRPeriod/SgetOKRMyKeyResultInfo',
    method: 'post',
    data
  })
}
export function queryMyOKR(data) {
  return request({
    url: '/OKRPeriod/GetOKRMyObjectiveList',
    method: 'post',
    data
  })
}
export function deleteMyKR(data){
  return request({
    url: '/OKRPeriod/SgetOKRMyKeyResultDel',
    method: 'post',
    data
  })
}
export function querySignObject(data){
  return request({
    url: '/OKRPeriod/GetOKRMyObjectiveInfo',
    method: 'post',
    data
  })
}
export function saveKRWeight(data){
  return request({
    url: '/OKRPeriod/SgetOKRMyKeyResultWeight',
    method: 'post',
    data
  })
}
export function setKRProgressState(data){
  return request({
    url: '/OKRPeriod/SgetOKRMyKeyResultState',
    method: 'post',
    data
  })
}
export function setKRProgress(data){
  return request({
    url: '/OKRPeriod/SgetOKRMyKeyResultProgress',
    method: 'post',
    data
  })
}
export function setKRScore(data){
  return request({
    url: '/OKRPeriod/SgetOKRMyKeyResultScore',
    method: 'post',
    data
  })
}
export function setObjectiveProgress(data){
  return request({
    url: '/OKRPeriod/SgetOKRMyObjectiveState',
    method: 'post',
    data
  })
}
export function queryPower(data){
  return request({
    url: '/OKRPeriod/GetOKRPermissionList',
    method: 'post',
    data
  })
}
export function setPower(data){
  return request({
    url: '/OKRPeriod/SgetOKRPermissionInfo',
    method: 'post',
    data
  })
}
export function queryDefaultStatus(data){
  return request({
    url: '/OKRPeriod/GetOKRDefaultPermissionInfo',
    method: 'post',
    data
  })
}
export function setDefaultStatus(data){
  return request({
    url: '/OKRPeriod/SgetOKRDefaultPermissionInfo',
    method: 'post',
    data
  })
}
export function queryObjectiveBySearch(data){
  return request({
    url: '/OKRPeriod/GetOKROthersObjectiveDropListByName',
    method: 'post',
    data
  })
}
export function setAlign(data){
  return request({
    url: '/OKRPeriod/SgetOKRMyObjectiveParent',
    method: 'post',
    data
  })
}
export function deleteAlign(data){
  return request({
    url: '/OKRPeriod/SgetOKRMyObjectiveParentCancel',
    method: 'post',
    data
  })
}
export function setComment(data){
  return request({
    url: '/OKRPeriod/SetComment',
    method: 'post',
    data
  })
}
export function queryComment(data){
  return request({
    url: '/OKRPeriod/GetCommentPageList',
    method: 'post',
    data
  })
}
export function setCommentStatus(data){
  return request({
    url: '/OKRPeriod/SetCommentStatus',
    method: 'post',
    data
  })
}
export function queryAlignList(data){
  return request({
    url: '/OKRPeriod/GetOKRMyEmployeeAlignList',
    method: 'post',
    data
  })
}
export function queryOtherObjectiveList(data){
  return request({
    url: '/OKRPeriod/GetOKROthersObjectiveList',
    method: 'post',
    data
  })
}
export function setUserLike(data){
  return request({
    url: '/OKRPeriod/SgetOKREmployeeAttention',
    method: 'post',
    data
  })
}
export function queryUserIsLike(data){
  return request({
    url: '/OKRPeriod/GetOKREmployeeAttention',
    method: 'post',
    data
  })
}
export function setObjectiveState(data){
  return request({
    url: '/OKRPeriod/SetOKRObjectiveAuditAgain',
    method: 'post',
    data
  })
}
export function getMyAuditUsersList(data){
  return request({
    url: '/OKRPeriod/GetOKRMyEmployeeAuditList',
    method: 'post',
    data
  })
}
export function getMyAuditList(data){
  return request({
    url: '/OKRPeriod/GetOKRObjectiveAuditList',
    method: 'post',
    data
  })
}
export function setObjectiveStatus(data){
  return request({
    url: '/OKRPeriod/SetOKRObjectiveAudit',
    method: 'post',
    data
  })
}
export function queryKRRuleList(data){
  return request({
    url: '/OKRPeriod/GetOKRRuleDownLoadList',
    method: 'post',
    data
  })
}
export function queryMyManageDepartment(data){
  return request({
    url: '/OKRPeriod/GetOKRMyManageDepartment',
    method: 'post',
    data
  })
}
export function queryMyChildEmployeeList(data){
  return request({
    url: '/OKRPeriod/GetOKRMyChildEmployeeList',
    method: 'post',
    data
  })
}
export function setKRRule(data){
  return request({
    url: '/OKRPeriod/SetOKRKeyResultUseRule',
    method: 'post',
    data
  })
}
export function queryKRRuleRangeList(data){
  return request({
    url: '/OKRPeriod/GetOKRKeyResultRuleReList',
    method: 'post',
    data
  })
}
export function deleteKRRule(data){
  return request({
    url: '/OKRPeriod/CancelOKRKeyResultUseRule',
    method: 'post',
    data
  })
}
export function queryUserOKRAlignView(data){
  return request({
    url: '/OKRPeriod/GetOKRMyAlignView',
    method: 'post',
    data
  })
}
export function queryUserOKRNextAlignView(data){
  return request({
    url: '/OKRPeriod/GetOKRMyAlignViewNext',
    method: 'post',
    data
  })
}
export function queryOtherSignObjective(data){
  return request({
    url: '/OKRPeriod/GetOKROthersObjectiveInfo',
    method: 'post',
    data
  })
}