import request from '../../utils/request'

/**
 * 获取题库类型列表
 * @param {JSON参数} data 
 */
export function queryQuestionTypeList(data) {
  return request({
    url: '/Question/GetQuestionTypeList',
    method: 'post',
    data
  })
}


/**
 * 获取题库分页列表
 * @param {JSON参数} data 
 */
export function queryQuestionPageList(data) {
  return request({
    url: '/Question/GetQuestionPageList',
    method: 'post',
    data
  })
}

/**
 * 添加修改题库
 * @param {JSON参数} data 
 */
export function saveQuestion(data) {
  return request({
    url: '/Question/SetQuestion',
    method: 'post',
    data
  })
}


/**
 * 根据编号获取问题详情
 * @param {JSON参数} data 
 */
export function queryQuestionInfo(data) {
  return request({
    url: '/Question/GetQuestion',
    method: 'post',
    data
  })
}

/**
 * 根据编号删除问题详情
 * @param {JSON参数} data 
 */
export function deleteQuestion(data) {
  return request({
    url: '/Question/RemoveQuestion',
    method: 'post',
    data
  })
}

/**
 * 修改问题排序
 * @param {JSON参数} data 
 */
export function setQuestionSort(data) {
  return request({
    url: '/Question/UpdateQuestionSort',
    method: 'post',
    data
  })
}

/**
 * 添加知识点
 * @param {JSON参数} data 
 */
export function addQuestionPoint(data) {
  return request({
    url: '/Question/SetQuestionPoint',
    method: 'post',
    data
  })
}


/**
 * 获取知识点分页列表
 * @param {JSON参数} data 
 */
export function queryPointPageList(data) {
  return request({
    url: '/Question/GetPointPageList',
    method: 'post',
    data
  })
}

/**
 * 根据编号删除知识点
 * @param {JSON参数} data 
 */
export function deleteQuestionPoint(data) {
  return request({
    url: '/Question/RemoveQuestionPoint',
    method: 'post',
    data
  })
}

/**
 * 获取问题难易程度列表
 * @param {JSON参数} data 
 */
export function queryDifficultyType() {
  return request({
    url: '/Question/GetDifficultyType',
    method: 'post',
    data: {}
  })
}

/**
 * 批量添加问题
 * @param {JSON参数} data 
 */
export function saveQuestionBeatch(data) {
  return request({
    url: '/Question/SetQuestionBeatch',
    method: 'post',
    data
  })
}

/**
 * 获取问题大类
 */
export function queryQuestionCategory() {
  return request({
    url: '/Question/GetQuestionCategory',
    method: 'post',
  })
}

/**
 * 获取问题考级程度
 */
export function queryQuestionLevelType() {
    return request({
      url: '/Question/GetQuestionLevelType',
      method: 'post',
    })
  }

/**
 * 题目上移下移
 */
export function UpdateQuestionSort(data) {
  return request({
    url: '/Question/UpdateQuestionSort',
    method: 'post',
    data
  })
}

/**
 * 问题复制
 * @param {*} data 
 */
export function CopyQuestion(data) {
  return request({
    url: '/Question/CopyQuestion',
    method: 'post',
    data
  })
}


/**
 * 获取题库分页列表
 * @param {*} data 
 */
export function queryQuestionBankPage(data) {
  return request({
    url: '/Question/GetQuestionBankPageList',
    method: 'post',
    data
  })
}


/**
 * 获取题库实体
 * @param {*} data 
 */
export function getQuestionBankInfo(data) {
  return request({
    url: '/Question/GetQuestionBank',
    method: 'post',
    data
  })
}

/**
 * 获取题库等级列表
 * @param {*} data 
 */
export function queryBankTypeList(data) {
  return request({
    url: '/Question/GetBankTypeList',
    method: 'post',
    data
  })
}

/**
 * 新增修改题库
 * @param {*} data 
 */
export function SetQuestionBank(data) {
  return request({
    url: '/Question/SetQuestionBank',
    method: 'post',
    data
  })
}

/**
 * 删除题库
 * @param {*} data 
 */
export function RemoveQuestionBank(data) {
  return request({
    url: '/Question/RemoveQuestionBank',
    method: 'post',
    data
  })
}


/**
 * 批量设置问题考级程度
 * @param {*} data 
 */
export function saveBatchQuestionLevel(data) {
    return request({
      url: '/Question/SetBatchQuestionLevel',
      method: 'post',
      data
    })
  }

/**
 * 根据题库编号获取题库题型列表(单选题、多选题、等)【试卷组卷使用】
 * @param {*} data 
 */
export function queryQuestionTypeStaticList(data) {
  return request({
    url: '/Question/GetQuestionTypeStaticList',
    method: 'post',
    data
  })
}

/**
 * 根据题库编号获取题库题型分类列表(读音选择题、汉字选择题等)【试卷组卷使用】
 * @param {*} data 
 */
export function queryQuestionCategoryStaticList(data) {
  return request({
    url: '/Question/GetQuestionCategoryStaticList',
    method: 'post',
    data
  })
}
  

/**
 * 获取试卷组卷模板
 * @param {*} data 
 */
export function queryExaminationTemplatePage(data) {
  return request({
    url: '/Exam/GetExaminationTemplatePage',
    method: 'post',
    data
  })
}


/**
 * 删除分组及问题
 * @param {*} data 
 */
export function DeletePaperGroup(data) {
  return request({
    url: '/Exam/DeletePaperGroup',
    method: 'post',
    data
  })
}

/**
 * 删除问题
 * @param {*} data 
 */
export function DeletePaperDetails(data) {
  return request({
    url: '/Exam/DeletePaperDetails',
    method: 'post',
    data
  })
}

