import request from '../../utils/request'
/**
 * 选项配置
 */
export function getOptionList() {
  var array = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'];
  return array;
}

/**
 * 选择题选项配置【单选、多选】
 */
export function optionListConfig() {
  return [{
    Name: "A",
    Content: "",
    IsAnswer: false
  }, {
    Name: "B",
    Content: "",
    IsAnswer: false
  }, {
    Name: "C",
    Content: "",
    IsAnswer: false
  }, {
    Name: "D",
    Content: "",
    IsAnswer: false
  }];
}

/**
 * 创建问题
 */
export function CreateQuestion(questionKey) {
  var AnswerList = [];
  switch (questionKey) {
    //单选题
    case "single":
      AnswerList = optionListConfig();
      break;
      //单选题数字
    case "single-number":
      var temp = optionListConfig();
      temp.forEach((item, index) => {
        item.Name = index + 1;
      })
      AnswerList = temp;
      break;
      //多选题
    case "multiple":
      AnswerList = optionListConfig();
      break;
      //填空题
    case "fill-in":
      AnswerList.push({
        Content: ""
      })
      break;
      //判断题
    case "judge":
      AnswerList.push({
        Name: "A",
        Content: "对",
        IsAnswer: true
      }, {
        Name: "B",
        Content: "错",
        IsAnswer: false
      })
      break;
      //分录题
    case "entry-problem":
      AnswerList.push({
        Content: ""
      })
      break;
      //资料题
    case "data-question":
      AnswerList.push({
        Content: ""
      })
      break;
      //连线题
    case "matching":
      var array1 = [{
        Name: "1",
        Content: ""
      }];
      var array2 = [{
        Name: "A",
        Content: ""
      }];
      var array3 = [{
        Name: "1",
        Content: "A"
      }];
      AnswerList.push(array1);
      AnswerList.push(array2);
      AnswerList.push(array3);
      break;
      //排序题
    case "sorting-problem":
      var tempArray = [{
        Name: "A",
        Content: ""
      }, {
        Name: "B",
        Content: ""
      }, {
        Name: "C",
        Content: ""
      }, {
        Name: "D",
        Content: ""
      }];
      var array2 = [{
        Name: "A",
        Content: ""
      }, {
        Name: "A",
        Content: ""
      }, {
        Name: "A",
        Content: ""
      }, {
        Name: "A",
        Content: ""
      }];
      AnswerList.push(tempArray);
      AnswerList.push(array2);
      break;
      //完型填空
    case "cloze":
      var tempArray = optionListConfig();
      var clozeObj = {
        SubScore: 0,
        OptionList: tempArray,
      };
      AnswerList.push(clozeObj);
      break;
      //阅读理解
    case "reading-comprehensio":
      AnswerList.push({
        QuestionType: 1,
        QuestionKey: "single",
        QuestionName: "单选题",
        SubTitle: "", //题目内容
        SubScore:0,
        SubAnwser: optionListConfig()
      });
      break;
      //听力题
    case "listening":
      AnswerList.push({
        QuestionType: 1,
        QuestionKey: "single",
        QuestionName: "单选题",
        SubTitle: "", //题目内容
        SubScore:0,
        SubAnwser: optionListConfig()
      });
      break;
      //共用选择题
    case "sharing-choose":
      var tempArray = [{
        Name: "A",
        Content: ""
      }, {
        Name: "B",
        Content: ""
      }, {
        Name: "C",
        Content: ""
      }, {
        Name: "D",
        Content: ""
      }];
      var array2 = [{
        Name: "",
        Content: "",
      }, {
        Name: "",
        Content: "",
      }];
      AnswerList.push(tempArray);
      AnswerList.push(array2);
      break;
  }
  return AnswerList;
}


/**
 * 【单选题、多选题、数字选择题】验证
 */
export function chooseValidate(gName, detailsList) {
  var message = "";
  //单选题 多选题
  if (detailsList && detailsList.length > 0) {
    for (let i = 0; i < detailsList.length; i++) {
      var Num = 0;
      if (detailsList[i].Title == '') {
        message = `请填写【${gName}】第 ${i+1} 题 问题内容！`;
        return message;
      }
      for (let j = 0; j < detailsList[i].QuestionContentObj.length; j++) {
        if (detailsList[i].QuestionContentObj[j].Content == '') {
          message = `请填写【${gName}】第 ${i+1} 题，选项 ${detailsList[i].QuestionContentObj[j].Name} 内容！`;
          return message;
        }
        if (detailsList[i].QuestionContentObj[j].IsAnswer) {
          Num++
        }
      }
      if (Num == 0) {
        message = `请设置【${gName}】第 ${i+1} 题 正确答案！`;
        return message;
      }
    }
  }
  return message;
}

/**
 * 【填空题、分录题、资料题】验证
 */
export function fillInValidate(gName, detailsList) {
  var message = "";
  for (let i = 0; i < detailsList.length; i++) {
    if (detailsList[i].Title == '') {
      message = `请填写【${gName}】第 ${i+1} 题 问题内容！`;
      return message;
    }
    for (let j = 0; j < detailsList[i].QuestionContentObj.length; j++) {
      if (detailsList[i].QuestionContentObj[j].Content == '') {
        message = `请填写【${gName}】第 ${i+1} 题，第 ${j+1} 空 答案！`;
        return message;
      }
    }
  }
  return message;
}

/**
 * 【判断题】验证
 */
export function judgeValidate(gName, detailsList) {
  var message = "";
  for (let i = 0; i < detailsList.length; i++) {
    if (detailsList[i].Title == '') {
      message = `请填写【${gName}】第 ${i+1} 题 问题内容！`;
      return message;
    }
  }
  return message;
}

/**
 * 【简答题、名词解释、论述题、计算题、其它题】验证
 */
export function shortanswerValidate(gName, detailsList) {
  var message = "";
  for (let i = 0; i < detailsList.length; i++) {
    if (detailsList[i].Title == '') {
      message = `请填写【${gName}】第 ${i+1} 题 问题内容！`;
      return message;
    }
    if (detailsList[i].Answer == '') {
      message = `请填写【${gName}】第 ${i+1} 题 问题答案！`;
      return message;
    }
  }
  return message;
}

/**
 * 【连线题】验证
 */
export function matchingValidate(gName, detailsList) {
  var message = "";
  for (let i = 0; i < detailsList.length; i++) {
    if (detailsList[i].Title == '') {
      message = `请填写【${gName}】第 ${i+1} 题 问题内容！`;
      return message;
    }
    if (detailsList[i].QuestionContentObj.length > 0) {
      for (let p = 0; p < detailsList[i].QuestionContentObj[0].length; p++) {
        if (detailsList[i].QuestionContentObj[0][p].Content == '') {
          message = `请填写【${gName}】第 ${i+1} 题 第一组 选项 ${detailsList[i].QuestionContentObj[0][p].Name} 内容！`
          return message;
        }
      }
    }
    if (detailsList[i].QuestionContentObj.length > 0) {
      for (let p = 0; p < detailsList[i].QuestionContentObj[1].length; p++) {
        if (detailsList[i].QuestionContentObj[1][p].Content == '') {
          message = `请填写【${gName}】第 ${i+1} 题 第二组 选项 ${detailsList[i].QuestionContentObj[1][p].Name} 内容！`
          return message;
        }
      }
    }
  }
  return message;
}

/**
 * 【排序题】验证
 */
export function sortingproblemValidate(gName, detailsList) {
  var message = "";
  if (detailsList && detailsList.length > 0) {
    for (let i = 0; i < detailsList.length; i++) {
      if (detailsList[i].Title == '') {
        message = `请填写【${gName}】第 ${i+1} 题 问题内容！`;
        return message;
      }
      for (let j = 0; j < detailsList[i].QuestionContentObj[0].length; j++) {
        if (detailsList[i].QuestionContentObj[0][j].Content == '') {
          message = `请填写【${gName}】第 ${i+1} 题 选项 ${detailsList[i].QuestionContentObj[0][j].Name} 内容！`
          return message;
        }
      }
    }
  }
  return message;
}

/**
 *【完型填空】验证 
 */
export function clozeValidate(gName, detailsList) {
  var message = "";
  if (detailsList && detailsList.length > 0) {
    for (let i = 0; i < detailsList.length; i++) {
      if (detailsList[i].Title == '') {
        message = `请填写【${gName}】第 ${i+1} 题 问题内容！`;
        return message;
      }
      for (let j = 0; j < detailsList[i].QuestionContentObj.length; j++) {
        var Num = 0;
        for (var k = 0; k < detailsList[i].QuestionContentObj[j].OptionList.length; k++) {
          if (detailsList[i].QuestionContentObj[j].OptionList[k].Content == '') {
            message =
              `请填写【${gName}】第 ${i+1} 题，第 ${j+1} 小题 选项 ${detailsList[i].QuestionContentObj[j].OptionList[k].Name} 内容！`;
            return message;
          }
          if (detailsList[i].QuestionContentObj[j].OptionList[k].IsAnswer) {
            Num++
          }
        }
        if (Num == 0) {
          message = `请设置【${gName}】第 ${i+1} 题，第 ${j+1} 小题 正确答案！`;
          return message;
        }
      }
    }
  }
  return message;
}

/**
 * 【阅读理解、听力题】验证
 */
export function readingcomprehensioValidate(gName, detailsList) {
  var message = "";
  if (detailsList && detailsList.length > 0) {
    for (let i = 0; i < detailsList.length; i++) {
      if (detailsList[i].Title == '') {
        message = `请填写【${gName}】第 ${i+1} 题 问题内容！`;
        return message;
      }
      for (let j = 0; j < detailsList[i].QuestionContentObj.length; j++) {
        var subQuestion = detailsList[i].QuestionContentObj[j];
        if (subQuestion) {
          if (subQuestion.SubTitle == '') {
            message = `请填写【${gName}】第 ${i+1} 题，第 ${j+1} 小题 问题内容！`;
            return message;
          }
          //单选题、多选题
          if (subQuestion.QuestionKey == 'single' || subQuestion.QuestionKey == "multiple") {
            var singleNum = 0;
            for (var k = 0; k < subQuestion.SubAnwser.length; k++) {
              if (subQuestion.SubAnwser[k].Content == '') {
                message = `请填写【${gName}】第 ${i+1} 题，第 ${j+1} 小题 选项 ${subQuestion.SubAnwser[k].Name} 内容！`;
                return message;
              }
              if (subQuestion.SubAnwser[k].IsAnswer) {
                singleNum++
              }
            }
            if (singleNum == 0) {
              message = `请设置【${gName}】第 ${i+1} 题，第 ${j+1} 小题 正确答案！`;
              return message;
            }
          }
          //填空题
          if (subQuestion.QuestionKey == "fill-in") {
            for (var k = 0; k < subQuestion.SubAnwser.length; k++) {
              if (subQuestion.SubAnwser[k].Content == '') {
                message = `请填写【${gName}】第 ${i+1} 题，第 ${j+1} 小题 第 ${k+1} 空答案！`;
                return message;
              }
            }
          }
          //简答题
          if (subQuestion.QuestionKey == "short-answer") {
            for (var k = 0; k < subQuestion.SubAnwser.length; k++) {
              if (subQuestion.SubAnwser[k].Content == '') {
                message = `请填写【${gName}】第 ${i+1} 题，第 ${j+1} 小题答案！`;
                return message;
              }
            }
          }
        }
      }
    }
  }
  return message;
}

/**
 * 【公用选项题】验证
 */
export function sharingchooseValidate(gName, detailsList) {
  var message = "";
  if (detailsList && detailsList.length > 0) {
    for (var i = 0; i < detailsList.length; i++) {
      for (var j = 0; j < detailsList[i].QuestionContentObj[0].length; j++) {
        if (detailsList[i].QuestionContentObj[0][j].Content == '') {
          message = `请填写【${gName}】第 ${i+1} 题 第一组 选项 ${detailsList[i].QuestionContentObj[0][j].Name} 内容！`;
          return message;
        }
      }
      for (var j = 0; j < detailsList[i].QuestionContentObj[1].length; j++) {
        if (detailsList[i].QuestionContentObj[1][j].Content == '') {
          message = `请填写【${gName}】第 ${i+1} 题 第二组 题干 ${j+1} 内容！`;
          return message;
        }
        if (detailsList[i].QuestionContentObj[1][j].Name == '') {
          message = `请选择【${gName}】第 ${i+1} 题 第二组 题干 ${j+1} 答案！`;
          return message;
        }
      }
    }
  }
  return message;
}



/**
 *【题库使用--单题目验证】 (单选题、多选题、数字选择题 验证)
 */
export function questionBankChooseValidate(gName, AnswerList, qObj) {
  var message = "";
  if (qObj && qObj.Title == '') {
    message = `请填写【${gName}】问题内容！`;
    return message;
  }
  if (AnswerList && AnswerList.length > 0) {
    var Num = 0;
    for (let j = 0; j < AnswerList.length; j++) {
      if (AnswerList[j].Content == '') {
        message = `请填写【${gName}】，选项 ${AnswerList[j].Name} 内容！`;
        return message;
      }
      if (AnswerList[j].IsAnswer) {
        Num++
      }
    }
    if (Num == 0) {
      message = `请设置【${gName}】正确答案！`;
      return message;
    }
  }
  return message;
}

/**
 * 【题库使用--单题目验证】 (填空题、分录题、资料题 验证)
 */
export function questionBankFillInValidate(gName, AnswerList, qObj) {
  var message = "";
  if (qObj && qObj.Title == '') {
    message = `请填写【${gName}】问题内容！`;
    return message;
  }
  if (AnswerList && AnswerList.length > 0) {
    for (let j = 0; j < AnswerList.length; j++) {
      if (AnswerList[j].Content == '') {
        message = `请填写【${gName}】，第 ${j+1} 空 答案！`;
        return message;
      }
    }
  }
  return message;
}

/**
 * 【题库使用--单题目验证】 (判断题 验证)
 */
export function questionBankJudgeValidate(gName, qObj) {
  var message = "";
  if (qObj && qObj.Title == '') {
    message = `请填写【${gName}】问题内容！`;
    return message;
  }
  return message;
}

/**
 * 【题库使用--单题目验证】 (简答题、名词解释、论述题、计算题、其它题 验证)
 */
export function questionBankShortanswerValidate(gName, qObj) {
  var message = "";
  if (qObj) {
    if (qObj.Title == '') {
      message = `请填写【${gName}】问题内容！`;
      return message;
    }
    if (qObj.Answer == '') {
      message = `请填写【${gName}】问题答案！`;
      return message;
    }
  }
  return message;
}

/**
 * 【题库使用--单题目验证】 (连线题 验证)
 */
export function questionBankMatchingValidate(gName, AnswerList, qObj) {
  var message = "";
  if (qObj && qObj.Title == '') {
    message = `请填写【${gName}】问题内容！`;
    return message;
  }
  if (AnswerList) {
    if (AnswerList.length > 0) {
      for (let p = 0; p < AnswerList[0].length; p++) {
        if (AnswerList[0][p].Content == '') {
          message = `请填写【${gName}】 第一组 选项 ${AnswerList[0][p].Name} 内容！`
          return message;
        }
      }
    }
    if (AnswerList.length > 1) {
      for (let p = 0; p < AnswerList[1].length; p++) {
        if (AnswerList[1][p].Content == '') {
          message = `请填写【${gName}】 第二组 选项 ${AnswerList[1][p].Name} 内容！`
          return message;
        }
      }
    }
  }
  return message;
}

/**
 * 【题库使用--单题目验证】 (排序题 验证)
 */
export function questionBankSortingproblemValidate(gName, AnswerList, qObj) {
  var message = "";
  if (qObj && qObj.Title == '') {
    message = `请填写【${gName}】问题内容！`;
    return message;
  }
  if (AnswerList && AnswerList.length > 0) {
    for (let j = 0; j < AnswerList[0].length; j++) {
      if (AnswerList[0][j].Content == '') {
        message = `请填写【${gName}】 选项 ${AnswerList[0][j].Name} 内容！`
        return message;
      }
    }
  }
  return message;
}

/**
 *【题库使用--单题目验证】 (完型填空 验证)
 */
export function questionBankClozeValidate(gName, AnswerList, qObj) {
  var message = "";
  if (qObj && qObj.Title == '') {
    message = `请填写【${gName}】问题内容！`;
    return message;
  }
  if (AnswerList && AnswerList.length > 0) {
    for (let j = 0; j < AnswerList.length; j++) {
      var Num = 0;
      for (var k = 0; k < AnswerList[j].OptionList.length; k++) {
        if (AnswerList[j].OptionList[k].Content == '') {
          message =
            `请填写【${gName}】第 ${j+1} 小题 选项 ${AnswerList[j].OptionList[k].Name} 内容！`;
          return message;
        }
        if (AnswerList[j].OptionList[k].IsAnswer) {
          Num++
        }
      }
      if (Num == 0) {
        message = `请设置【${gName}】，第 ${j+1} 小题 正确答案！`;
        return message;
      }
    }
  }
  return message;
}

/**
 * 【题库使用--单题目验证】 (阅读理解、听力题 验证)
 */
export function questionBankReadingcomprehensioValidate(gName, AnswerList, qObj) {
  var message = "";
  if (qObj && qObj.Title == '') {
    message = `请填写【${gName}】问题内容！`;
    return message;
  }
  if (AnswerList && AnswerList.length > 0) {
    for (let i = 0; i < AnswerList.length; i++) {
      var subQuestion = AnswerList[i];
      if (subQuestion) {
        if (subQuestion.SubTitle == '') {
          message = `请填写【${gName}】，第 ${i+1} 小题 问题内容！`;
          return message;
        }
        //单选题、多选题
        if (subQuestion.QuestionKey == 'single' || subQuestion.QuestionKey == "multiple") {
          var singleNum = 0;
          for (var k = 0; k < subQuestion.SubAnwser.length; k++) {
            if (subQuestion.SubAnwser[k].Content == '') {
              message = `请填写【${gName}】，第 ${i+1} 小题 选项 ${subQuestion.SubAnwser[k].Name} 内容！`;
              return message;
            }
            if (subQuestion.SubAnwser[k].IsAnswer) {
              singleNum++
            }
          }
          if (singleNum == 0) {
            message = `请设置【${gName}】，第 ${i+1} 小题 正确答案！`;
            return message;
          }
        }
        //填空题
        if (subQuestion.QuestionKey == "fill-in") {
          for (var k = 0; k < subQuestion.SubAnwser.length; k++) {
            if (subQuestion.SubAnwser[k].Content == '') {
              message = `请填写【${gName}】，第 ${i+1} 小题 第 ${k+1} 空答案！`;
              return message;
            }
          }
        }
        //简答题
        if (subQuestion.QuestionKey == "short-answer") {
          for (var k = 0; k < subQuestion.SubAnwser.length; k++) {
            if (subQuestion.SubAnwser[k].Content == '') {
              message = `请填写【${gName}】，第 ${i+1} 小题答案！`;
              return message;
            }
          }
        }
      }
    }
  }
  return message;
}


/**
 * 【题库使用--单题目验证】 (公用选项题 验证)
 */
export function questionBankSharingchooseValidate(gName, AnswerList) {
  var message = "";
  if (AnswerList && AnswerList.length > 0) {
    for (var j = 0; j < AnswerList[0].length; j++) {
      if (AnswerList[0][j].Content == '') {
        message = `请填写【${gName}】，第一组 选项 ${AnswerList[0][j].Name} 内容！`;
        return message;
      }
    }
    for (var j = 0; j < AnswerList[1].length; j++) {
      if (AnswerList[1][j].Content == '') {
        message = `请填写【${gName}】，第二组 题干 ${j+1} 内容！`;
        return message;
      }
      if (AnswerList[1][j].Name == '') {
        message = `请选择【${gName}】， 第二组 题干 ${j+1} 答案！`;
        return message;
      }
    }
    return message;
  }
}
