import request from '../../utils/request'

/**
 * 获取同行客户分页列表
 *
 */
export function GetCustomerPage(data) {
  return request({
    url: '/B2BCustomer/GetCustomerPage',
    method: 'post',
    data
  })
}
export function GetCustomerPage_v2(data) {
  return request({
    url: '/B2BCustomer/GetCustomerPageList_V2',
    method: 'post',
    data
  })
}
/**
 * 新增修改同业客户资料
 *
 */
export function SetCustomer(data) {
  return request({
    url: '/B2BCustomer/SetCustomer',
    method: 'post',
    data
  })
}


/**
 * 根据编号删除同业客户资料
 *
 */
export function RemoveCustomer(data) {
  return request({
    url: '/B2BCustomer/RemoveCustomer',
    method: 'post',
    data
  })
}

/**
 * 根据编号获取同业客户资料
 *
 */
export function GetCustomer(data) {
  return request({
    url: '/B2BCustomer/GetCustomer',
    method: 'post',
    data
  })
}

/**
 * 同业客户资料审批
 *
 */
export function AuditCustomer(data) {
  return request({
    url: '/B2BCustomer/AuditCustomer',
    method: 'post',
    data
  })
}

/**
 * 获取营销任务分页列表
 *
 */
export function GetCustomerTaskPage(data) {
  return request({
    url: '/B2BCustomer/GetCustomerTaskPage',
    method: 'post',
    data
  })
}

/**
 * 删除营销任务
 *
 */
export function RemoveCustomerTask(data) {
  return request({
    url: '/B2BCustomer/RemoveCustomerTask',
    method: 'post',
    data
  })
}

/**
 * 获取任务详情
 *
 */
export function GetCustomerTask(data) {
  return request({
    url: '/B2BCustomer/GetCustomerTask',
    method: 'post',
    data
  })
}

/**
 * 保存任务详情
 *
 */
export function SetCustomerTask(data) {
  return request({
    url: '/B2BCustomer/SetCustomerTask',
    method: 'post',
    data
  })
}


/**
 * 获取任务类型列表
 *
 */
export function GetTaskTypeList(data) {
  return request({
    url: '/B2BCustomer/GetTaskTypeList',
    method: 'post',
    data
  })
}

/**
 * 获取幸福存折接口
 *
 */
export function GetCustomerBalanceDetailPage(data) {
  return request({
    url: '/B2BCustomer/GetCustomerBalanceDetailPage',
    method: 'post',
    data
  })
}


/**
 * 获取客户完成任务分页列表
 *
 */
export function queryCustomerFinishtaskPage(data) {
  return request({
    url: '/B2BCustomer/GetCustomerFinishtaskPage',
    method: 'post',
    data
  })
}

/**
 * 根据编号获取任务完成详情列表
 *
 */
export function queryCustomerFinishtaskDetailsPage(data) {
  return request({
    url: '/B2BCustomer/GetCustomerFinishtaskDetailsPage',
    method: 'post',
    data
  })
}


/**
 * 获取同业提现分页列表
 *
 */
 export function getCustomerRemitPageList(data) {
  return request({
    url: '/B2BRemit/GetCustomerRemitPageList',
    method: 'post',
    data
  })
}
/**
 * 设置同业提现状态
 *
 */
 export function setCustomerRemitState(data) {
  return request({
    url: '/B2BRemit/SetCustomerRemitState',
    method: 'post',
    data
  })
}

/**
 * 奖品兑换
 *
 */
export function saveExchangeKudo(data) {
  return request({
    url: '/B2BCustomer/ExchangeKudo',
    method: 'post',
    data
  })
}
/**
 * 获取同业操作日志
 *
 */
export function getLogList(data) {
  return request({
    url: '/user/GetUserChangeLogPageList',
    method: 'post',
    data
  })
}
/**
* 获取同业客户阶段列表
*
*/
export function getCustomerStuStageStatistics(data) {
  return request({
    url: '/B2BCustomer/GetCustomerStuStageStatistics',
    method: 'post',
    data
  })
}
/**
* 获取同业佣金/幸福存折明细
*
*/
export function getCustomerCommissionPassbook(data) {
  return request({
    url: '/B2BCustomer/GetCustomerCommissionPassbook',
    method: 'post',
    data
  })
}
/**
*  同行详情里 返佣/幸福存折统计
*
*/
export function getCustomerCommissionStat(data) {
  return request({
    url: '/CustomerCommission/GetCustomerCommissionStat',
    method: 'post',
    data
  })
}
/**
* 同业转交
*
*/
export function setCustomerCareOf(data) {
  return request({
    url: '/B2BCustomer/SetCustomerCareOf',
    method: 'post',
    data
  })
}
/**
* 我的客户批量转订单
*
*/
export function setMyStudentToGuest(data) {
  return request({
    url: '/order/SetMyStudentToGuest',
    method: 'post',
    data
  })
}

/**
* 获取所有同行
*
*/
export function getAllCustomer(data) {
  return request({
    url: '/b2bcustomer/GetAllCustomerPageList',
    method: 'post',
    data
  })
}