import request from '../../utils/request'
/**
 * 获取日语培训列表
 *
 */
export function queryDutyFrequencyBySchoolIds(data) {
  return request({
    url: '/Duty/GetDutyFrequencyBySchoolIds',
    method: 'post',
    data
  })
}

//获取排班计划列表数据
export function GetDutyPlanPage(data) {
  return request({
    url: '/DutyPlan/GetDutyPlanPage',
    method: 'post',
    data
  })
}

//删除值班计划
export function RemoveDutyPlan(data) {
  return request({
    url: '/DutyPlan/RemoveDutyPlan',
    method: 'post',
    data
  })
}

//保存排课计划
export function SaveDutyPlan(data) {
  return request({
    url: '/DutyPlan/SaveDutyPlan',
    method: 'post',
    data
  })
}

//获取排班计划信息
export function queryDutyPlanInfo(data) {
  return request({
    url: '/DutyPlan/GetDutyPlan',
    method: 'post',
    data
  })
}


//获取我的排班计划
export function queryMyDutyPlanPage(data) {
  return request({
    url: '/DutyPlan/GetMyDutyPlanPage',
    method: 'post',
    data
  })
}

//获取我的值班看板
export function OnDuty(data) {
  return request({
    url: '/DutyPlan/OnDuty',
    method: 'post',
    data
  })
}

//获取我的值班内容
export function queryDutyWork(data) {
  return request({
    url: '/DutyPlan/GetDutyWork',
    method: 'post',
    data
  })
}


//获取我的值班看板【第二版】
export function OnDuty_V2(data) {
  return request({
    url: '/DutyPlan/OnDuty_V2',
    method: 'post',
    data
  })
}

//获取我的值班内容【第二版】
export function queryDutyWork_V2(data) {
  return request({
    url: '/DutyPlan/GetDutyWork_V2',
    method: 'post',
    data
  })
}

//获取访客列表
export function queryVisitorPage(data) {
  return request({
    url: '/DutyPlan/GetVisitorPage',
    method: 'post',
    data
  })
}

//新增修改访客
export function setVisitor(data) {
  return request({
    url: '/DutyPlan/SetVisitor',
    method: 'post',
    data
  })
}

//修改访客创建人员
export function setVisitorCreateBy(data) {
  return request({
    url: '/DutyPlan/UpdateVisitorCreateBy',
    method: 'post',
    data
  })
}

//根据编号查询访客信息
export function queryVisitor(data) {
  return request({
    url: '/DutyPlan/GetVisitor',
    method: 'post',
    data
  })
}

//修改访客状态
export function updateVisitor(data) {
  return request({
    url: '/DutyPlan/UpdateVisitor',
    method: 'post',
    data
  })
}

//修改访客删除状态
export function setVisitorStatus(data) {
  return request({
    url: '/DutyPlan/RemoveVisitor',
    method: 'post',
    data
  })
}

//删除值班内容
export function removeDutyContent(data) {
  return request({
    url: '/DutyPlan/RemoveDutyContent',
    method: 'post',
    data
  })
}

//新增修改值班内容
export function SetDutyContent(data) {
  return request({
    url: '/DutyPlan/SetDutyContent',
    method: 'post',
    data
  })
}

//值班签到
export function DutyCheck(data) {
  return request({
    url: '/DutyPlan/DutyCheck',
    method: 'post',
    data
  })
}


/**
 * 值班打卡/值班交接
 * @param {JSON参数} data 
 */
export function saveDutyCheck(data) {
  return request({
    url: '/DutyPlan/DutyCheck',
    method: 'post',
    data
  })
}

/**
 * 约课管理
 * @param {JSON参数} data 
 */
export function GetReserveClassPage(data) {
  return request({
    url: '/VisitorReserve/GetReserveClassPage',
    method: 'post',
    data
  })
}

/**
 * 设置约课信息
 * @param {JSON参数} data 
 */
export function SetVisitorReserve(data) {
  return request({
    url: '/VisitorReserve/SetVisitorReserve',
    method: 'post',
    data
  })
}

/**
 * 约课管理
 * @param {JSON参数} data 
 */
export function queryVisitorReservePage(data) {
  return request({
    url: '/VisitorReserve/GetVisitorReservePage',
    method: 'post',
    data
  })
}


/**
 * 删除试听课程
 * @param {JSON参数} data 
 */
export function RemoveReserveClass(data) {
  return request({
    url: '/VisitorReserve/RemoveReserveClass',
    method: 'post',
    data
  })
}

/**
 * 保存修改听课程
 * @param {JSON参数} data 
 */
export function SetReserveClass(data) {
  return request({
    url: '/VisitorReserve/SetReserveClass',
    method: 'post',
    data
  })
}


/**
 * 获取约课班级详情
 * @param {JSON参数} data 
 */
export function GetReserveClass(data) {
  return request({
    url: '/VisitorReserve/GetReserveClass',
    method: 'post',
    data
  })
}

/**
 * 修改预约状态
 * @param {JSON参数} data 
 */
export function setVisitorReserveStatus(data) {
  return request({
    url: '/VisitorReserve/UpdateVisitorReserveStatus',
    method: 'post',
    data
  })
}

/**
 * 删除约课数据
 * @param {JSON参数} data 
 */
export function RemoveVisitorReserve(data) {
  return request({
    url: '/VisitorReserve/RemoveVisitorReserve',
    method: 'post',
    data
  })
}

/**
 * 获取交接班次
 * @param {JSON参数} data 
 */
export function GetHandoverShiftList() {
  return request({
    url: '/DutyPlan/GetHandoverShiftList',
    method: 'post',
    data: ""
  })
}

/**
 * 获取节假日计划分页列表
 * @param {JSON参数} data 
 */
export function getHolidayPlanList(data) {
  return request({
    url: '/Holiday/GetHolidayList',
    method: 'post',
    data: data
  })
}

/**
 * 获取节假日计划详情
 * @param {JSON参数} data 
 */
export function getHolidayInfo(data) {
  return request({
    url: '/Holiday/GetHolidayInfo',
    method: 'post',
    data: data
  })
}

/**
 * 新增节假日计划
 * @param {JSON参数} data 
 */
export function setHolidayPlan(data) {
  return request({
    url: '/Holiday/SetHoliday ',
    method: 'post',
    data: data
  })
}

/**
 * 删除节假日计划
 * @param {JSON参数} data 
 */
export function delHolidayPlan(data) {
  return request({
    url: '/Holiday/DelHoliday ',
    method: 'post',
    data: data
  })
}
/**
 * 获取日期范围 所有排课计划列表
 * @param {JSON参数} data 
 */
export function getToDayCoursePlanList(data) {
  return request({
    url: '/TeacherClass/GetToDayCoursePlanList',
    method: 'post',
    data: data
  })
}