import request from '../../utils/request'
import request_zc from '../../utils/request_zc'


/**
 * 获取学校分页列表
 * 
 */
export function getSchoolPage(data) {
  return request({
    url: '/user/GetSchoolPageList',
    method: 'post',
    data
  })
}

/**
 * 获取学校列表
 * 
 */
export function getSchoolDropdown(data) {
  return request({
    url: '/user/GetSchoolList',
    method: 'post',
    data
  })
}

/**
 * 获取学校分页列表
 */
export function saveSchool(data) {
  return request({
    url: '/user/SetSchool',
    method: 'post',
    data
  })
}

/**
 * 根据校区编号获取校区信息
 */
export function getSchoolInfo(data) {
  return request({
    url: '/user/GetSchool',
    method: 'post',
    data
  })
}

/**
 * 获取教师分页数据 
 */
export function getTeacherPage(data) {
  return request({
    url: '/user/GetTeacherPageList',
    method: 'post',
    data
  })
}


/**
 * 获取教师分页数据 
 */
export function queryTeacherSpecialty(data) {
  return request({
    url: '/user/GetTeacherSpecialty',
    method: 'post',
    data
  })
}

/**
 * 获取讲师列表
 */
export function getTeacherDropDownList(data) {
  return request({
    url: '/user/GetTeacherList',
    method: 'post',
    data
  })
}

/**
 * 保存教师信息
 */
export function saveTeacher(data) {
  return request({
    url: '/user/SetTeacher',
    method: 'post',
    data
  })
}
/**
 * 教师审核
 */
export function auditTeacher(data) {
  return request({
    url: '/user/AuditTeacher',
    method: 'post',
    data
  })
}

/**
 * 
 * @param {TId} data 
 */
export function deleteTeacher(data) {
  return request({
    url: '/user/RemoveTeacher',
    method: 'post',
    data
  })
}

/**
 * 重新审核审核
 * @param {TId} data 
 */
export function reApplyTeacher(data) {
  return request({
    url: '/user/ReApplyTeacher',
    method: 'post',
    data
  })
}

/**
 * 获取助教分页数据 
 */
export function getAssistPage(data) {
  return request({
    url: '/user/GetAssistPageList',
    method: 'post',
    data
  })
}

/**
 * 获取助教下拉列表
 * @param {JSON对象} data 
 */
export function getAssistDropDownList(data) {
  return request({
    url: '/user/GetAssistList',
    method: 'post',
    data
  })
}

/**
 * 保存教师信息
 */
export function saveAssist(data) {
  return request({
    url: '/user/SetAssist',
    method: 'post',
    data
  })
}

/**
 * 教师审核
 */
export function auditAssist(data) {
  return request({
    url: '/user/AuditAssist',
    method: 'post',
    data
  })
}

/**
 * 助教删除
 * @param {AId} data 
 */
export function deleteAssist(data) {
  return request({
    url: '/user/RemoveAssist',
    method: 'post',
    data
  })
}

/**
 * 助教重新申请审核
 * @param {AId} data 
 */
export function reApplyAssist(data) {
  return request({
    url: '/user/ReApplyAssist',
    method: 'post',
    data
  })
}

/**
 * 获取班级分页列表
 * @param {JSON数据} data 
 */
export function getClassPage(data) {
  return request({
    url: '/Class/GetClassPageList',
    method: 'post',
    data
  })
}

/**
 * 获取班级列表【下拉使用】
 * @param {JSON数据} data 
 */
export function getClassDropDownList(data) {
  return request({
    url: '/Class/GetClassList',
    method: 'post',
    data
  })
}

/**
 * 新增修改班级
 * @param {JSON数据} data 
 */
export function saveClass(data) {
  return request({
    url: '/Class/SetClass',
    method: 'post',
    data
  })
}

/**
 * 批量添加上课计划
 * @param {JSON数据} data 
 */
export function batchSaveClassPlan(data) {
  return request({
    url: '/Class/BatchSetClassPlan',
    method: 'post',
    data
  })
}


/**
 * 新增修改班级
 * @param {JSON数据} data 
 */
export function getClassInfo(data) {
  return request({
    url: '/Class/GetClass',
    method: 'post',
    data
  })
}

/**
 * 删除班级
 * @param {JSON数据} data 
 */
export function deleteClass(data) {
  return request({
    url: '/Class/RemoveClass',
    method: 'post',
    data
  })
}

/**
 * 获取学员分页列表
 * @param {JSON数据} data 
 */
export function getStudentPage(data) {
  return request({
    url: '/User/GetStudentPageList',
    method: 'post',
    data
  })
}

/**
 * 获取学员下拉类表
 */
export function getStudentDorpDownList(data) {
  return request({
    url: '/User/GetStudentList',
    method: 'post',
    data
  })
}


/**
 * 添加修改学员
 */
export function saveStudent(data) {
  return request({
    url: '/User/SetStudent',
    method: 'post',
    data
  })
}


/**
 * 获取客户阶段列表
 */
export function queryStuStageList()
{
  return request({
    url: '/CustomerStudent/GetStageDropdownList',
    method: 'post',
  })
}

/**
 * 获取学员信息
 */
export function getStudentInfo(data) {
  return request({
    url: '/User/GetStudent',
    method: 'post',
    data
  })
}

/**
 * 删除学员信息
 */
export function deleteStudent(data) {
  return request({
    url: '/User/RemoveStudent',
    method: 'post',
    data
  })
}

/**
 * 更新学生禁用或启用
 */
export function UpdateStudentIsDisable(data) {
  return request({
    url: '/User/UpdateStudentIsDisable',
    method: 'post',
    data
  })
}

/**
 * 创建学生账号
 */
export function createStudentAccount(data) {
  return request({
    url: '/User/CreateStudentAccount',
    method: 'post',
    data
  })
}

/**
 * 获取管理者分页列表
 */
export function queryManagerPage(data) {
  return request({
    url: '/User/GetManagerPageList',
    method: 'post',
    data
  })
}

/**
 * 新增修改管理者
 */
export function saveManager(data) {
  return request({
    url: '/User/SetEmployee',
    method: 'post',
    data
  })
}

/**
 * 获取管理者信息
 */
export function queryEmployeeInfo(data) {
  return request({
    url: '/User/GetEmployee',
    method: 'post',
    data
  })
}


/**
 * 获取管理者信息
 */
export function deleteManagerInfo(data) {
  return request({
    url: '/User/RemoveManager',
    method: 'post',
    data
  })
}

/**
 * 创建管理者账号
 */
export function createManagerAccount(data) {
  return request({
    url: '/User/CreateManagerAccount',
    method: 'post',
    data
  })
}

/**
 * 获取学历列表
 * 
 */
export function getEducation(data) {
  return request({
    url: '/User/GetEducationList',
    method: 'post',
    data
  });
}

/**
 * 获取在职状态
 * 
 */
export function GetLeaveStatus(data) {
  return request({
    url: '/User/GetLeaveStatus',
    method: 'post',
    data
  });
}

/**
 * 获取教室分页列表
 * 
 */
export function queryClassRoomPage(data) {
  return request({
    url: '/ClassRoom/GetClassRoomPageList',
    method: 'post',
    data
  });
}

/**
 * 获取教室列表
 */
export function queryClassRoomList(data) {
  return request({
    url: '/ClassRoom/GetClassRoomList',
    method: 'post',
    data
  });
}

/**
 * 新增修改教室
 */
export function saveClassRoom(data) {
  return request({
    url: '/ClassRoom/SetClassRoom',
    method: 'post',
    data
  });
}

/**
 * 根据教室编号获取教室详情
 */
export function quertClassRoomInfo(data) {
  return request({
    url: '/ClassRoom/GetClassRoom',
    method: 'post',
    data
  });
}

/**
 * 根据教室编号删除教室
 */
export function deleteClassRoomInfo(data) {
  return request({
    url: '/ClassRoom/RemoveClassRoom',
    method: 'post',
    data
  });
}

/***
 * 获取行政备注类型下拉列表
 */
export function queryRemarkTypeList() {
  return request({
    url: '/User/GetAccountRemarkTypeEnumList',
    method: 'post',
    data: ""
  });
}

/***
 * 新增修改行政备注
 */
export function saveAccountRemark(data) {
  return request({
    url: '/User/SetAccountRemark',
    method: 'post',
    data
  });
}


/**
 * 获取行政备注分页列表
 */
export function queryRemarkPage(data) {
  return request({
    url: '/user/GetAccountRemarkPageList',
    method: 'post',
    data
  });
}

/**
 * 获取用户修改日志
 */
export function queryEmpChangeLog(data) {
  return request({
    url: '/user/GetEmpChangeLog',
    method: 'post',
    data
  });
}
// 获取用户领用资产的数量(用户教育用户列表 展示资产使用情况)
export function getEduEmployeeNumList(data) {
  return request_zc({
      url: '/property/GetEduEmployeeReceiveNumList',
      method: 'post',
      data
  });
}
//获取用户资产列表
export function propertyGetPageList(data) {
  return request_zc({
      url: '/property/PropertyGetPageList',
      method: 'post',
      data
  });
}
/**
 *  获取班级下拉_（出库单）
 *
 */
 export function getClassPage_ck(data) {
  return request({
    url: '/class/GetClassListForProperty',
    method: 'post',
    data
  })
}

/**
 * 验证用户是否有 需补交提成订单
 */
 export function getUserLeaveOrderCommission(data) {
  return request({
    url: '/SellCommission/GetUserLeaveOrderCommission',
    method: 'post',
    data
  });
}

/**
 * 保存调课申请单
 */
export function SetChangeClassPlan(data) {
  return request({
    url: '/ChangePlan/SetChangeClassPlan',
    method: 'post',
    data
  });
}

/**
 * 保存转班申请单
 */
export function SetOrderChange(data) {
  return request({
    url: '/OrderChange/SetOrderChange',
    method: 'post',
    data
  });
}

/**
 * 保存分拆申请
 */
export function SetOrderSplit(data) {
  return request({
    url: '/OrderChange/SetOrderSplit',
    method: 'post',
    data
  });
}

/**
 * 获取上课计划冲突数据
 */
export function GetRepeatClassPlan(data) {
  return request({
    url: '/Class/GetRepeatClassPlan',
    method: 'post',
    data
  });
}

/**
 * 保存单个上课计划冲突修改
 */
export function UpdateClassPlanSingle(data) {
  return request({
    url: '/Class/UpdateClassPlanSingle',
    method: 'post',
    data
  });
}

/**
 * 保存批量修改
 */
export function BatchUpdateClassPlan(data) {
  return request({
    url: '/Class/BatchUpdateClassPlan',
    method: 'post',
    data
  });
}

/**
 * 忽略上课调整
 */
export function IgnoreClassPlan(data) {
  return request({
    url: '/Class/IgnoreClassPlan',
    method: 'post',
    data
  });
}

/**
 * 获取客户类型下拉
 */
export function GetStudentTypeList(data) {
  return request({
    url: '/CustomerStudent/GetStudentTypeList',
    method: 'post',
    data
  });
}

/**
 * 获取客户需求下拉
 */
export function GetNeedsList(data) {
  return request({
    url: '/CustomerStudent/GetNeedsList',
    method: 'post',
    data
  });
}

/**
 * 获取我的下属下拉
 */
export function GetPersonalDimension(data) {
  return request({
    url: '/OKRPeriod/GetPersonalDimension',
    method: 'post',
    data
  });
}

/**
 * 获取试听课程列表下拉
 */
export function GetTrialLessonList(data) {
  return request({
    url: '/Course/GetTrialLessonList',
    method: 'post',
    data
  });
}

/**
 * 获取关联题库等级
 */
export function GetBankTypeList(data) {
  return request({
    url: '/Question/GetBankTypeList',
    method: 'post',
    data
  });
}