import request from '../../utils/request'

/**
 * 获取菜单类型列表
 */
export function getMenuTypeList() {
  var MenuTypeOpts = [{
      label: '全部',
      value: -1
    },
    {
      label: '管理端',
      value: 1
    },
    {
      label: '教师端',
      value: 2
    },
    {
      label: '助教端',
      value: 3
    },
    {
      label: '学生端',
      value: 4
    }
  ];
  return MenuTypeOpts;
}

/**
 * 获取菜单等级列表
 */
export function getMenuLevelList() {
  var MenuLevelOpts = [{
      label: '全部',
      value: -1
    },
    {
      label: '一级',
      value: 1
    },
    {
      label: '二级',
      value: 2
    },
    {
      label: '三级',
      value: 3
    }
  ];
  return MenuLevelOpts;
}

/**
 * 获取部门层级列表
 */
export function getDeptTierList() {
  var deptTierOpts = [{
      label: '不限',
      value: 0
    },
    {
      label: '1级',
      value: 1
    },
    {
      label: '2级',
      value: 2
    },
    {
      label: '3级',
      value: 3
    },
    {
      label: '4级',
      value: 4
    },
    {
      label: '5级',
      value: 5
    },
    {
      label: '6级',
      value: 6
    },
    {
      label: '7级',
      value: 7
    },
    {
      label: '8级',
      value: 8
    },
    {
      label: '9级',
      value: 9
    },
    {
      label: '10级',
      value: 10
    },
  ];
  return deptTierOpts;
}

/**
 * 获取菜单分页列表
 * 
 */
export function getMenuPage(data) {
  return request({
    url: '/Public/GetMenuPageList',
    method: 'post',
    data
  })
}

/**
 * 获取菜单类表
 * @param {参数} data 
 */
export function getMenuList(data) {
  return request({
    url: '/Public/GetMenuList',
    method: 'post',
    data
  })
}

/**
 * 获取菜单详情
 * @param {JSON参数} data 
 */
export function getMenuInfo(data) {
  return request({
    url: '/Public/GetMenu',
    method: 'post',
    data
  })
}

/**
 * 保存菜单
 * @param {菜单实体} data 
 */
export function saveMenu(data) {
  return request({
    url: '/Public/SetMenu',
    method: 'post',
    data
  })
}

/**
 * 设置菜单状态
 * @param {JSON参数对象} data 
 */
export function updateMenuStatus(data) {
  return request({
    url: '/Public/SetMenuStatus',
    method: 'post',
    data
  })
}

/**
 * 获取树形结构菜单
 * @param {JSON参数} data 
 */
export function queryTreeMenu(data) {
  return request({
    url: '/Public/GetTreeMenu',
    method: 'post',
    data
  })
}

/**
 * 获取菜单功能权限分页列表
 */
export function queryMenuFunctionPage(data) {
  return request({
    url: '/Public/GetMenuFunctionPage',
    method: 'post',
    data
  })
}

/**
 * 新增修改菜单功能权限
 */
export function saveMenuFunction(data) {
  return request({
    url: '/Public/SetMenuFunction',
    method: 'post',
    data
  })
}

/**
 * 根据菜单功能权限编号获取功能权限实体
 */
export function queryMenuFunction(data) {
  return request({
    url: '/Public/GetMenuFunction',
    method: 'post',
    data
  })
}

/**
 * 修改菜单功能权限状态
 */
export function saveMenuFunctionStatus(data) {
  return request({
    url: '/Public/SetMenuFunctionStatus',
    method: 'post',
    data
  })
}

/**
 * 获取角色分页列表
 * @param {JSON参数} data 
 */
export function queryRolePage(data) {
  return request({
    url: '/Public/GetRolePageList',
    method: 'post',
    data
  })
}

/**
 * 获取角色列表
 * @param {JSON参数} data 
 */
export function queryRoleDropdown(data) {
  return request({
    url: '/Public/GetRoleList',
    method: 'post',
    data
  })
}

/**
 * 获取角色详情
 * @param {JSON参数} data 
 */
export function queryRoleInfo(data) {
  return request({
    url: '/Public/GetRole',
    method: 'post',
    data
  })
}

/**
 * 保存角色
 * @param {JSON参数} data 
 */
export function saveRoleInfo(data) {
  return request({
    url: '/Public/SetRole',
    method: 'post',
    data
  })
}

/**
 * 修改角色状态
 * @param {JSON对象} data 
 */
export function setRoleStatus(data) {
  return request({
    url: '/Public/SetRoleStatus',
    method: 'post',
    data
  })
}

/**
 * 获取角色菜单和功能权限
 * @param {JSON对象} data 
 */
export function GetRolePermission(data) {
  return request({
    url: '/Public/GetRolePermission',
    method: 'post',
    data
  })
}

/**
 * 保存角色权限
 */
export function SetRolePermission(data) {
  return request({
    url: '/Public/SetRolePermission',
    method: 'post',
    data
  })
}

/**
 * 获取短信配置发送状态下拉
 */
export function getConfigStatus(data) {
  return request({
    url: '/Public/GetStoreTypeEnumList',
    method: 'post',
    data
  });
}

/**
 * 获取基础设置
 */
export function GetClassConfig(data) {
  return request({
    url: '/Public/GetClassConfig',
    method: 'post',
    data
  });
}

/**
 * 保存基础设置
 */
export function SetClassConfig(data) {
  return request({
    url: '/Public/SetClassConfig',
    method: 'post',
    data
  });
}

/**
 * 新增班级类型
 */
export function SetClassType(data) {
  return request({
    url: '/Public/SetClassType',
    method: 'post',
    data
  });
}

/**
 * 新增班级类型
 */
export function GetClassTypePageList(data) {
  return request({
    url: '/Public/GetClassTypePageList',
    method: 'post',
    data
  });
}

/**
 * 删除班级类型
 */
export function RemoveClassType(data) {
  return request({
    url: '/Public/RemoveClassType',
    method: 'post',
    data
  });
}

/**
 * 获取班级类型下拉
 */
export function GetClassTypeList(data) {
  return request({
    url: '/Public/GetClassTypeList',
    method: 'post',
    data
  });
}

/**
 * 获取退课流程设置
 */
export function queryBackClassFlow(data) {
  return request({
    url: '/Flow/GetBackClassFlow',
    method: 'post',
    data
  });
}

/**
 * 保存退课流程设置
 */
export function saveBackClassFlow(data) {
  return request({
    url: '/Flow/SetBackClassFlow',
    method: 'post',
    data
  });
}

/**
 * 上课计划 获取列表
 */
export function GetClassPlanStatistical(data) {
  return request({
    url: '/Class/GetClassPlanStatistical',
    method: 'post',
    data
  });
}
/**
 * 获取各平台枚举列表
 */
 export function getContributeConfigTypeEnumList(data) {
  return request({
    url: '/QYContribute/GetContributeConfigTypeEnumList',
    method: 'post',
    data
  });
}
/**
 * 获取平台配置信息
 */
 export function getContributeConfigInfo(data) {
  return request({
    url: '/QYContribute/GetContributeConfigInfo',
    method: 'post',
    data
  });
}
/**
 * 保存平台配置
 */
 export function setContributeConfigInfo(data) {
  return request({
    url: '/QYContribute/SetContributeConfigInfo',
    method: 'post',
    data
  });
}

/**
 * 获取客户阶段管理列表
 */
export function GetStageList(data) {
  return request({
    url: '/CustomerStudent/GetStageList',
    method: 'post',
    data
  });
}

/**
 * 新增修改客户阶段
 */
export function SetStage(data) {
  return request({
    url: '/CustomerStudent/SetStage',
    method: 'post',
    data
  });
}

/**
 * 删除客户阶段
 */
export function RemoveStage(data) {
  return request({
    url: '/CustomerStudent/RemoveStage',
    method: 'post',
    data
  });
}


/**
 * 获取客户类型列表
 */
export function GetStudentTypeList(data) {
  return request({
    url: '/CustomerStudent/GetStudentTypeList',
    method: 'post',
    data
  });
}

/**
 * 新增修改客户类型
 */
export function SetStudentType(data) {
  return request({
    url: '/CustomerStudent/SetStudentType',
    method: 'post',
    data
  });
}

/**
 * 删除客户类型
 */
export function RemodeStudentType(data) {
  return request({
    url: '/CustomerStudent/RemodeStudentType',
    method: 'post',
    data
  });
}

/**
 * 获取学习目的分页列表
 */
export function GetLearningGoalsPage(data) {
  return request({
    url: '/CustomerStudent/GetLearningGoalsPage',
    method: 'post',
    data
  });
}



/**
 * 新增修改学习目的
 */
export function SetLearningGoals(data) {
  return request({
    url: '/CustomerStudent/SetLearningGoals',
    method: 'post',
    data
  });
}

/**
 * 根据编号获取学习目的详情
 */
export function GetLearningGoals(data) {
  return request({
    url: '/CustomerStudent/GetLearningGoals',
    method: 'post',
    data
  });
}

/**
 * 根据编号删除学习目的
 */
export function RemoveLearningGoals(data) {
  return request({
    url: '/CustomerStudent/RemoveLearningGoals',
    method: 'post',
    data
  });
}

/**
 * 获取收客渠道分页列表
 */
export function GetChannelPage(data) {
  return request({
    url: '/CustomerStudent/GetChannelPage',
    method: 'post',
    data
  });
}



/**
 * 新增修改收客渠道
 */
export function SetChannel(data) {
  return request({
    url: '/CustomerStudent/SetChannel',
    method: 'post',
    data
  });
}

/**
 * 根据编号获取收客渠道详情
 */
export function GetChannel(data) {
  return request({
    url: '/CustomerStudent/GetChannel',
    method: 'post',
    data
  });
}

/**
 * 根据编号删除收客渠道
 */
export function RemoveChannel(data) {
  return request({
    url: '/CustomerStudent/RemoveChannel',
    method: 'post',
    data
  });
}

/**
 * 获取客户需求分页
 */
export function GetNeedsPage(data) {
  return request({
    url: '/CustomerStudent/GetNeedsPage',
    method: 'post',
    data
  });
}

/**
 * 新增修改
 */
export function SetNeeds(data) {
  return request({
    url: '/CustomerStudent/SetNeeds',
    method: 'post',
    data
  });
}

/**
 * 根据编号获取
 */
export function GetNeeds(data) {
  return request({
    url: '/CustomerStudent/GetNeeds',
    method: 'post',
    data
  });
}

/**
 * 根据编号删除
 */
export function RemoveNeeds(data) {
  return request({
    url: '/CustomerStudent/RemoveNeeds',
    method: 'post',
    data
  });
}

/**
 * 获取目标分页列表
 */
export function GetConsultantGoalPage(data) {
  return request({
    url: '/UserCenter/GetConsultantGoalPage',
    method: 'post',
    data
  });
}

/**
 * 批量添加目标
 */
export function AddConsultantGoal(data) {
  return request({
    url: '/UserCenter/AddConsultantGoal',
    method: 'post',
    data
  });
}

/**
 * 删除目标
 */
export function RemoveConsultantGoal(data) {
  return request({
    url: '/UserCenter/RemoveConsultantGoal',
    method: 'post',
    data
  });
}

/**
 * 修改目标
 */
export function UpdateConsultantGoal(data) {
  return request({
    url: '/UserCenter/UpdateConsultantGoal',
    method: 'post',
    data
  });
}

/**
 * 获取目标详情
 */
export function GetConsultantGoal(data) {
  return request({
    url: '/UserCenter/GetConsultantGoal',
    method: 'post',
    data
  });
}

/**
 * 获取留学就业类型分页列表
 */
export function GetStudyabroadTypePage(data) {
  return request({
    url: '/StudyAbroad/GetStudyabroadTypePage',
    method: 'post',
    data
  });
}
/**
 * 根据编号删除留学就业类型
 */
export function RemoveStudyabroadType(data) {
  return request({
    url: '/StudyAbroad/RemoveStudyabroadType',
    method: 'post',
    data
  });
}

/**
 * 留学就业类型列表(下拉使用)
 */
export function GetStudyabroadTypeList(data) {
  return request({
    url: '/StudyAbroad/GetStudyabroadTypeList',
    method: 'post',
    data
  });
}

/**
 * 新增修改留学就业类型
 */
export function SetStudyabroadType(data) {
  return request({
    url: '/StudyAbroad/SetStudyabroadType',
    method: 'post',
    data
  });
}


/**
 * 根据编号获取留学就业类型实体详情
 */
export function GetStudyabroadType(data) {
  return request({
    url: '/StudyAbroad/GetStudyabroadType',
    method: 'post',
    data
  });
}

/**
 * 获取课程顾问跟进配置分页列表
 */
export function GetStudentAdvisorConfigPage(data) {
  return request({
    url: '/User/GetStudentAdvisorConfigPage',
    method: 'post',
    data
  });
}

/**
 * 根据编号获取课程顾问配置信息
 */
export function GetStudentAdvisorConfig(data) {
  return request({
    url: '/User/GetStudentAdvisorConfig',
    method: 'post',
    data
  });
}

/**
 * 新增修改课程顾问配置
 */
export function SetStudentAdvisorConfig(data) {
  return request({
    url: '/User/SetStudentAdvisorConfig',
    method: 'post',
    data
  });
}

/**
 * 根据编号删除课程顾问配置信息
 */
export function RemoveStudentAdvisorConfig(data) {
  return request({
    url: '/User/RemoveStudentAdvisorConfig',
    method: 'post',
    data
  });
}



