import request from '../../utils/request'

/**
 * 获取课程分页列表
 * @param {JSON参数} data
 */
export function GetClassPageList(data) {
  return request({
    url: '/TeacherClass/GetClassPageList',
    method: 'post',
    data
  })
}

/**
 * 获取课程分页列表
 * @param {JSON参数} data
 */
export function GetClassMonthStatistics(data) {
  return request({
    url: '/TeacherClass/GetClassMonthStatistics',
    method: 'post',
    data
  })
}

/**
 * 获取我的课表分页列表
 * @param {JSON参数} data
 */
export function GetClassPlanStatistical(data) {
  return request({
    url: '/TeacherClass/GetClassPlanStatistical',
    method: 'post',
    data
  })
}

/**
 * 获取我的课表列表数据
 * @param {JSON参数} data
 */
export function GetClassPlanStatisticalPage(data) {
  return request({
    url: '/TeacherClass/GetClassPlanStatisticalPage',
    method: 'post',
    data
  })
}

/**
 * 获取我调课申请列表
 * @param {JSON参数} data
 */
export function GetEducationReceiptPage(data) {
  return request({
    url: '/EducationReceipt/GetEducationReceiptPage',
    method: 'post',
    data
  })
}

/**
 * 获取下拉数据
 * @param {JSON参数} data
 */
export function GetEducationReceiptType() {
  return request({
    url: '/EducationReceipt/GetEducationReceiptType',
    method: 'post'
  })
}

/**
 * 获取下拉数据
 * @param {JSON参数} data
 */
export function GetEduReceiptInfo(data) {
  return request({
    url: '/EducationReceipt/GetEduReceiptInfo ',
    method: 'post',
    data
  })
}

/**
 * 单据作废
 * @param {JSON参数} data
 */
export function invalidReceiptInfo(data) {
  return request({
    url: '/EducationReceipt/InvalidReceipt',
    method: 'post',
    data
  })
}

/**
 * 获取当前单据审核人员
 * @param {JSON参数} data
 */
export function queryCurrentAuditMan(data) {
  return request({
    url: '/EducationReceipt/GetCurrentAuditMan',
    method: 'post',
    data
  })
}

/**
 * 修改当前单据审核人员
 * @param {JSON参数} data
 */
export function saveAuditMan(data) {
  return request({
    url: '/EducationReceipt/EditAuditMan',
    method: 'post',
    data
  })
}

/**
 * 获取试卷分页列表
 * @param {JSON参数} data
 */
export function GetPaperPage(data) {
  return request({
    url: '/Exam/GetPaperPage',
    method: 'post',
    data
  })
}

/**
* 获取试卷分页列表
* @param {JSON参数} data
*/
export function submitApproval(data) {
  return request({
    url: '/Exam/SubmitApproval',
    method: 'post',
    data
  })
}


/**
 * 根据编号获取试卷题目
 * @param {JSON参数} data
 */
export function GetPaper(data) {
  return request({
    url: '/Exam/GetPaper',
    method: 'post',
    data
  })
}

/**
 * 考试获取考试题目
 * @param {JSON参数} data
 */
export function queryPaperDetails(data) {
  return request({
    url: '/AppletIndex/GetPaperDetails',
    method: 'post',
    data
  })
}

/**
 * 考试获取考试题目
 * @param {JSON参数} data
 */
export function stuSubmitExamPaper(data) {
  return request({
    url: '/AppletIndex/StuSubmitExamPaper',
    method: 'post',
    data
  })
}

/**
 * 老师阅卷
 * @param {JSON参数} data
 */
export function saveTeacherScoring(data) {
  return request({
    url: '/Exam/SetTeacherScoring',
    method: 'post',
    data
  })
}

/**
 * 保存试卷信息
 * @param {JSON参数} data
 */
export function savePaperInfo(data) {
  return request({
    url: '/Exam/SetPaper',
    method: 'post',
    data
  })
}

/**
 * 新增修改文件夹
 * @param {JSON参数} data
 */
export function savePaperFolderInfo(data) {
  return request({
    url: '/Exam/SetPaperFolder',
    method: 'post',
    data
  })
}

/**
 * 批量设置开放状态
 * @param {JSON参数} data
 */
export function batchSetIsOpen(data) {
  return request({
    url: '/Exam/BatchSetIsOpen',
    method: 'post',
    data
  })
}

/**
 * 智能组卷根据模板生成试卷
 * @param {JSON参数} data
 */
export function savePaperTemplate(data) {
  return request({
    url: '/Exam/SetPaperTemplate',
    method: 'post',
    data
  })
}

/**
 * 发布考试
 * @param {JSON参数} data
 */
export function savePublishExam(data) {
  return request({
    url: '/Exam/PublishExam',
    method: 'post',
    data
  })
}


/**
 * 获取考卷分页列表
 * @param {JSON参数} data
 */
export function queryPublishExamPage(data) {
  return request({
    url: '/Exam/GetPublishExamPage',
    method: 'post',
    data
  })
}

/**
 * 提交考试审核
 * @param {JSON参数} data
 */
export function submitExamApply(data) {
  return request({
    url: '/Exam/SubmitExamApply',
    method: 'post',
    data
  })
}

/**
 * 删除考卷
 * @param {JSON参数} data
 */
export function deletePublishExam(data) {
  return request({
    url: '/Exam/RemovePublishExam',
    method: 'post',
    data
  })
}


/**
 * 根据编号获取考卷发布信息
 * @param {JSON参数} data
 */
export function queryExamPublish(data) {
  return request({
    url: '/Exam/GetExamPublish',
    method: 'post',
    data
  })
}

/**
 * 获取考卷考生列表
 * @param {JSON参数} data
 */
export function getExaminationStudentPage(data) {
  return request({
    url: '/Exam/GetExaminationStudentPage',
    method: 'post',
    data
  })
}

/** 删除试卷、文件夹
* @param {*} data 
*/
export function deletePaperInfo(data) {
  return request({
    url: '/Exam/DeletePaper',
    method: 'post',
    data
  })
}

/**
 * 复制试卷
 * @param {*} data 
 */
export function copyPaperInfo(data) {
  return request({
    url: '/Exam/CopyPaper',
    method: 'post',
    data
  })
}


/**
 * 获取文件夹树形结构
 * @param {*} data 
 */
export function queryFolderTree(data) {
  return request({
    url: '/Exam/GetFolderTree',
    method: 'post',
    data
  })
}

/**
 * 移动到文件夹
 * @param {*} data 
 */
export function movePaperInfo(data) {
  return request({
    url: '/Exam/MovePaper',
    method: 'post',
    data
  })
}

/**
 * 获取上课反馈信息
 * @param {*} data 
 */
export function getFeedBackDetails(data) {
  return request({
    url: '/TeacherClass/GetFeedBackDetails',
    method: 'post',
    data
  })
}

/**
 * 新增/修改上课反馈
 * @param {*} data 
 */
export function setFeedBack(data) {
  return request({
    url: '/TeacherClass/SetFeedBack',
    method: 'post',
    data
  })
}