import request from '../../utils/request'

/**
 * 获取学员管理列表
 * @param {JSON参数} data
 */
export function GetStuPageList(data) {
  return request({
    url: '/TeacherClass/GetClassStudent',
    method: 'post',
    data
  })
}

/**
 * 创建停课申请单
 * @param {JSON参数} data
 */
export function setStopClassApply(data) {
  return request({
    url: '/StopStudentClass/SetStudentStopClass',
    method: 'post',
    data
  })
}

/**
 * 临时上课邀请，获取学员列表
 * @param {JSON参数} data
 */
export function getNotClassStudentList(data) {
  return request({
    url: '/TeacherClass/GetNotClassStudentList',
    method: 'post',
    data
  })
}


/**
 * 创建临时上课邀请申请单
 * @param {JSON参数} data
 */
export function setStuInviteApply(data) {
  return request({
    url: 'TempInvitationClass/SetStudentTempInvitation',
    method: 'post',
    data
  })
}


/**
 * 获取学员考试列表
 * @param {JSON参数} data
 */
export function queryGuestExaminationPublishPage(data) {
  return request({
    url: 'AppletIndex/GetGuestExaminationPublishPage',
    method: 'post',
    data
  })
}
